/*
 * Decompiled with CFR 0.152.
 */
package io.github.apexdevtools.apexls.types;

import com.financialforce.types.IConstructorDeclaration;
import com.financialforce.types.IFieldDeclaration;
import com.financialforce.types.IMethodDeclaration;
import com.financialforce.types.IPropertyDeclaration;
import com.financialforce.types.base.TypeRef;
import com.nawforce.runtime.types.platform.SObjectTypeDeclaration;
import com.nawforce.runtime.workspace.IModuleTypeDeclaration;
import com.nawforce.runtime.workspace.IPM;
import io.github.apexdevtools.apexls.api.ApexField;
import io.github.apexdevtools.apexls.api.ApexMethod;
import io.github.apexdevtools.apexls.api.ApexResourceFile;
import io.github.apexdevtools.apexls.api.ApexType;
import io.github.apexdevtools.apexls.api.ApexTypeId;
import io.github.apexdevtools.apexls.types.ApexConstructorAdapter;
import io.github.apexdevtools.apexls.types.ApexFieldAdapter;
import io.github.apexdevtools.apexls.types.ApexMethodAdapter;
import io.github.apexdevtools.apexls.types.ApexPropertyAdapter;
import io.github.apexdevtools.apexls.types.NameApexTypeId;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import scala.collection.immutable.ArraySeq;

public class ApexTypeAdapter
implements ApexType {
    private final IModuleTypeDeclaration td;

    public ApexTypeAdapter(IModuleTypeDeclaration iModuleTypeDeclaration) {
        this.td = iModuleTypeDeclaration;
    }

    @Override
    public ApexResourceFile getFile() {
        if (this.td.paths().length != 1) {
            return null;
        }
        String string = this.td.paths()[0];
        Boolean bl = this.index().map(index -> index.issues().issuesForFiles(new String[]{string}, false, 1).length > 0).orElse(false);
        return new ApexResourceFile(string, this.getTypes(this.td), bl);
    }

    private List<ApexType> getTypes(IModuleTypeDeclaration iModuleTypeDeclaration) {
        if (iModuleTypeDeclaration.enclosing().nonEmpty()) {
            return this.getTypes((IModuleTypeDeclaration)iModuleTypeDeclaration.enclosing().get());
        }
        ApexType[] apexTypeArray = new ApexType[1 + iModuleTypeDeclaration.innerTypes().length()];
        apexTypeArray[0] = new ApexTypeAdapter(iModuleTypeDeclaration);
        for (int i = 0; i < iModuleTypeDeclaration.innerTypes().length(); ++i) {
            apexTypeArray[1 + i] = new ApexTypeAdapter((IModuleTypeDeclaration)iModuleTypeDeclaration.innerTypes().apply(i));
        }
        return Arrays.asList(apexTypeArray);
    }

    @Override
    public String getApexName() {
        String string;
        String string2 = this.td.id().toString();
        if (this.td.enclosing().nonEmpty()) {
            string2 = ((IModuleTypeDeclaration)this.td.enclosing().get()).id().toString() + "." + string2;
        }
        if ((string = this.getApexNamespace()).length() != 0) {
            string2 = string + "." + string2;
        }
        return string2;
    }

    @Override
    public String getApexNamespace() {
        return this.pkg().map(IPM.Package::namespaceAsString).orElse("");
    }

    @Override
    public ApexType getEnclosingType() {
        if (!this.module().isPresent() || this.td.enclosing().isEmpty()) {
            return null;
        }
        return new ApexTypeAdapter((IModuleTypeDeclaration)this.td.enclosing().get());
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public boolean isSObject() {
        return this.td instanceof SObjectTypeDeclaration;
    }

    @Override
    public ApexTypeId getParent() {
        return NameApexTypeId.apply(this.td.extendsTypeRef());
    }

    @Override
    public List<ApexTypeId> getInterfaces() {
        if (this.td.implementsTypeList() == null) {
            return null;
        }
        ArraySeq arraySeq = this.td.implementsTypeList();
        NameApexTypeId[] nameApexTypeIdArray = new NameApexTypeId[arraySeq.length()];
        int n = 0;
        for (int i = 0; i < arraySeq.length(); ++i) {
            nameApexTypeIdArray[n++] = NameApexTypeId.apply((TypeRef)arraySeq.apply(i));
        }
        return Arrays.asList(nameApexTypeIdArray);
    }

    @Override
    public String getModifiers() {
        return this.td.annotationsAndModifiers();
    }

    @Override
    public List<ApexMethod> getMethods() {
        int n;
        ApexMethod[] apexMethodArray = new ApexMethod[this.td.constructors().length() + this.td.methods().length()];
        int n2 = 0;
        for (n = 0; n < this.td.constructors().length(); ++n) {
            apexMethodArray[n2++] = new ApexConstructorAdapter(this, (IConstructorDeclaration)this.td.constructors().apply(n));
        }
        for (n = 0; n < this.td.methods().length(); ++n) {
            apexMethodArray[n2++] = new ApexMethodAdapter(this, (IMethodDeclaration)this.td.methods().apply(n));
        }
        return Arrays.asList(apexMethodArray);
    }

    @Override
    public List<ApexField> getFields() {
        int n;
        ApexField[] apexFieldArray = new ApexField[this.td.properties().length() + this.td.fields().length()];
        int n2 = 0;
        for (n = 0; n < this.td.properties().length(); ++n) {
            apexFieldArray[n2++] = new ApexPropertyAdapter(this, (IPropertyDeclaration)this.td.properties().apply(n));
        }
        for (n = 0; n < this.td.fields().length(); ++n) {
            apexFieldArray[n2++] = new ApexFieldAdapter(this, (IFieldDeclaration)this.td.fields().apply(n));
        }
        return Arrays.asList(apexFieldArray);
    }

    private Optional<IPM.Index> index() {
        return this.pkg().map(IPM.Package::org);
    }

    private Optional<IPM.Package> pkg() {
        return this.module().map(IPM.Module::pkg);
    }

    private Optional<IPM.Module> module() {
        return Optional.ofNullable(this.td.module());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.td == ((ApexTypeAdapter)object).td;
    }
}

