/*
 * Decompiled with CFR 0.152.
 */
package io.github.apexdevtools.apexls.types;

import com.financialforce.types.base.TypeRef;
import com.nawforce.pkgforce.names.TypeName;
import com.nawforce.runtime.workspace.IModuleTypeDeclaration;
import io.github.apexdevtools.apexls.api.ApexTypeId;
import java.util.Objects;
import scala.Option;

public class NameApexTypeId
implements ApexTypeId {
    private final String apexName;
    private final String namespace;
    private final boolean isResolved;

    public NameApexTypeId(String string, String string2, boolean bl) {
        assert (string2.length() == 0 || string.startsWith(string2 + '.'));
        this.apexName = string;
        this.namespace = string2;
        this.isResolved = bl;
    }

    public static NameApexTypeId apply(TypeRef typeRef) {
        if (typeRef == null) {
            return null;
        }
        if (typeRef instanceof IModuleTypeDeclaration) {
            IModuleTypeDeclaration iModuleTypeDeclaration = (IModuleTypeDeclaration)typeRef;
            return new NameApexTypeId(iModuleTypeDeclaration.fullName(), iModuleTypeDeclaration.namespaceAsString(), true);
        }
        return new NameApexTypeId(typeRef.fullName(), "", false);
    }

    public static NameApexTypeId apply(Option<TypeRef> option) {
        if (option.isEmpty()) {
            return null;
        }
        return NameApexTypeId.apply((TypeRef)option.get());
    }

    @Override
    public String getApexName() {
        return this.apexName;
    }

    @Override
    public String getApexNamespace() {
        return this.namespace;
    }

    @Override
    public ApexTypeId getEnclosingType() {
        String string = this.namespace.length() == 0 ? this.apexName : this.apexName.substring(this.namespace.length() + 1);
        TypeName typeName = TypeName.fromStringOrNull(string);
        if (typeName == null || typeName.outer().isEmpty()) {
            return null;
        }
        return new NameApexTypeId(((TypeName)typeName.outer().get()).toString(), this.namespace, this.isResolved);
    }

    @Override
    public boolean isResolved() {
        return this.isResolved;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NameApexTypeId nameApexTypeId = (NameApexTypeId)object;
        return this.isResolved == nameApexTypeId.isResolved && this.apexName.equals(nameApexTypeId.apexName);
    }

    public int hashCode() {
        return Objects.hash(this.isResolved, this.apexName);
    }
}

