/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.apexlink.types.apex;

import com.nawforce.apexlink.cst.Block;
import com.nawforce.apexlink.cst.Block$;
import com.nawforce.apexlink.cst.CST$;
import com.nawforce.apexlink.cst.Id;
import com.nawforce.apexlink.cst.Id$;
import com.nawforce.apexlink.cst.LocalVariableDeclarationStatement$;
import com.nawforce.apexlink.cst.Statement;
import com.nawforce.apexlink.cst.Statement$;
import com.nawforce.apexlink.org.OPM;
import com.nawforce.apexlink.org.OrgInfo$;
import com.nawforce.apexlink.types.apex.AFTER_DELETE$;
import com.nawforce.apexlink.types.apex.AFTER_INSERT$;
import com.nawforce.apexlink.types.apex.AFTER_UNDELETE$;
import com.nawforce.apexlink.types.apex.AFTER_UPDATE$;
import com.nawforce.apexlink.types.apex.BEFORE_DELETE$;
import com.nawforce.apexlink.types.apex.BEFORE_INSERT$;
import com.nawforce.apexlink.types.apex.BEFORE_UNDELETE$;
import com.nawforce.apexlink.types.apex.BEFORE_UPDATE$;
import com.nawforce.apexlink.types.apex.TriggerCase;
import com.nawforce.apexlink.types.apex.TriggerDeclaration;
import com.nawforce.pkgforce.diagnostics.IssuesAnd;
import com.nawforce.pkgforce.names.Name;
import com.nawforce.pkgforce.names.TypeName;
import com.nawforce.pkgforce.names.TypeName$;
import com.nawforce.pkgforce.path.PathLike;
import com.nawforce.runtime.parsers.CodeParser;
import com.nawforce.runtime.parsers.CodeParser$;
import com.nawforce.runtime.parsers.Source;
import com.nawforce.runtime.parsers.SourceData;
import io.github.apexdevtools.apexparser.ApexParser;
import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;

public final class TriggerDeclaration$
implements Serializable {
    public static final TriggerDeclaration$ MODULE$ = new TriggerDeclaration$();
    private static final TypeName prefix = TypeName$.MODULE$.apply(new Name("__sfdc_trigger"));

    private TypeName prefix() {
        return prefix;
    }

    public Option<TriggerDeclaration> create(OPM.Module module, PathLike path, SourceData data) {
        CodeParser parser = CodeParser$.MODULE$.apply(path, data);
        IssuesAnd<ApexParser.TriggerUnitContext> result = parser.parseTrigger();
        result.issues().foreach((Function1 & Serializable)issue -> {
            OrgInfo$.MODULE$.log(issue);
            return BoxedUnit.UNIT;
        });
        return this.construct(parser, module, result.value());
    }

    public Option<TriggerDeclaration> construct(CodeParser parser, OPM.Module module, ApexParser.TriggerUnitContext trigger) {
        Option option;
        Object object = new Object();
        try {
            option = (Option)CST$.MODULE$.sourceContext().withValue((Object)new Some((Object)parser.source()), (Function0 & Serializable)() -> {
                ArraySeq ids = CodeParser$.MODULE$.toScala(trigger.id(), ClassTag$.MODULE$.apply(ApexParser.IdContext.class)).map((Function1 & Serializable)idContext -> Id$.MODULE$.construct((ApexParser.IdContext)idContext));
                if (ids.length() != 2) {
                    OrgInfo$.MODULE$.logError(parser.source().getLocation((ParserRuleContext)trigger), new StringBuilder(50).append("Failed to parse trigger, expected 2 ids but found ").append(ids.length()).toString());
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                }
                ArraySeq cases = CodeParser$.MODULE$.toScala(trigger.triggerCase(), ClassTag$.MODULE$.apply(ApexParser.TriggerCaseContext.class)).map((Function1 & Serializable)triggerCase -> MODULE$.constructCase((ApexParser.TriggerCaseContext)triggerCase));
                if (cases.isEmpty()) {
                    OrgInfo$.MODULE$.logError(parser.source().getLocation((ParserRuleContext)trigger), "Failed to parse trigger, no trigger cases found");
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                }
                return CodeParser$.MODULE$.toScala(trigger.triggerBlock()).map((Function1 & Serializable)triggerBlock -> {
                    Tuple2<Seq<Statement>, Seq<ApexParser.TriggerBlockMemberContext>> statementsAndDeclarations = MODULE$.splitStatementsAndDeclarations(parser, (Seq<ApexParser.TriggerBlockMemberContext>)CodeParser$.MODULE$.toScala(triggerBlock.triggerBlockMember(), ClassTag$.MODULE$.apply(ApexParser.TriggerBlockMemberContext.class)));
                    return (TriggerDeclaration)new TriggerDeclaration(parser.source(), module, (Id)ids.head(), (Id)ids.apply(1), MODULE$.constructTypeName(module.namespace(), ((Id)ids.head()).name()), (Seq<TriggerCase>)cases, (Option<Block>)new Some((Object)Block$.MODULE$.constructTrigger(parser, (ParserRuleContext)trigger, (Seq<Statement>)((Seq)statementsAndDeclarations._1())))).withContext((ParserRuleContext)trigger);
                });
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Tuple2<Seq<Statement>, Seq<ApexParser.TriggerBlockMemberContext>> splitStatementsAndDeclarations(CodeParser parser, Seq<ApexParser.TriggerBlockMemberContext> members) {
        ArrayBuffer statements = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        members.foreach((Function1 & Serializable)member -> {
            TriggerDeclaration$.$anonfun$splitStatementsAndDeclarations$1(parser, statements, member);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)statements.toSeq(), (Object)Nil$.MODULE$);
    }

    private TypeName constructTypeName(Option<Name> namespace, Name name) {
        String qname = (String)namespace.map((Function1 & Serializable)ns -> new StringBuilder(2).append(MODULE$.prefix()).append("/").append(ns.value()).append("/").append(name.value()).toString()).getOrElse((Function0 & Serializable)() -> new StringBuilder(1).append(MODULE$.prefix()).append("/").append(name.value()).toString());
        return TypeName$.MODULE$.apply(new Name(qname));
    }

    private TriggerCase constructCase(ApexParser.TriggerCaseContext triggerCase) {
        if (CodeParser$.MODULE$.toScala(triggerCase.BEFORE()).nonEmpty()) {
            if (CodeParser$.MODULE$.toScala(triggerCase.INSERT()).nonEmpty()) {
                return BEFORE_INSERT$.MODULE$;
            }
            if (CodeParser$.MODULE$.toScala(triggerCase.UPDATE()).nonEmpty()) {
                return BEFORE_UPDATE$.MODULE$;
            }
            if (CodeParser$.MODULE$.toScala(triggerCase.DELETE()).nonEmpty()) {
                return BEFORE_DELETE$.MODULE$;
            }
            return BEFORE_UNDELETE$.MODULE$;
        }
        if (CodeParser$.MODULE$.toScala(triggerCase.INSERT()).nonEmpty()) {
            return AFTER_INSERT$.MODULE$;
        }
        if (CodeParser$.MODULE$.toScala(triggerCase.UPDATE()).nonEmpty()) {
            return AFTER_UPDATE$.MODULE$;
        }
        if (CodeParser$.MODULE$.toScala(triggerCase.DELETE()).nonEmpty()) {
            return AFTER_DELETE$.MODULE$;
        }
        return AFTER_UNDELETE$.MODULE$;
    }

    public TriggerDeclaration apply(Source source, OPM.Module module, Id nameId, Id objectNameId, TypeName typeName, Seq<TriggerCase> cases, Option<Block> block) {
        return new TriggerDeclaration(source, module, nameId, objectNameId, typeName, cases, block);
    }

    public Option<Tuple7<Source, OPM.Module, Id, Id, TypeName, Seq<TriggerCase>, Option<Block>>> unapply(TriggerDeclaration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.source(), (Object)x$0.module(), (Object)x$0.nameId(), (Object)x$0.objectNameId(), (Object)x$0.typeName(), x$0.cases(), x$0.block()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TriggerDeclaration$.class);
    }

    public static final /* synthetic */ void $anonfun$splitStatementsAndDeclarations$1(CodeParser parser$2, ArrayBuffer statements$1, ApexParser.TriggerBlockMemberContext member) {
        Option<ApexParser.StatementContext> statementContext = CodeParser$.MODULE$.toScala(member.statement());
        Option<ApexParser.TriggerMemberDeclarationContext> declarationContext = CodeParser$.MODULE$.toScala(member.triggerMemberDeclaration());
        if (statementContext.nonEmpty()) {
            Statement$.MODULE$.construct(parser$2, (ApexParser.StatementContext)statementContext.get()).foreach((Function1 & Serializable)elem -> (ArrayBuffer)statements$1.append(elem));
            return;
        }
        if (declarationContext.nonEmpty()) {
            ArraySeq modifiers = CodeParser$.MODULE$.toScala(member.modifier(), ClassTag$.MODULE$.apply(ApexParser.ModifierContext.class));
            CodeParser$.MODULE$.toScala(((ApexParser.TriggerMemberDeclarationContext)declarationContext.get()).fieldDeclaration()).foreach((Function1 & Serializable)field -> (ArrayBuffer)statements$1.append((Object)LocalVariableDeclarationStatement$.MODULE$.constructTriggerVar(parser$2, (ArraySeq<ApexParser.ModifierContext>)modifiers, (ApexParser.FieldDeclarationContext)field)));
            return;
        }
    }

    private TriggerDeclaration$() {
    }
}

