/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.pkgforce.documents;

import com.nawforce.pkgforce.diagnostics.Diagnostic;
import com.nawforce.pkgforce.diagnostics.ERROR_CATEGORY$;
import com.nawforce.pkgforce.diagnostics.Issue;
import com.nawforce.pkgforce.diagnostics.Issue$;
import com.nawforce.pkgforce.diagnostics.IssuesManager;
import com.nawforce.pkgforce.documents.ApexMetaNature$;
import com.nawforce.pkgforce.documents.ApexNature$;
import com.nawforce.pkgforce.documents.ComponentNature$;
import com.nawforce.pkgforce.documents.FieldNature$;
import com.nawforce.pkgforce.documents.FieldSetNature$;
import com.nawforce.pkgforce.documents.FlowNature$;
import com.nawforce.pkgforce.documents.LabelNature$;
import com.nawforce.pkgforce.documents.MetadataDocument;
import com.nawforce.pkgforce.documents.MetadataDocument$;
import com.nawforce.pkgforce.documents.MetadataNature;
import com.nawforce.pkgforce.documents.PageNature$;
import com.nawforce.pkgforce.documents.SObjectDocument;
import com.nawforce.pkgforce.documents.SObjectNature$;
import com.nawforce.pkgforce.documents.SharingReasonNature$;
import com.nawforce.pkgforce.documents.TriggerMetaNature$;
import com.nawforce.pkgforce.documents.TriggerNature$;
import com.nawforce.pkgforce.names.EncodedName;
import com.nawforce.pkgforce.names.EncodedName$;
import com.nawforce.pkgforce.names.Name;
import com.nawforce.pkgforce.names.TypeName;
import com.nawforce.pkgforce.path.Location$;
import com.nawforce.pkgforce.path.PathLike;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\t\u0012\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003[\u0001\u0011%1\fC\u0003^\u0001\u0011%a\fC\u0003a\u0001\u0011%\u0011\rC\u0003m\u0001\u0011%Q\u000eC\u0003s\u0001\u0011%1\u000fC\u0003v\u0001\u0011%a\u000fC\u0003y\u0001\u0011%\u0011\u0010C\u0003|\u0001\u0011%A\u0010C\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\u0003#5+G/\u00193bi\u00064\u0016\r\\5eCR|'O\u0003\u0002\u0013'\u0005IAm\\2v[\u0016tGo\u001d\u0006\u0003)U\t\u0001\u0002]6hM>\u00148-\u001a\u0006\u0003-]\t\u0001B\\1xM>\u00148-\u001a\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\r1|wmZ3s!\t\u0019c%D\u0001%\u0015\t)3#A\u0006eS\u0006<gn\\:uS\u000e\u001c\u0018BA\u0014%\u00055I5o];fg6\u000bg.Y4fe\u0006Ia.Y7fgB\f7-\u001a\t\u00049)b\u0013BA\u0016\u001e\u0005\u0019y\u0005\u000f^5p]B\u0011Q\u0006M\u0007\u0002])\u0011qfE\u0001\u0006]\u0006lWm]\u0005\u0003c9\u0012AAT1nK\u0006A\u0011n]$vYB,G\r\u0005\u0002\u001di%\u0011Q'\b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!\u0001HO\u001e=!\tI\u0004!D\u0001\u0012\u0011\u0015\tC\u00011\u0001#\u0011\u0015AC\u00011\u0001*\u0011\u0015\u0011D\u00011\u00014\u0003!1\u0018\r\\5eCR,GcA C\u000fB\u0011A\u0004Q\u0005\u0003\u0003v\u0011A!\u00168ji\")1)\u0002a\u0001\t\u00061a.\u0019;ve\u0016\u0004\"!O#\n\u0005\u0019\u000b\"AD'fi\u0006$\u0017\r^1OCR,(/\u001a\u0005\u0006%\u0015\u0001\r\u0001\u0013\t\u0004\u0013F#fB\u0001&P\u001d\tYe*D\u0001M\u0015\ti\u0015$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011\u0001+H\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116K\u0001\u0003MSN$(B\u0001)\u001e!\t)\u0006,D\u0001W\u0015\t96#\u0001\u0003qCRD\u0017BA-W\u0005!\u0001\u0016\r\u001e5MS.,\u0017\u0001\u0004<bY&$\u0017\r^3Ba\u0016DHCA ]\u0011\u0015\u0011b\u00011\u0001I\u0003=1\u0018\r\\5eCR,GK]5hO\u0016\u0014HCA `\u0011\u0015\u0011r\u00011\u0001I\u0003q9W\r^*j]\u001edWmQ8oiJ|G\u000e\\5oO\u0012{7-^7f]R$BA\u00194iUB\u0019ADK2\u0011\u0005e\"\u0017BA3\u0012\u0005AiU\r^1eCR\fGi\\2v[\u0016tG\u000fC\u0003h\u0011\u0001\u0007A)A\td_:$(o\u001c7mS:<g*\u0019;ve\u0016DQ!\u001b\u0005A\u0002\u0011\u000b!\"\\3uC:\u000bG/\u001e:f\u0011\u0015\u0011\u0002\u00021\u0001l!\rI\u0015kY\u0001\u0019CN\u001cXM\u001d;TS:<G.Z'fi\u0006$unY;nK:$H\u0003B oaFDQa\\\u0005A\u0002\r\fabY8oiJ|G\u000e\\5oO\u0012{7\rC\u0003D\u0013\u0001\u0007A\tC\u0003\u0013\u0013\u0001\u00071.A\twC2LG-\u0019;f\u0007>l\u0007o\u001c8f]R$\"a\u0010;\t\u000bIQ\u0001\u0019\u0001%\u0002\u0019Y\fG.\u001b3bi\u0016\u0004\u0016mZ3\u0015\u0005}:\b\"\u0002\n\f\u0001\u0004A\u0015\u0001\u0004<bY&$\u0017\r^3GY><HCA {\u0011\u0015\u0011B\u00021\u0001I\u0003Q\t7o]3siNKgn\u001a7f\t>\u001cW/\\3oiR\u0011q( \u0005\u0006%5\u0001\r\u0001S\u0001\u0014m\u0006d\u0017\u000eZ1uKN{%M[3di2K7.\u001a\u000b\u0004\u007f\u0005\u0005\u0001\"\u0002\n\u000f\u0001\u0004A\u0015\u0001E1tg\u0016\u0014H/\u00168jcV,g*Y7f)\u0015y\u0014qAA\u0005\u0011\u0015\u0019u\u00021\u0001E\u0011\u0015\u0011r\u00021\u0001l\u0001")
public class MetadataValidator {
    private final IssuesManager logger;
    private final Option<Name> namespace;
    private final boolean isGulped;

    public void validate(MetadataNature nature, List<PathLike> documents) {
        documents.foreach((Function1 & Serializable)path -> $this.logger.pop((PathLike)path));
        MetadataNature metadataNature = nature;
        if (LabelNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (ApexNature$.MODULE$.equals(metadataNature)) {
            this.validateApex(documents);
            return;
        }
        if (ApexMetaNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (TriggerNature$.MODULE$.equals(metadataNature)) {
            this.validateTrigger(documents);
            return;
        }
        if (TriggerMetaNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (ComponentNature$.MODULE$.equals(metadataNature)) {
            this.validateComponent(documents);
            return;
        }
        if (PageNature$.MODULE$.equals(metadataNature)) {
            this.validatePage(documents);
            return;
        }
        if (FlowNature$.MODULE$.equals(metadataNature)) {
            this.validateFlow(documents);
            return;
        }
        if (SObjectNature$.MODULE$.equals(metadataNature)) {
            this.validateSObjectLike(documents);
            return;
        }
        if (FieldNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (FieldSetNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (SharingReasonNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        throw new MatchError((Object)metadataNature);
    }

    private void validateApex(List<PathLike> documents) {
        List allDocs = documents.flatMap((Function1 & Serializable)x$1 -> MetadataDocument$.MODULE$.apply((PathLike)x$1));
        this.getSingleControllingDocument(ApexNature$.MODULE$, ApexMetaNature$.MODULE$, (List<MetadataDocument>)allDocs).foreach((Function1 & Serializable)controllingDoc -> {
            this.assertSingleMetaDocument(controllingDoc, ApexMetaNature$.MODULE$, (List<MetadataDocument>)allDocs.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateApex$3(controllingDoc, x$2))));
            return BoxedUnit.UNIT;
        });
    }

    private void validateTrigger(List<PathLike> documents) {
        List allDocs = documents.flatMap((Function1 & Serializable)x$3 -> MetadataDocument$.MODULE$.apply((PathLike)x$3));
        this.getSingleControllingDocument(TriggerNature$.MODULE$, TriggerMetaNature$.MODULE$, (List<MetadataDocument>)allDocs).foreach((Function1 & Serializable)controllingDoc -> {
            this.assertSingleMetaDocument(controllingDoc, TriggerMetaNature$.MODULE$, (List<MetadataDocument>)allDocs.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateTrigger$3(controllingDoc, x$4))));
            return BoxedUnit.UNIT;
        });
    }

    private Option<MetadataDocument> getSingleControllingDocument(MetadataNature controllingNature, MetadataNature metaNature, List<MetadataDocument> documents) {
        List controllingDocs = documents.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$1(controllingNature, x$5)));
        if (controllingDocs.isEmpty()) {
            boolean isControllingIgnored;
            List metaDocs = documents.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$2(metaNature, x$6)));
            boolean bl = isControllingIgnored = metaDocs.size() == 1 && metaDocs.headOption().exists((Function1 & Serializable)md -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$3(md)));
            if (!isControllingIgnored) {
                documents.foreach((Function1 & Serializable)document -> {
                    MetadataValidator.$anonfun$getSingleControllingDocument$4(this, document);
                    return BoxedUnit.UNIT;
                });
            }
            return None$.MODULE$;
        }
        if (controllingDocs.size() > 1) {
            ((List)controllingDocs.tail()).foreach((Function1 & Serializable)document -> {
                MetadataValidator.$anonfun$getSingleControllingDocument$5(this, controllingDocs, document);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        return controllingDocs.headOption();
    }

    private void assertSingleMetaDocument(MetadataDocument controllingDoc, MetadataNature nature, List<MetadataDocument> documents) {
        TypeName typeName = controllingDoc.typeName(this.namespace);
        List metaDocs = documents.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertSingleMetaDocument$1(nature, x$9)));
        if (!this.isGulped && metaDocs.isEmpty()) {
            this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(51).append("Type '").append(typeName).append("' is defined, but meta file is missing for '").append(controllingDoc.path()).append("'").toString()), Issue$.MODULE$.apply$default$3()));
            return;
        }
        if (metaDocs.size() > 1) {
            String otherPaths = documents.map((Function1 & Serializable)x$10 -> x$10.path()).mkString(", ");
            this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(53).append("Type '").append(typeName).append("' is defined, but multiple meta files found at ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
            return;
        }
        if (metaDocs.nonEmpty()) {
            PathLike pathLike = controllingDoc.path().parent();
            PathLike pathLike2 = ((MetadataDocument)metaDocs.head()).path().parent();
            if (pathLike == null ? pathLike2 != null : !pathLike.equals(pathLike2)) {
                this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(70).append("Type '").append(typeName).append("' is defined, but its meta file is in a different directory see ").append(((MetadataDocument)metaDocs.head()).path()).toString()), Issue$.MODULE$.apply$default$3()));
                return;
            }
        }
    }

    private void validateComponent(List<PathLike> documents) {
        this.assertSingleDocument(documents);
    }

    private void validatePage(List<PathLike> documents) {
        this.assertSingleDocument(documents);
    }

    private void validateFlow(List<PathLike> documents) {
        this.assertSingleDocument(documents);
    }

    private void assertSingleDocument(List<PathLike> documents) {
        if (documents.length() > 1) {
            List allDocs = documents.flatMap((Function1 & Serializable)x$11 -> MetadataDocument$.MODULE$.apply((PathLike)x$11));
            allDocs.foreach((Function1 & Serializable)document -> {
                MetadataValidator.$anonfun$assertSingleDocument$2(this, documents, document);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void validateSObjectLike(List<PathLike> documents) {
        List allDocs = documents.flatMap((Function1 & Serializable)x$13 -> MetadataDocument$.MODULE$.apply((PathLike)x$13));
        List controllingDocs = allDocs.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$2(x$14)));
        TypeName typeName = ((MetadataDocument)allDocs.head()).controllingTypeName(this.namespace);
        boolean isSObject = BoxesRunTime.unboxToBoolean((Object)controllingDocs.headOption().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$3(x$15))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            EncodedName encName = EncodedName$.MODULE$.apply(typeName.name());
            return encName.ext().isEmpty() || encName.ext().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$5(x$16)));
        }));
        if (!isSObject && controllingDocs.isEmpty()) {
            this.logger.log(new Issue((PathLike)documents.minBy((Function1 & Serializable)x$17 -> x$17.toString(), (Ordering)Ordering.String$.MODULE$), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(83).append("Components of type '").append(typeName).append("' are defined, but the required object-meta.xml file is missing").toString()), Issue$.MODULE$.apply$default$3()));
        } else if (controllingDocs.length() > 1) {
            controllingDocs.foreach((Function1 & Serializable)controllingDoc -> {
                MetadataValidator.$anonfun$validateSObjectLike$7(this, controllingDocs, controllingDoc);
                return BoxedUnit.UNIT;
            });
        }
        this.assertUniqueName(FieldNature$.MODULE$, (List<MetadataDocument>)allDocs);
        this.assertUniqueName(FieldSetNature$.MODULE$, (List<MetadataDocument>)allDocs);
        this.assertUniqueName(SharingReasonNature$.MODULE$, (List<MetadataDocument>)allDocs);
    }

    private void assertUniqueName(MetadataNature nature, List<MetadataDocument> documents) {
        ((IterableOnceOps)documents.filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertUniqueName$1(nature, x$20))).groupBy((Function1 & Serializable)x$21 -> x$21.name()).filter((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertUniqueName$3(x$22)))).foreach((Function1 & Serializable)duplicate -> {
            MetadataValidator.$anonfun$assertUniqueName$4(this, duplicate);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateApex$3(MetadataDocument controllingDoc$1, MetadataDocument x$2) {
        MetadataDocument metadataDocument = x$2;
        MetadataDocument metadataDocument2 = controllingDoc$1;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateTrigger$3(MetadataDocument controllingDoc$2, MetadataDocument x$4) {
        MetadataDocument metadataDocument = x$4;
        MetadataDocument metadataDocument2 = controllingDoc$2;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$1(MetadataNature controllingNature$1, MetadataDocument x$5) {
        MetadataNature metadataNature = x$5.nature();
        MetadataNature metadataNature2 = controllingNature$1;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$2(MetadataNature metaNature$1, MetadataDocument x$6) {
        MetadataNature metadataNature = x$6.nature();
        MetadataNature metadataNature2 = metaNature$1;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$3(MetadataDocument md) {
        PathLike controllingPath;
        PathLike pathLike = controllingPath = md.path().parent().join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{md.path().basename().replaceFirst("-meta.xml$", "")}));
        PathLike pathLike2 = md.path();
        return (pathLike == null ? pathLike2 != null : !pathLike.equals(pathLike2)) && controllingPath.isFile();
    }

    public static final /* synthetic */ void $anonfun$getSingleControllingDocument$4(MetadataValidator $this, MetadataDocument document) {
        TypeName typeName = document.typeName($this.namespace);
        $this.logger.log(new Issue(document.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(66).append("Type '").append(typeName).append("' is not defined, but expected due to '").append(document.path()).append("', ignoring this file").toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$6(MetadataDocument document$1, MetadataDocument x$7) {
        PathLike pathLike = x$7.path();
        PathLike pathLike2 = document$1.path();
        return !(pathLike != null ? !pathLike.equals(pathLike2) : pathLike2 != null);
    }

    public static final /* synthetic */ void $anonfun$getSingleControllingDocument$5(MetadataValidator $this, List controllingDocs$1, MetadataDocument document) {
        TypeName typeName = document.typeName($this.namespace);
        String otherPaths = controllingDocs$1.filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$6(document, x$7))).map((Function1 & Serializable)x$8 -> x$8.path()).mkString(", ");
        $this.logger.log(new Issue(document.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(64).append("Duplicate for type '").append(typeName).append("' found in '").append(document.path()).append("', ignoring this file, see also ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$assertSingleMetaDocument$1(MetadataNature nature$1, MetadataDocument x$9) {
        MetadataNature metadataNature = x$9.nature();
        MetadataNature metadataNature2 = nature$1;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$assertSingleDocument$3(MetadataDocument document$2, PathLike x$12) {
        PathLike pathLike = x$12;
        PathLike pathLike2 = document$2.path();
        return !(pathLike != null ? !pathLike.equals(pathLike2) : pathLike2 != null);
    }

    public static final /* synthetic */ void $anonfun$assertSingleDocument$2(MetadataValidator $this, List documents$1, MetadataDocument document) {
        String otherPaths = documents$1.filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertSingleDocument$3(document, x$12))).mkString(", ");
        $this.logger.log(new Issue(document.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(32).append("Duplicate for type '").append(document.typeName($this.namespace)).append("', see also ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$2(MetadataDocument x$14) {
        MetadataNature metadataNature = x$14.nature();
        SObjectNature$ sObjectNature$ = SObjectNature$.MODULE$;
        return !(metadataNature != null ? !metadataNature.equals(sObjectNature$) : sObjectNature$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$3(MetadataDocument x$15) {
        return x$15 instanceof SObjectDocument;
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$5(Name x$16) {
        String string = x$16.value();
        String string2 = "c";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$8(MetadataDocument controllingDoc$3, MetadataDocument x$18) {
        MetadataDocument metadataDocument = x$18;
        MetadataDocument metadataDocument2 = controllingDoc$3;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateSObjectLike$7(MetadataValidator $this, List controllingDocs$2, MetadataDocument controllingDoc) {
        TypeName typeName = controllingDoc.typeName($this.namespace);
        String otherPaths = controllingDocs$2.filterNot((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$8(controllingDoc, x$18))).map((Function1 & Serializable)x$19 -> x$19.path()).mkString(", ");
        $this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(65).append("Type '").append(typeName).append("' is defined, but duplicate object-meta.xml files found at ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$assertUniqueName$1(MetadataNature nature$2, MetadataDocument x$20) {
        MetadataNature metadataNature = x$20.nature();
        MetadataNature metadataNature2 = nature$2;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$assertUniqueName$3(Tuple2 x$22) {
        return ((SeqOps)x$22._2()).size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$assertUniqueName$6(MetadataDocument duplicated$1, MetadataDocument x$23) {
        MetadataDocument metadataDocument = x$23;
        MetadataDocument metadataDocument2 = duplicated$1;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ void $anonfun$assertUniqueName$5(MetadataValidator $this, Tuple2 duplicate$1, MetadataDocument duplicated) {
        TypeName typeName = duplicated.typeName($this.namespace);
        String otherPaths = ((List)duplicate$1._2()).filterNot((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertUniqueName$6(duplicated, x$23))).map((Function1 & Serializable)x$24 -> x$24.path()).mkString(", ");
        $this.logger.log(new Issue(duplicated.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(52).append("Type '").append(typeName.toString()).append("' is defined, but duplicate metadata found at ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ void $anonfun$assertUniqueName$4(MetadataValidator $this, Tuple2 duplicate) {
        ((List)duplicate._2()).foreach((Function1 & Serializable)duplicated -> {
            MetadataValidator.$anonfun$assertUniqueName$5($this, duplicate, duplicated);
            return BoxedUnit.UNIT;
        });
    }

    public MetadataValidator(IssuesManager logger, Option<Name> namespace, boolean isGulped) {
        this.logger = logger;
        this.namespace = namespace;
        this.isGulped = isGulped;
    }
}

