/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.pkgforce.documents;

import com.nawforce.pkgforce.diagnostics.LoggerOps$;
import com.nawforce.pkgforce.documents.CacheEntry;
import com.nawforce.pkgforce.documents.CacheEntry$;
import com.nawforce.pkgforce.documents.CacheKey;
import com.nawforce.pkgforce.documents.CacheKey$;
import com.nawforce.pkgforce.documents.PackageContext;
import com.nawforce.pkgforce.documents.ParsedCache$;
import com.nawforce.pkgforce.path.PathLike;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import upack.Readable$;
import upickle.default$;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u000b\u0017\u0005}A\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t[\u0001\u0011\t\u0011)A\u0005Q!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u00033\u0001\u0011\u00051\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003Z\u0001\u0011\u0005!\fC\u0003b\u0001\u0011\u0005!\rC\u0003b\u0001\u0011%1\rC\u0003n\u0001\u0011\u0005!\rC\u0003o\u0001\u0011%qnB\u0003r-!\u0005!OB\u0003\u0016-!\u00051\u000fC\u00033\u0019\u0011\u0005A\u000fC\u0004v\u0019\t\u0007I\u0011\u0002<\t\r]d\u0001\u0015!\u0003E\u0011\u001dAHB1A\u0005\neDaA\u001f\u0007!\u0002\u0013Q\u0007\"B>\r\t\u0003a\b\"B7\r\t\u0003\u0011\u0007bBA\b\u0019\u0011\u0005\u0011\u0011\u0003\u0002\f!\u0006\u00148/\u001a3DC\u000eDWM\u0003\u0002\u00181\u0005IAm\\2v[\u0016tGo\u001d\u0006\u00033i\t\u0001\u0002]6hM>\u00148-\u001a\u0006\u00037q\t\u0001B\\1xM>\u00148-\u001a\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\tA\fG\u000f[\u000b\u0002QA\u0011\u0011fK\u0007\u0002U)\u0011a\u0005G\u0005\u0003Y)\u0012\u0001\u0002U1uQ2K7.Z\u0001\u0006a\u0006$\b\u000eI\u0001\bm\u0016\u00148/[8o!\t\t\u0003'\u0003\u00022E\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r!dg\u000e\t\u0003k\u0001i\u0011A\u0006\u0005\u0006M\u0011\u0001\r\u0001\u000b\u0005\u0006]\u0011\u0001\raL\u0001\u0007kB\u001cXM\u001d;\u0015\u000bij$iT)\u0011\u0005\u0005Z\u0014B\u0001\u001f#\u0005\u0011)f.\u001b;\t\u000by*\u0001\u0019A \u0002\u001dA\f7m[1hK\u000e{g\u000e^3yiB\u0011Q\u0007Q\u0005\u0003\u0003Z\u0011a\u0002U1dW\u0006<WmQ8oi\u0016DH\u000fC\u0003D\u000b\u0001\u0007A)\u0001\u0003oC6,\u0007CA#M\u001d\t1%\n\u0005\u0002HE5\t\u0001J\u0003\u0002J=\u00051AH]8pizJ!a\u0013\u0012\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017\nBQ\u0001U\u0003A\u0002=\n1bY8oi\u0016tG\u000fS1tQ\")!+\u0002a\u0001'\u0006)a/\u00197vKB\u0019\u0011\u0005\u0016,\n\u0005U\u0013#!B!se\u0006L\bCA\u0011X\u0013\tA&E\u0001\u0003CsR,\u0017aA4fiR!1LX0a!\r\tClU\u0005\u0003;\n\u0012aa\u00149uS>t\u0007\"\u0002 \u0007\u0001\u0004y\u0004\"B\"\u0007\u0001\u0004!\u0005\"\u0002)\u0007\u0001\u0004y\u0013AB3ya&\u0014X\rF\u0001;)\r!w\r\u001b\t\u0003C\u0015L!A\u001a\u0012\u0003\u000f\t{w\u000e\\3b]\")a\u0005\u0003a\u0001Q!)\u0011\u000e\u0003a\u0001U\u0006aQ.\u001b8US6,7\u000b^1naB\u0011\u0011e[\u0005\u0003Y\n\u0012A\u0001T8oO\u0006)1\r\\3be\u0006i1\r\\3be\u000e{g\u000e^3oiN$\"A\u000f9\t\u000b\u0019R\u0001\u0019\u0001\u0015\u0002\u0017A\u000b'o]3e\u0007\u0006\u001c\u0007.\u001a\t\u0003k1\u0019\"\u0001\u0004\u0011\u0015\u0003I\f\u0011\u0002V#T)~3\u0015\nT#\u0016\u0003\u0011\u000b!\u0002V#T)~3\u0015\nT#!\u00035)\u0005\fU%S\u000b~;\u0016J\u0014#P/V\t!.\u0001\bF1BK%+R0X\u0013:#uj\u0016\u0011\u0002\r\r\u0014X-\u0019;f)\ri\u0018Q\u0002\t\u0006}\u0006\u001dA\t\u000e\b\u0004\u007f\u0006\rabA$\u0002\u0002%\t1%C\u0002\u0002\u0006\t\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!AB#ji\",'OC\u0002\u0002\u0006\tBQA\f\nA\u0002=\nQb\u00197bgNlU\r^1ICNDG#B\u0018\u0002\u0014\u0005]\u0001BBA\u000b)\u0001\u0007\u0001&\u0001\u0005nKR\fg)\u001b7f\u0011\u0019\tI\u0002\u0006a\u0001_\u0005\t2o\\;sG\u0016\u001cuN\u001c;f]RD\u0015m\u001d5")
public final class ParsedCache {
    private final PathLike path;
    private final int version;

    public static int classMetaHash(PathLike metaFile, int sourceContentHash) {
        return ParsedCache$.MODULE$.classMetaHash(metaFile, sourceContentHash);
    }

    public static Either<String, ParsedCache> create(int version) {
        return ParsedCache$.MODULE$.create(version);
    }

    public PathLike path() {
        return this.path;
    }

    public void upsert(PackageContext packageContext, String name, int contentHash, byte[] value) {
        CacheKey cacheKey = CacheKey$.MODULE$.apply(this.version, packageContext, name, contentHash);
        String[] hashParts = cacheKey.hashParts();
        Either<String, PathLike> either = this.path().createDirectory((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])hashParts)));
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            PathLike outer = (PathLike)right.value();
            PathLike inner = outer.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{hashParts[1]}));
            inner.write(default$.MODULE$.writeBinary((Object)new CacheEntry(cacheKey, value), CacheEntry$.MODULE$.rw()));
            return;
        }
        throw new MatchError(either);
    }

    public Option<byte[]> get(PackageContext packageContext, String name, int contentHash) {
        CacheKey cacheKey = CacheKey$.MODULE$.apply(this.version, packageContext, name, contentHash);
        String[] hashParts = cacheKey.hashParts();
        PathLike outer = this.path().join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])hashParts))}));
        if (outer.isDirectory()) {
            PathLike inner = outer.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{hashParts[1]}));
            Either<String, byte[]> either = inner.readBytes();
            if (either instanceof Left) {
            } else if (either instanceof Right) {
                BoxedUnit boxedUnit;
                Right right = (Right)either;
                byte[] data = (byte[])right.value();
                try {
                    CacheEntry ce = (CacheEntry)default$.MODULE$.readBinary(Readable$.MODULE$.fromByteArray(data), default$.MODULE$.readBinary$default$2(), CacheEntry$.MODULE$.rw());
                    CacheKey cacheKey2 = ce.key();
                    CacheKey cacheKey3 = cacheKey;
                    if (!(cacheKey2 != null ? !((Object)cacheKey2).equals(cacheKey3) : cacheKey3 != null)) {
                        return new Some((Object)ce.value());
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable ex) {
                    LoggerOps$.MODULE$.debug(new StringBuilder(32).append("Caught exception loading from ").append(inner).append(": ").append(ex).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(either);
            }
        }
        return None$.MODULE$;
    }

    public void expire() {
        this.expire(this.path(), System.currentTimeMillis() - ParsedCache$.MODULE$.com$nawforce$pkgforce$documents$ParsedCache$$EXPIRE_WINDOW());
    }

    private boolean expire(PathLike path, long minTimeStamp) {
        if (!path.exists()) {
            return true;
        }
        Tuple2<PathLike[], PathLike[]> tuple2 = path.splitDirectoryEntries();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PathLike[] files = (PathLike[])tuple2._1();
        PathLike[] directories = (PathLike[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)files, (Object)directories);
        PathLike[] files2 = (PathLike[])tuple22._1();
        PathLike[] directories2 = (PathLike[])tuple22._2();
        int deletedFiles = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files2), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ParsedCache.$anonfun$expire$1(minTimeStamp, f)))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ParsedCache.$anonfun$expire$3(x$3)));
        int deletedDirectories = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.booleanArrayOps((boolean[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])directories2), (Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)this.expire(d, minTimeStamp)), (ClassTag)ClassTag$.MODULE$.Boolean())), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ParsedCache.$anonfun$expire$5(BoxesRunTime.unboxToBoolean((Object)x$4))));
        if (deletedFiles == files2.length && deletedDirectories == directories2.length) {
            return path.delete().isEmpty();
        }
        return false;
    }

    public void clear() {
        this.clearContents(this.path());
    }

    private void clearContents(PathLike path) {
        Either<String, Seq<String>> either = path.directoryList();
        if (either instanceof Left) {
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq names = (Seq)right.value();
            names.foreach((Function1 & Serializable)name -> {
                PathLike pathEntry;
                block0: {
                    pathEntry = path.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                    if (!pathEntry.isDirectory()) break block0;
                    this.clearContents(pathEntry);
                }
                return pathEntry.delete();
            });
        } else {
            throw new MatchError(either);
        }
        path.delete();
    }

    public static final /* synthetic */ boolean $anonfun$expire$1(long minTimeStamp$1, PathLike f) {
        return f.lastModified().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> x$2 < minTimeStamp$1);
    }

    public static final /* synthetic */ boolean $anonfun$expire$3(PathLike x$3) {
        return x$3.delete().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$expire$5(boolean x$4) {
        return x$4;
    }

    public ParsedCache(PathLike path, int version) {
        this.path = path;
        this.version = version;
    }
}

