/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.antlr4c3;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntervalSet;

public class CodeCompletionCore {
    public static final Logger logger = Logger.getLogger(CodeCompletionCore.class.getName());
    private boolean showResult = true;
    private boolean showDebugOutput = true;
    private boolean debugOutputWithTransitions = true;
    private boolean showRuleStack = true;
    private Set<Integer> ignoredTokens = new HashSet<Integer>();
    private Set<Integer> preferredRules = new HashSet<Integer>();
    private Parser parser;
    private ATN atn;
    private Vocabulary vocabulary;
    private String[] ruleNames;
    private List<Token> tokens;
    private int tokenStartIndex = 0;
    private int statesProcessed = 0;
    private final Map<Integer, Map<Integer, Set<Integer>>> shortcutMap = new HashMap<Integer, Map<Integer, Set<Integer>>>();
    private final CandidatesCollection candidates = new CandidatesCollection();
    private static final Map<String, Map<Integer, FollowSetsHolder>> followSetsByATN = new HashMap<String, Map<Integer, FollowSetsHolder>>();
    private String[] atnStateTypeMap = new String[]{"invalid", "basic", "rule start", "block start", "plus block start", "star block start", "token start", "rule stop", "block end", "star loop back", "star loop entry", "plus loop back", "loop end"};

    public CodeCompletionCore(Parser parser, Set<Integer> set, Set<Integer> set2) {
        this.parser = parser;
        this.atn = parser.getATN();
        this.vocabulary = parser.getVocabulary();
        this.ruleNames = parser.getRuleNames();
        if (set != null) {
            this.preferredRules = set;
        }
        if (set2 != null) {
            this.ignoredTokens = set2;
        }
    }

    public Set<Integer> getPreferredRules() {
        return Collections.unmodifiableSet(this.preferredRules);
    }

    public void setPreferredRules(Set<Integer> set) {
        this.preferredRules = new HashSet<Integer>(set);
    }

    public CandidatesCollection collectCandidates(int n, ParserRuleContext parserRuleContext, int n2) {
        Object object;
        this.shortcutMap.clear();
        this.candidates.rules.clear();
        this.candidates.tokens.clear();
        this.statesProcessed = 0;
        this.tokenStartIndex = parserRuleContext != null ? parserRuleContext.start.getTokenIndex() : 0;
        TokenStream tokenStream = this.parser.getInputStream();
        int n3 = tokenStream.index();
        tokenStream.seek(this.tokenStartIndex);
        this.tokens = new ArrayList<Token>(tokenStream.size());
        int n4 = 0;
        while (true) {
            if ((object = tokenStream.get(n4++)).getChannel() != 0) {
                continue;
            }
            this.tokens.add((Token)object);
            if (object.getTokenIndex() >= n || object.getType() == -1) break;
        }
        tokenStream.seek(n3);
        object = new LinkedList();
        int n5 = parserRuleContext != null ? parserRuleContext.getRuleIndex() : 0;
        this.processRule((ATNState)this.atn.ruleToStartState[n5], 0, (LinkedList<Integer>)object, "\n", n2);
        tokenStream.seek(n3);
        Object object2 = this.preferredRules.iterator();
        while (object2.hasNext()) {
            int n6 = object2.next();
            Map<Integer, Set<Integer>> object3 = this.shortcutMap.get(n6);
            if (object3 == null || object3.isEmpty()) continue;
            int n7 = Collections.max(object3.keySet());
            Set<Integer> set = object3.get(n7);
            int n8 = set.isEmpty() ? this.tokens.size() - 1 : (Integer)Collections.max((Collection)object3.get(n7));
            int n9 = this.tokens.get(n7).getStartIndex();
            int n10 = this.tokens.get(n8).getType() == -1 ? this.tokens.get(n8).getStartIndex() : this.tokens.get(n8 - 1).getStopIndex() + 1;
            List<Integer> list = Arrays.asList(n9, n10);
            this.candidates.rulePositions.put(n6, list);
        }
        if (this.showResult && logger.isLoggable(Level.FINE)) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("States processed: ").append(this.statesProcessed).append("\n");
            ((StringBuilder)object2).append("Collected rules:\n");
            for (Map.Entry<Integer, List<Integer>> entry : this.candidates.rules.entrySet()) {
                ((StringBuilder)object2).append("  ").append(entry.getKey()).append(", path: ");
                for (Integer n11 : entry.getValue()) {
                    ((StringBuilder)object2).append(this.ruleNames[n11]).append(" ");
                }
                ((StringBuilder)object2).append("\n");
            }
            ((StringBuilder)object2).append("Collected Tokens:\n");
            for (Map.Entry<Integer, List<Integer>> entry : this.candidates.tokens.entrySet()) {
                ((StringBuilder)object2).append("  ").append(this.vocabulary.getDisplayName(entry.getKey().intValue()));
                for (Integer n12 : entry.getValue()) {
                    ((StringBuilder)object2).append(" ").append(this.vocabulary.getDisplayName(n12.intValue()));
                }
                ((StringBuilder)object2).append("\n");
            }
            logger.log(Level.FINE, ((StringBuilder)object2).toString());
        }
        return this.candidates;
    }

    private boolean checkPredicate(PredicateTransition predicateTransition) {
        return predicateTransition.getPredicate().eval((Recognizer)this.parser, (RuleContext)ParserRuleContext.EMPTY);
    }

    private boolean translateToRuleIndex(List<Integer> list) {
        if (this.preferredRules.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!this.preferredRules.contains(list.get(i))) continue;
            LinkedList<Integer> linkedList = new LinkedList<Integer>(list.subList(0, i));
            boolean bl = true;
            for (Map.Entry<Integer, List<Integer>> entry : this.candidates.rules.entrySet()) {
                if (!entry.getKey().equals(list.get(i)) || entry.getValue().size() != linkedList.size() || !linkedList.equals(entry.getValue())) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.candidates.rules.put(list.get(i), linkedList);
                if (this.showDebugOutput && logger.isLoggable(Level.FINE)) {
                    logger.fine("=====> collected: " + this.ruleNames[i]);
                }
            }
            return true;
        }
        return false;
    }

    private List<Integer> getFollowingTokens(Transition transition) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList linkedList2 = new LinkedList();
        LinkedList<ATNState> linkedList3 = new LinkedList<ATNState>();
        linkedList3.add(transition.target);
        while (!linkedList3.isEmpty()) {
            ATNState aTNState = (ATNState)linkedList3.removeLast();
            for (Transition transition2 : aTNState.getTransitions()) {
                if (transition2.getSerializationType() != 5) continue;
                if (!transition2.isEpsilon()) {
                    List list = transition2.label().toList();
                    if (list.size() != 1 || this.ignoredTokens.contains(list.get(0))) continue;
                    linkedList.addLast((Integer)list.get(0));
                    linkedList3.addLast(transition2.target);
                    continue;
                }
                linkedList3.addLast(transition2.target);
            }
        }
        return linkedList;
    }

    private LinkedList<FollowSetWithPath> determineFollowSets(ATNState aTNState, ATNState aTNState2) {
        LinkedList<FollowSetWithPath> linkedList = new LinkedList<FollowSetWithPath>();
        HashSet<ATNState> hashSet = new HashSet<ATNState>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        this.collectFollowSets(aTNState, aTNState2, linkedList, hashSet, linkedList2);
        return linkedList;
    }

    private void collectFollowSets(ATNState aTNState, ATNState aTNState2, LinkedList<FollowSetWithPath> linkedList, Set<ATNState> set, LinkedList<Integer> linkedList2) {
        if (set.contains(aTNState)) {
            return;
        }
        set.add(aTNState);
        if (aTNState.equals((Object)aTNState2) || aTNState.getStateType() == 7) {
            FollowSetWithPath followSetWithPath = new FollowSetWithPath();
            followSetWithPath.intervals = IntervalSet.of((int)-2);
            followSetWithPath.path = new LinkedList<Integer>(linkedList2);
            linkedList.addLast(followSetWithPath);
            return;
        }
        for (Transition transition : aTNState.getTransitions()) {
            Object object;
            if (transition.getSerializationType() == 3) {
                object = (RuleTransition)transition;
                if (linkedList2.indexOf(object.target.ruleIndex) != -1) continue;
                linkedList2.addLast(object.target.ruleIndex);
                this.collectFollowSets(transition.target, aTNState2, linkedList, set, linkedList2);
                linkedList2.removeLast();
                continue;
            }
            if (transition.getSerializationType() == 4) {
                if (!this.checkPredicate((PredicateTransition)transition)) continue;
                this.collectFollowSets(transition.target, aTNState2, linkedList, set, linkedList2);
                continue;
            }
            if (transition.isEpsilon()) {
                this.collectFollowSets(transition.target, aTNState2, linkedList, set, linkedList2);
                continue;
            }
            if (transition.getSerializationType() == 9) {
                object = new FollowSetWithPath();
                object.intervals = IntervalSet.of((int)1, (int)this.atn.maxTokenType);
                object.path = new LinkedList<Integer>(linkedList2);
                linkedList.addLast((FollowSetWithPath)object);
                continue;
            }
            object = transition.label();
            if (object == null || object.size() <= 0) continue;
            if (transition.getSerializationType() == 8) {
                object = object.complement((IntSet)IntervalSet.of((int)1, (int)this.atn.maxTokenType));
            }
            FollowSetWithPath followSetWithPath = new FollowSetWithPath();
            followSetWithPath.intervals = object;
            followSetWithPath.path = new LinkedList<Integer>(linkedList2);
            followSetWithPath.following = this.getFollowingTokens(transition);
            linkedList.addLast(followSetWithPath);
        }
    }

    private Set<Integer> processRule(ATNState aTNState, int n, LinkedList<Integer> linkedList, String string, int n2) {
        Object object;
        FollowSetsHolder followSetsHolder;
        Map<Integer, Set<Integer>> map = this.shortcutMap.get(aTNState.ruleIndex);
        if (map == null) {
            map = new HashMap<Integer, Set<Integer>>();
            this.shortcutMap.put(aTNState.ruleIndex, map);
        } else if (map.containsKey(n)) {
            if (this.showDebugOutput) {
                logger.fine("=====> shortcut");
            }
            return map.get(n);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Map<Integer, FollowSetsHolder> map2 = followSetsByATN.get(this.parser.getClass().getName());
        if (map2 == null) {
            map2 = new HashMap<Integer, FollowSetsHolder>();
            followSetsByATN.put(this.parser.getClass().getName(), map2);
        }
        if ((followSetsHolder = map2.get(aTNState.stateNumber)) == null) {
            followSetsHolder = new FollowSetsHolder();
            map2.put(aTNState.stateNumber, followSetsHolder);
            RuleStopState ruleStopState = this.atn.ruleToStopState[aTNState.ruleIndex];
            followSetsHolder.sets = this.determineFollowSets(aTNState, (ATNState)ruleStopState);
            object = new IntervalSet(new int[0]);
            for (FollowSetWithPath followSetWithPath : followSetsHolder.sets) {
                object.addAll((IntSet)followSetWithPath.intervals);
            }
            followSetsHolder.combined = object;
        }
        linkedList.addLast(aTNState.ruleIndex);
        int n3 = this.tokens.get(n).getType();
        if (n >= this.tokens.size() - 1) {
            if (this.preferredRules.contains(aTNState.ruleIndex)) {
                this.translateToRuleIndex(linkedList);
            } else {
                for (FollowSetWithPath followSetWithPath : followSetsHolder.sets) {
                    LinkedList<Integer> linkedList2 = new LinkedList<Integer>(linkedList);
                    linkedList2.addAll(followSetWithPath.path);
                    if (this.translateToRuleIndex(linkedList2)) continue;
                    Iterator iterator = followSetWithPath.intervals.toList().iterator();
                    while (iterator.hasNext()) {
                        int n4 = (Integer)iterator.next();
                        if (!this.ignoredTokens.contains(n4)) {
                            if (this.showDebugOutput && logger.isLoggable(Level.FINE)) {
                                logger.fine("=====> collected: " + this.vocabulary.getDisplayName(n4));
                            }
                            if (!this.candidates.tokens.containsKey(n4)) {
                                this.candidates.tokens.put(n4, followSetWithPath.following);
                                continue;
                            }
                            if (this.candidates.tokens.get(n4).equals(followSetWithPath.following)) continue;
                            this.candidates.tokens.put(n4, new LinkedList());
                            continue;
                        }
                        logger.fine("====> collection: Ignoring token: " + n4);
                    }
                }
            }
            linkedList.removeLast();
            return hashSet;
        }
        if (!followSetsHolder.combined.contains(-2) && !followSetsHolder.combined.contains(n3)) {
            linkedList.removeLast();
            return hashSet;
        }
        object = new LinkedList();
        ((LinkedList)object).add(new PipelineEntry(aTNState, n));
        block12: while (!((AbstractCollection)object).isEmpty()) {
            Transition[] transitionArray;
            boolean bl;
            PipelineEntry pipelineEntry = (PipelineEntry)((LinkedList)object).removeLast();
            ++this.statesProcessed;
            if (this.statesProcessed > n2) break;
            n3 = this.tokens.get(pipelineEntry.tokenIndex).getType();
            boolean bl2 = bl = pipelineEntry.tokenIndex >= this.tokens.size() - 1;
            if (logger.isLoggable(Level.FINE)) {
                this.printDescription(string, pipelineEntry.state, this.generateBaseDescription(pipelineEntry.state), pipelineEntry.tokenIndex);
                if (this.showRuleStack) {
                    this.printRuleState(linkedList);
                }
            }
            switch (pipelineEntry.state.getStateType()) {
                case 2: {
                    string = string + "  ";
                    break;
                }
                case 7: {
                    hashSet.add(pipelineEntry.tokenIndex);
                    continue block12;
                }
            }
            block13: for (Transition transition : transitionArray = pipelineEntry.state.getTransitions()) {
                switch (transition.getSerializationType()) {
                    case 3: {
                        Object object2 = this.processRule(transition.target, pipelineEntry.tokenIndex, linkedList, string, n2);
                        Object object32 = object2.iterator();
                        while (object32.hasNext()) {
                            Integer n5 = (Integer)object32.next();
                            ((LinkedList)object).addLast(new PipelineEntry(((RuleTransition)transition).followState, n5));
                        }
                        continue block13;
                    }
                    case 4: {
                        if (!this.checkPredicate((PredicateTransition)transition)) continue block13;
                        ((LinkedList)object).addLast(new PipelineEntry(transition.target, pipelineEntry.tokenIndex));
                        continue block13;
                    }
                    case 9: {
                        Object object32;
                        if (bl) {
                            if (this.translateToRuleIndex(linkedList)) continue block13;
                            for (Object object32 : IntervalSet.of((int)1, (int)this.atn.maxTokenType).toList()) {
                                if (this.ignoredTokens.contains(object32)) continue;
                                this.candidates.tokens.put((Integer)object32, new LinkedList());
                            }
                            continue block13;
                        }
                        ((LinkedList)object).addLast(new PipelineEntry(transition.target, pipelineEntry.tokenIndex + 1));
                        continue block13;
                    }
                    default: {
                        Object object32;
                        if (transition.isEpsilon()) {
                            ((LinkedList)object).addLast(new PipelineEntry(transition.target, pipelineEntry.tokenIndex));
                            continue block13;
                        }
                        Object object2 = transition.label();
                        if (object2 == null || object2.size() <= 0) continue block13;
                        if (transition.getSerializationType() == 8) {
                            object2 = object2.complement((IntSet)IntervalSet.of((int)1, (int)this.atn.maxTokenType));
                        }
                        if (bl) {
                            if (this.translateToRuleIndex(linkedList)) continue block13;
                            object32 = object2.toList();
                            boolean bl3 = object32.size() == 1;
                            Iterator iterator = object32.iterator();
                            while (iterator.hasNext()) {
                                Integer n6 = (Integer)iterator.next();
                                if (!this.ignoredTokens.contains(n6)) {
                                    if (this.showDebugOutput && logger.isLoggable(Level.FINE)) {
                                        logger.fine("=====> collected: " + this.vocabulary.getDisplayName(n6.intValue()));
                                    }
                                    if (bl3) {
                                        this.candidates.tokens.put(n6, this.getFollowingTokens(transition));
                                        continue;
                                    }
                                    this.candidates.tokens.put(n6, new LinkedList());
                                    continue;
                                }
                                logger.fine("====> collected: Ignoring token: " + n6);
                            }
                            continue block13;
                        }
                        if (!object2.contains(n3)) continue block13;
                        if (this.showDebugOutput && logger.isLoggable(Level.FINE)) {
                            logger.fine("=====> consumed: " + this.vocabulary.getDisplayName(n3));
                        }
                        ((LinkedList)object).addLast(new PipelineEntry(transition.target, pipelineEntry.tokenIndex + 1));
                    }
                }
            }
        }
        linkedList.removeLast();
        map.put(n, hashSet);
        return hashSet;
    }

    private String generateBaseDescription(ATNState aTNState) {
        String string = aTNState.stateNumber == -1 ? "Invalid" : Integer.toString(aTNState.stateNumber);
        return "[" + string + " " + this.atnStateTypeMap[aTNState.getStateType()] + "] in " + this.ruleNames[aTNState.ruleIndex];
    }

    private void printDescription(String string, ATNState aTNState, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (this.debugOutputWithTransitions && logger.isLoggable(Level.FINER)) {
            for (Transition transition : aTNState.getTransitions()) {
                List list;
                StringBuilder stringBuilder3 = new StringBuilder();
                List list2 = list = transition.label() != null ? transition.label().toList() : new LinkedList();
                if (list.size() > 2) {
                    stringBuilder3.append(this.vocabulary.getDisplayName(((Integer)list.get(0)).intValue()) + " .. " + this.vocabulary.getDisplayName(((Integer)list.get(list.size() - 1)).intValue()));
                } else {
                    for (Integer n2 : list) {
                        if (stringBuilder3.length() > 0) {
                            stringBuilder3.append(", ");
                        }
                        stringBuilder3.append(this.vocabulary.getDisplayName(n2.intValue()));
                    }
                }
                if (stringBuilder3.length() == 0) {
                    stringBuilder3.append("\u03b5");
                }
                stringBuilder2.append("\n").append(string).append("\t(").append((CharSequence)stringBuilder3).append(") [").append(transition.target.stateNumber).append(" ").append(this.atnStateTypeMap[transition.target.getStateType()]).append("] in ").append(this.ruleNames[transition.target.ruleIndex]);
            }
            if (n >= this.tokens.size() - 1) {
                stringBuilder.append("<<").append(this.tokenStartIndex + n).append(">> ");
            } else {
                stringBuilder.append("<").append(this.tokenStartIndex + n).append("> ");
            }
            logger.finer(stringBuilder + "Current state: " + string2 + stringBuilder2);
        }
    }

    private void printRuleState(LinkedList<Integer> linkedList) {
        if (linkedList.isEmpty()) {
            logger.fine("<empty stack>");
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer n : linkedList) {
                stringBuilder.append("  ").append(this.ruleNames[n]).append("\n");
            }
            logger.log(Level.FINER, stringBuilder.toString());
        }
    }

    public static class PipelineEntry {
        ATNState state;
        Integer tokenIndex;

        public PipelineEntry(ATNState aTNState, Integer n) {
            this.state = aTNState;
            this.tokenIndex = n;
        }
    }

    public static class FollowSetsHolder {
        public List<FollowSetWithPath> sets;
        public IntervalSet combined;
    }

    public static class FollowSetWithPath {
        public IntervalSet intervals;
        public List<Integer> path;
        public List<Integer> following;
    }

    public static class CandidatesCollection {
        public Map<Integer, List<Integer>> tokens = new HashMap<Integer, List<Integer>>();
        public Map<Integer, List<Integer>> rules = new HashMap<Integer, List<Integer>>();
        public Map<Integer, List<Integer>> rulePositions = new HashMap<Integer, List<Integer>>();

        public String toString() {
            return "CandidatesCollection{tokens=" + this.tokens + ", rules=" + this.rules + ", ruleStrings=" + this.rulePositions + '}';
        }
    }
}

