/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.apexlink.indexer;

import com.nawforce.apexlink.api.IndexerConfiguration;
import com.nawforce.apexlink.api.ServerOps$;
import com.nawforce.apexlink.indexer.Monitor;
import com.nawforce.pkgforce.diagnostics.LoggerOps$;
import com.nawforce.pkgforce.documents.DirectoryTree;
import com.nawforce.pkgforce.documents.DirectoryTree$;
import com.nawforce.pkgforce.path.PathLike;
import com.nawforce.runtime.platform.Path;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd!\u0002\u000e\u001c\u0003\u0003!\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQ\u0001\u0013\u0001\u0005\u0002%Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004X\u0001\u0001\u0006Ia\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0004Z\u0011\u0019\u0001\u0007\u0001)A\u00075\"9\u0011\r\u0001a\u0001\n\u0013\u0011\u0007b\u00024\u0001\u0001\u0004%Ia\u001a\u0005\u0007U\u0002\u0001\u000b\u0015B2\t\u000f-\u0004\u0001\u0019!C\u0005Y\"91\u000f\u0001a\u0001\n\u0013!\bB\u0002<\u0001A\u0003&Q\u000e\u0003\u0005x\u0001!\u0015\r\u0011\"\u0003y\u0011\u001da\bA1A\u0005\nuDq!!\u0003\u0001A\u0003%a\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011Q\u0004\u0001A\u0002\u0013%\u0011q\u0004\u0005\t\u0003G\u0001\u0001\u0015)\u0003\u0002\u0010!9\u0011Q\u0005\u0001\u0007\u0002\u0005\u001d\u0002bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!a\u0019\u0001\t\u0003\tY\u0006C\u0004\u0002f\u0001!I!a\u0017\u0003\u000f%sG-\u001a=fe*\u0011A$H\u0001\bS:$W\r_3s\u0015\tqr$\u0001\u0005ba\u0016DH.\u001b8l\u0015\t\u0001\u0013%\u0001\u0005oC^4wN]2f\u0015\u0005\u0011\u0013aA2p[\u000e\u00011c\u0001\u0001&[A\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005Y\u0006twMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#AB(cU\u0016\u001cG\u000fE\u0002/gUj\u0011a\f\u0006\u0003aE\n!bY8oGV\u0014(/\u001a8u\u0015\t\u0011\u0014&\u0001\u0003vi&d\u0017B\u0001\u001b0\u0005!\u0019\u0015\r\u001c7bE2,\u0007C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$\u0001B+oSR\fA\u0001]1uQB\u0011Q(Q\u0007\u0002})\u00111h\u0010\u0006\u0003\u0001~\t\u0001\u0002]6hM>\u00148-Z\u0005\u0003\u0005z\u0012\u0001\u0002U1uQ2K7.Z\u0001\tY\u0006,hn\u00195feB\u0011QIR\u0007\u00027%\u0011qi\u0007\u0002\b\u001b>t\u0017\u000e^8s\u0003\u0019a\u0014N\\5u}Q\u0019!j\u0013'\u0011\u0005\u0015\u0003\u0001\"B\u001e\u0004\u0001\u0004a\u0004\"B\"\u0004\u0001\u0004!\u0015\u0001\u0003:p_R\u0004\u0016\r\u001e5\u0016\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u0011Ad\u0017\r\u001e4pe6T!\u0001V\u0010\u0002\u000fI,h\u000e^5nK&\u0011a+\u0015\u0002\u0005!\u0006$\b.A\u0005s_>$\b+\u0019;iA\u000511m\u001c8gS\u001e,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;v\t1!\u00199j\u0013\tyFL\u0001\u000bJ]\u0012,\u00070\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u00035a\u0017m\u001d;Fm\u0016tG\u000fV5dWV\t1\r\u0005\u00027I&\u0011Qm\u000e\u0002\u0005\u0019>tw-A\tmCN$XI^3oiRK7m[0%KF$\"!\u000e5\t\u000f%L\u0011\u0011!a\u0001G\u0006\u0019\u0001\u0010J\u0019\u0002\u001d1\f7\u000f^#wK:$H+[2lA\u0005a!/Z:dC:4U\u000f^;sKV\tQ\u000eE\u00027]BL!a\\\u001c\u0003\r=\u0003H/[8o!\rq\u0013/N\u0005\u0003e>\u0012qbU2iK\u0012,H.\u001a3GkR,(/Z\u0001\u0011e\u0016\u001c8-\u00198GkR,(/Z0%KF$\"!N;\t\u000f%d\u0011\u0011!a\u0001[\u0006i!/Z:dC:4U\u000f^;sK\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003e\u0004\"A\f>\n\u0005m|#\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006a1-\u00197mE\u0006\u001c7\u000eT8dWV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rq&A\u0003m_\u000e\\7/\u0003\u0003\u0002\b\u0005\u0005!!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0007dC2d'-Y2l\u0019>\u001c7\u000eI\u0001\u0005e>|G/\u0006\u0002\u0002\u0010A!aG\\A\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\u007f\u0005IAm\\2v[\u0016tGo]\u0005\u0005\u00037\t)BA\u0007ESJ,7\r^8ssR\u0013X-Z\u0001\te>|Go\u0018\u0013fcR\u0019Q'!\t\t\u0011%\u0014\u0012\u0011!a\u0001\u0003\u001f\tQA]8pi\u0002\nab\u001c8GS2,7o\u00115b]\u001e,G\rF\u00036\u0003S\t9\u0005\u0003\u0004<)\u0001\u0007\u00111\u0006\t\u0006m\u00055\u0012\u0011G\u0005\u0004\u0003_9$!B!se\u0006L\b\u0003BA\u001a\u0003\u0003rA!!\u000e\u0002>A\u0019\u0011qG\u001c\u000e\u0005\u0005e\"bAA\u001eG\u00051AH]8pizJ1!a\u00108\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\u0019\u0019FO]5oO*\u0019\u0011qH\u001c\t\u000f\u0005%C\u00031\u0001\u0002L\u00051!/Z:dC:\u00042ANA'\u0013\r\tye\u000e\u0002\b\u0005>|G.Z1o\u0003AIgN[3di\u001aKG.Z\"iC:<W\rF\u00026\u0003+Bq!a\u0016\u0016\u0001\u0004\t\t$\u0001\u0003gS2,\u0017\u0001B:u_B$\u0012!N\u0001\r_:4\u0015\u000e\\3DQ\u0006tw-\u001a\u000b\u0004k\u0005\u0005\u0004bBA,/\u0001\u0007\u0011\u0011G\u0001\u0005G\u0006dG.A\u0004sK\u001a\u0014Xm\u001d5")
public abstract class Indexer
implements Callable<BoxedUnit> {
    private ScheduledExecutorService scheduler;
    private final Monitor launcher;
    private final Path rootPath;
    private final IndexerConfiguration config;
    private long lastEventTick;
    private Option<ScheduledFuture<BoxedUnit>> rescanFuture;
    private final ReentrantLock callbackLock;
    private Option<DirectoryTree> root;
    private volatile boolean bitmap$0;

    private Path rootPath() {
        return this.rootPath;
    }

    private final IndexerConfiguration config() {
        return this.config;
    }

    private long lastEventTick() {
        return this.lastEventTick;
    }

    private void lastEventTick_$eq(long x$1) {
        this.lastEventTick = x$1;
    }

    private Option<ScheduledFuture<BoxedUnit>> rescanFuture() {
        return this.rescanFuture;
    }

    private void rescanFuture_$eq(Option<ScheduledFuture<BoxedUnit>> x$1) {
        this.rescanFuture = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private ScheduledExecutorService scheduler$lzycompute() {
        Indexer indexer = this;
        synchronized (indexer) {
            if (!this.bitmap$0) {
                void var2_2;
                ScheduledThreadPoolExecutor s = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
                s.setRemoveOnCancelPolicy(true);
                this.scheduler = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.scheduler;
    }

    private ScheduledExecutorService scheduler() {
        if (!this.bitmap$0) {
            return this.scheduler$lzycompute();
        }
        return this.scheduler;
    }

    private ReentrantLock callbackLock() {
        return this.callbackLock;
    }

    private Option<DirectoryTree> root() {
        return this.root;
    }

    private void root_$eq(Option<DirectoryTree> x$1) {
        this.root = x$1;
    }

    public abstract void onFilesChanged(String[] var1, boolean var2);

    public void injectFileChange(String file) {
        this.onFileChange(file);
    }

    public void stop() {
        this.rescanFuture().foreach((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.cancel(false)));
        this.scheduler().shutdown();
    }

    private void onFileChange(String file) {
        ReentrantLock reentrantLock = this.callbackLock();
        synchronized (reentrantLock) {
            long now = System.currentTimeMillis();
            if (this.rescanFuture().nonEmpty() || now - this.lastEventTick() < this.config().rescanTriggerTimeMs()) {
                this.rescanFuture().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cancel(false)));
                this.rescanFuture_$eq((Option<ScheduledFuture<BoxedUnit>>)new Some(this.scheduler().schedule(this, this.config().quietPeriodForRescanMs(), TimeUnit.MILLISECONDS)));
            } else {
                this.onFilesChanged((String[])((Object[])new String[]{file}), false);
            }
            this.lastEventTick_$eq(now);
        }
    }

    @Override
    public void call() {
        this.rescanFuture_$eq((Option<ScheduledFuture<BoxedUnit>>)None$.MODULE$);
        this.refresh();
    }

    private void refresh() {
        LoggerOps$.MODULE$.debugTime(new StringBuilder(19).append("Indexer re-scanned ").append(this.rootPath()).toString(), LoggerOps$.MODULE$.debugTime$default$2(), LoggerOps$.MODULE$.debugTime$default$3(), (JFunction0.mcV.sp & Serializable)() -> {
            ArrayBuffer changed = new ArrayBuffer();
            this.root_$eq((Option<DirectoryTree>)this.root().map((Function1 & Serializable)x$2 -> x$2.refresh((ArrayBuffer<String>)changed)));
            this.onFilesChanged((String[])changed.toArray(ClassTag$.MODULE$.apply(String.class)), true);
        });
    }

    public Indexer(PathLike path, Monitor launcher) {
        None$ none$;
        this.launcher = launcher;
        this.rootPath = (Path)path;
        this.config = ServerOps$.MODULE$.getIndexerConfiguration();
        this.lastEventTick = 0L;
        this.rescanFuture = None$.MODULE$;
        this.callbackLock = new ReentrantLock(true);
        if (this.config().enabled()) {
            none$ = (Option)LoggerOps$.MODULE$.debugTime(new StringBuilder(16).append("Indexer scanned ").append(this.rootPath()).toString(), LoggerOps$.MODULE$.debugTime$default$2(), LoggerOps$.MODULE$.debugTime$default$3(), (Function0 & Serializable)() -> {
                DirectoryTree index = DirectoryTree$.MODULE$.apply(this.rootPath(), (ArrayBuffer<String>)new ArrayBuffer());
                $this.launcher.monitor(this.rootPath(), (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                    this.onFileChange(file);
                    return BoxedUnit.UNIT;
                });
                return new Some((Object)index);
            });
        } else {
            LoggerOps$.MODULE$.debug(new StringBuilder(38).append("Indexer for ").append(this.rootPath()).append(" not started due to config").toString());
            none$ = None$.MODULE$;
        }
        this.root = none$;
    }
}

