/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient;

import io.github.aquerr.steamwebapiclient.SteamHttpClient;
import io.github.aquerr.steamwebapiclient.SteamWebApiInterfaceMethod;
import io.github.aquerr.steamwebapiclient.exception.ClientException;
import io.github.aquerr.steamwebapiclient.request.AccountListRequest;
import io.github.aquerr.steamwebapiclient.request.AccountPublicInfoRequest;
import io.github.aquerr.steamwebapiclient.request.CreateAccountRequest;
import io.github.aquerr.steamwebapiclient.request.DeleteAccountRequest;
import io.github.aquerr.steamwebapiclient.request.QueryLoginTokenRequest;
import io.github.aquerr.steamwebapiclient.request.ResetLoginTokenRequest;
import io.github.aquerr.steamwebapiclient.request.ServerIPsBySteamIdRequest;
import io.github.aquerr.steamwebapiclient.request.ServerSteamIDsByIPRequest;
import io.github.aquerr.steamwebapiclient.request.SetMemoRequest;
import io.github.aquerr.steamwebapiclient.response.AccountListResponse;
import io.github.aquerr.steamwebapiclient.response.AccountPublicInfoResponse;
import io.github.aquerr.steamwebapiclient.response.CreateAccountResponse;
import io.github.aquerr.steamwebapiclient.response.DeleteAccountResponse;
import io.github.aquerr.steamwebapiclient.response.QueryLoginTokenResponse;
import io.github.aquerr.steamwebapiclient.response.ResetLoginTokenResponse;
import io.github.aquerr.steamwebapiclient.response.ServerIPsBySteamIdResponse;
import io.github.aquerr.steamwebapiclient.response.ServerSteamIDsByIPResponse;
import io.github.aquerr.steamwebapiclient.response.SetMemoResponse;

public class SteamGameServersServiceApiClient {
    private final SteamHttpClient steamHttpClient;

    public AccountListResponse getAccountList(AccountListRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_GET_ACCOUNT_LIST, "v1", request, AccountListResponse.class);
    }

    public CreateAccountResponse createAccount(CreateAccountRequest request) throws ClientException {
        return this.steamHttpClient.post(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_CREATE_ACCOUNT, "v1", request, CreateAccountResponse.class);
    }

    public DeleteAccountResponse deleteAccount(DeleteAccountRequest request) throws ClientException {
        return this.steamHttpClient.post(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_DELETE_ACCOUNT, "v1", request, DeleteAccountResponse.class);
    }

    public SetMemoResponse setMemo(SetMemoRequest request) throws ClientException {
        return this.steamHttpClient.post(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_SET_MEMO, "v1", request, SetMemoResponse.class);
    }

    public ResetLoginTokenResponse resetLoginToken(ResetLoginTokenRequest request) throws ClientException {
        return this.steamHttpClient.post(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_RESET_LOGIN_TOKEN, "v1", request, ResetLoginTokenResponse.class);
    }

    public AccountPublicInfoResponse getAccountPublicInfo(AccountPublicInfoRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_GET_ACCOUNT_PUBLIC_INFO, "v1", request, AccountPublicInfoResponse.class);
    }

    public QueryLoginTokenResponse queryLoginToken(QueryLoginTokenRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_QUERY_LOGIN_TOKEN, "v1", request, QueryLoginTokenResponse.class);
    }

    public ServerIPsBySteamIdResponse getServerIPsBySteamId(ServerIPsBySteamIdRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_GET_SERVER_IPS_BY_STEAM_ID, "v1", request, ServerIPsBySteamIdResponse.class);
    }

    public ServerSteamIDsByIPResponse getServerSteamIdsByIP(ServerSteamIDsByIPRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_GAME_SERVERS_SERVICE_GET_SERVER_STEAM_IDS_BY_IP, "v1", request, ServerSteamIDsByIPResponse.class);
    }

    SteamGameServersServiceApiClient(SteamHttpClient steamHttpClient) {
        this.steamHttpClient = steamHttpClient;
    }
}

