/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.aquerr.steamwebapiclient.HttpStatus;
import io.github.aquerr.steamwebapiclient.SteamWebApiInterfaceMethod;
import io.github.aquerr.steamwebapiclient.annotation.QueryParamCollectionBehaviour;
import io.github.aquerr.steamwebapiclient.annotation.SteamRequestQueryParam;
import io.github.aquerr.steamwebapiclient.exception.ClientException;
import io.github.aquerr.steamwebapiclient.exception.HttpClientException;
import io.github.aquerr.steamwebapiclient.request.SteamWebApiRequest;
import io.github.aquerr.steamwebapiclient.request.SteamWebApiRestrictedRequest;
import io.github.aquerr.steamwebapiclient.response.SteamWebApiResponse;
import io.github.aquerr.steamwebapiclient.util.UrlEncodedForm;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class SteamHttpClient {
    private final String apiKey;
    private final String baseUrl;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    SteamHttpClient(String baseUrl, String apiKey, HttpClient httpClient, ObjectMapper objectMapper) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper.copy();
    }

    public <T extends SteamWebApiResponse> T get(SteamWebApiInterfaceMethod apiInterfaceMethod, String version, SteamWebApiRequest steamWebApiRequest, Class<T> responseClass) throws ClientException {
        try {
            if (apiInterfaceMethod == null || version == null || responseClass == null) {
                throw new IllegalArgumentException("apiInterfaceMethod, version and responseClass cannot be null!");
            }
            this.populateApiKeyIfRestrictedRequest(steamWebApiRequest);
            StringBuilder uriPathBuilder = new StringBuilder(this.buildUrl(apiInterfaceMethod, version));
            if (steamWebApiRequest != null) {
                uriPathBuilder.append(this.toQueryString(this.toQueryParams(steamWebApiRequest)));
            }
            URI requestUri = URI.create(uriPathBuilder.toString());
            HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(requestUri).build();
            HttpResponse<String> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.getCode()) {
                return this.parseResponse(response, responseClass);
            }
            throw new HttpClientException(this.prepareHttpErrorMessage(response), response.statusCode());
        }
        catch (Exception exception) {
            throw this.wrapInClientException(exception);
        }
    }

    public <T extends SteamWebApiResponse> T post(SteamWebApiInterfaceMethod apiInterfaceMethod, String version, SteamWebApiRequest request, Class<T> responseClass) throws ClientException {
        try {
            if (apiInterfaceMethod == null || version == null || responseClass == null || request == null) {
                throw new IllegalArgumentException("apiInterfaceMethod, version, request and responseClass cannot be null!");
            }
            this.populateApiKeyIfRestrictedRequest(request);
            Map<String, String> params = this.toQueryParams(request);
            String requestJson = this.objectMapper.writeValueAsString((Object)request);
            params.put("input_json", URLEncoder.encode(requestJson, StandardCharsets.UTF_8));
            URI requestUri = URI.create(this.buildUrl(apiInterfaceMethod, version) + this.toQueryString(params));
            HttpRequest httpRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(" ")).uri(requestUri).build();
            HttpResponse<String> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.getCode()) {
                return this.parseResponse(response, responseClass);
            }
            throw new HttpClientException(this.prepareHttpErrorMessage(response), response.statusCode());
        }
        catch (Exception exception) {
            throw this.wrapInClientException(exception);
        }
    }

    private String prepareHttpErrorMessage(HttpResponse<String> httpResponse) {
        String httpStatus = Optional.ofNullable(HttpStatus.findByCode(httpResponse.statusCode())).orElse(HttpStatus.BAD_REQUEST).name();
        return httpResponse.statusCode() + " " + httpStatus + " Response body: " + httpResponse.body();
    }

    private ClientException wrapInClientException(Exception exception) {
        if (exception instanceof HttpClientException) {
            return (HttpClientException)exception;
        }
        return new ClientException(exception);
    }

    private <T extends SteamWebApiResponse> T parseResponse(HttpResponse<String> response, Class<T> responseClass) throws JsonProcessingException {
        ObjectNode responseObjectNode = (ObjectNode)this.objectMapper.readValue(response.body(), ObjectNode.class);
        SteamWebApiResponse steamWebApiResponse = (SteamWebApiResponse)this.objectMapper.treeToValue((TreeNode)responseObjectNode, responseClass);
        return (T)steamWebApiResponse;
    }

    public <T extends SteamWebApiResponse> T post(SteamWebApiInterfaceMethod apiInterfaceMethod, String version, UrlEncodedForm urlEncodedForm, Class<T> responseClass) throws ClientException {
        try {
            if (apiInterfaceMethod == null || version == null || responseClass == null || urlEncodedForm == null) {
                throw new IllegalArgumentException("apiInterfaceMethod, version, urlEncodedForm and responseClass cannot be null!");
            }
            URI requestUri = URI.create(this.buildUrl(apiInterfaceMethod, version));
            byte[] formBytes = urlEncodedForm.getAsByteArray();
            HttpRequest httpRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(formBytes)).header("Content-Type", "application/x-www-form-urlencoded").uri(requestUri).build();
            HttpResponse<String> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.getCode()) {
                return this.parseResponse(response, responseClass);
            }
            throw new HttpClientException(this.prepareHttpErrorMessage(response), response.statusCode());
        }
        catch (Exception exception) {
            throw this.wrapInClientException(exception);
        }
    }

    private void populateApiKeyIfRestrictedRequest(SteamWebApiRequest steamWebApiRequest) {
        if (steamWebApiRequest instanceof SteamWebApiRestrictedRequest) {
            SteamWebApiRestrictedRequest request = (SteamWebApiRestrictedRequest)steamWebApiRequest;
            request.setApiKey(this.apiKey);
        }
    }

    private String toQueryString(Map<String, String> queryParams) {
        if (queryParams.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("?");
        queryParams.entrySet().stream().filter(queryParam -> queryParam.getValue() != null).forEach(queryParam -> stringBuilder.append((String)queryParam.getKey()).append("=").append((String)queryParam.getValue()).append("&"));
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '&') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private Map<String, String> toQueryParams(SteamWebApiRequest steamWebApiRequest) {
        Field[] fields;
        HashMap<String, String> params = new HashMap<String, String>();
        for (Field field : fields = steamWebApiRequest.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(SteamRequestQueryParam.class)) continue;
            this.insertParam(params, steamWebApiRequest, field);
        }
        return params;
    }

    private void insertParam(Map<String, String> params, SteamWebApiRequest steamWebApiRequest, Field field) {
        SteamRequestQueryParam steamRequestQueryParam = field.getAnnotation(SteamRequestQueryParam.class);
        String name = this.getSteamRequestParamNameFromField(steamRequestQueryParam, field);
        if (Collection.class.isAssignableFrom(field.getType()) && steamRequestQueryParam.collectionBehaviour() == QueryParamCollectionBehaviour.MULTIPLE_PARAMETERS) {
            Collection<?> collection = this.getFieldValueAsCollection(steamWebApiRequest, field);
            if (collection != null) {
                int index = 0;
                for (Object object : collection) {
                    String paramName = name + "[" + index + "]";
                    ++index;
                    params.put(paramName, URLEncoder.encode(String.valueOf(object), StandardCharsets.UTF_8));
                }
            }
        } else {
            String fieldValue = this.getFieldValueAsString(steamWebApiRequest, field);
            if (fieldValue != null) {
                params.put(name, URLEncoder.encode(fieldValue, StandardCharsets.UTF_8));
            }
        }
    }

    private String getSteamRequestParamNameFromField(SteamRequestQueryParam steamRequestQueryParam, Field field) {
        try {
            if (steamRequestQueryParam.value() != null && !steamRequestQueryParam.value().trim().isEmpty()) {
                return steamRequestQueryParam.value();
            }
            return field.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<?> getFieldValueAsCollection(SteamWebApiRequest steamWebApiRequest, Field field) {
        try {
            boolean canAccess = field.canAccess(steamWebApiRequest);
            if (!canAccess) {
                field.setAccessible(true);
            }
            Object value = field.get(steamWebApiRequest);
            field.setAccessible(canAccess);
            if (value != null && value instanceof Collection) {
                return (Collection)value;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldValueAsString(SteamWebApiRequest steamWebApiRequest, Field field) {
        try {
            boolean canAccess = field.canAccess(steamWebApiRequest);
            if (!canAccess) {
                field.setAccessible(true);
            }
            Object value = field.get(steamWebApiRequest);
            field.setAccessible(canAccess);
            if (value != null) {
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    return this.collectionToString(collection);
                }
                return String.valueOf(value);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String collectionToString(Collection<?> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return Arrays.stream(collection.toArray()).reduce("", (base, element) -> base + "," + element).toString().substring(1);
    }

    private String buildUrl(SteamWebApiInterfaceMethod apiInterfaceMethod, String version) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.baseUrl);
        urlBuilder.append("/");
        urlBuilder.append(apiInterfaceMethod.getInterfaceName());
        urlBuilder.append("/");
        urlBuilder.append(apiInterfaceMethod.getMethodName());
        urlBuilder.append("/");
        urlBuilder.append(version);
        return urlBuilder.toString();
    }
}

