/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient;

import io.github.aquerr.steamwebapiclient.SteamHttpClient;
import io.github.aquerr.steamwebapiclient.SteamWebApiInterfaceMethod;
import io.github.aquerr.steamwebapiclient.exception.ClientException;
import io.github.aquerr.steamwebapiclient.request.BadgesRequest;
import io.github.aquerr.steamwebapiclient.request.CommunityBadgeProgressRequest;
import io.github.aquerr.steamwebapiclient.request.OwnedGamesRequest;
import io.github.aquerr.steamwebapiclient.request.PlayerRecentlyPlayedGamesRequest;
import io.github.aquerr.steamwebapiclient.request.SteamLevelRequest;
import io.github.aquerr.steamwebapiclient.response.BadgesResponse;
import io.github.aquerr.steamwebapiclient.response.CommunityBadgeProgressResponse;
import io.github.aquerr.steamwebapiclient.response.OwnedGamesResponse;
import io.github.aquerr.steamwebapiclient.response.PlayerRecentlyPlayedGamesResponse;
import io.github.aquerr.steamwebapiclient.response.SteamLevelResponse;

public class SteamPlayerWebApiClient {
    private final SteamHttpClient steamHttpClient;

    public PlayerRecentlyPlayedGamesResponse getRecentlyPlayedGames(PlayerRecentlyPlayedGamesRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_PLAYER_SERVICE_GET_RECENTLY_PLAYED_GAMES, "v1", request, PlayerRecentlyPlayedGamesResponse.class);
    }

    public OwnedGamesResponse getOwnedGames(OwnedGamesRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_PLAYER_SERVICE_GET_OWNED_GAMES, "v1", request, OwnedGamesResponse.class);
    }

    public SteamLevelResponse getSteamLevel(SteamLevelRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_PLAYER_SERVICE_GET_STEAM_LEVEL, "v1", request, SteamLevelResponse.class);
    }

    public BadgesResponse getBadges(BadgesRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_PLAYER_SERVICE_GET_BADGES, "v1", request, BadgesResponse.class);
    }

    public CommunityBadgeProgressResponse getCommunityBadgeProgress(CommunityBadgeProgressRequest request) throws ClientException {
        return this.steamHttpClient.get(SteamWebApiInterfaceMethod.I_PLAYER_SERVICE_GET_COMMUNITY_BADGE_PROGRESS, "v1", request, CommunityBadgeProgressResponse.class);
    }

    SteamPlayerWebApiClient(SteamHttpClient steamHttpClient) {
        this.steamHttpClient = steamHttpClient;
    }
}

