/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.aquerr.steamwebapiclient.SteamEconServiceWebApiClient;
import io.github.aquerr.steamwebapiclient.SteamGameServersServiceApiClient;
import io.github.aquerr.steamwebapiclient.SteamHttpClient;
import io.github.aquerr.steamwebapiclient.SteamNewsWebApiClient;
import io.github.aquerr.steamwebapiclient.SteamPlayerWebApiClient;
import io.github.aquerr.steamwebapiclient.SteamPublishedFileWebApiClient;
import io.github.aquerr.steamwebapiclient.SteamRemoteStorageClient;
import io.github.aquerr.steamwebapiclient.SteamUtilWebApiClient;
import java.net.http.HttpClient;
import java.time.Duration;

public class SteamWebApiClient {
    public static final String BASE_WEB_API_URI = "https://api.steampowered.com";
    public static final String API_VERSION_1 = "v1";
    public static final String API_VERSION_2 = "v2";
    private final SteamPublishedFileWebApiClient steamPublishedFileWebApiClient;
    private final SteamUtilWebApiClient steamUtilWebApiClient;
    private final SteamPlayerWebApiClient steamPlayerWebApiClient;
    private final SteamRemoteStorageClient steamRemoteStorageClient;
    private final SteamNewsWebApiClient steamNewsWebApiClient;
    private final SteamGameServersServiceApiClient steamGameServersServiceApiClient;
    private final SteamEconServiceWebApiClient steamEconServiceWebApiClient;

    private SteamWebApiClient(String baseUrl, String apiKey, HttpClient httpClient, ObjectMapper objectMapper) {
        this(new SteamHttpClient(baseUrl, apiKey, httpClient, objectMapper));
    }

    private SteamWebApiClient(SteamHttpClient steamHttpClient) {
        this.steamPublishedFileWebApiClient = new SteamPublishedFileWebApiClient(steamHttpClient);
        this.steamUtilWebApiClient = new SteamUtilWebApiClient(steamHttpClient);
        this.steamPlayerWebApiClient = new SteamPlayerWebApiClient(steamHttpClient);
        this.steamRemoteStorageClient = new SteamRemoteStorageClient(steamHttpClient);
        this.steamNewsWebApiClient = new SteamNewsWebApiClient(steamHttpClient);
        this.steamGameServersServiceApiClient = new SteamGameServersServiceApiClient(steamHttpClient);
        this.steamEconServiceWebApiClient = new SteamEconServiceWebApiClient(steamHttpClient);
    }

    public SteamPublishedFileWebApiClient getSteamPublishedFileWebApiClient() {
        return this.steamPublishedFileWebApiClient;
    }

    public SteamUtilWebApiClient getSteamUtilWebApiClient() {
        return this.steamUtilWebApiClient;
    }

    public SteamRemoteStorageClient getSteamRemoteStorageClient() {
        return this.steamRemoteStorageClient;
    }

    public SteamPlayerWebApiClient getPlayerWebApiClient() {
        return this.steamPlayerWebApiClient;
    }

    public SteamNewsWebApiClient getNewsWebApiClient() {
        return this.steamNewsWebApiClient;
    }

    public SteamGameServersServiceApiClient getSteamGameServersServiceApiClient() {
        return this.steamGameServersServiceApiClient;
    }

    public SteamEconServiceWebApiClient getSteamEconServiceWebApiClient() {
        return this.steamEconServiceWebApiClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static HttpClient defaultHttpClient() {
        return HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    }

    protected static ObjectMapper defaultObjectMapper() {
        return new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).findAndRegisterModules();
    }

    public static class Builder {
        private String baseUrl = "https://api.steampowered.com";
        private String apiKey;
        private HttpClient httpClient = SteamWebApiClient.defaultHttpClient();
        private ObjectMapper objectMapper = SteamWebApiClient.defaultObjectMapper();

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public SteamWebApiClient build() {
            return new SteamWebApiClient(this.baseUrl, this.apiKey, this.httpClient, this.objectMapper);
        }
    }
}

