/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient.request;

import io.github.aquerr.steamwebapiclient.annotation.SteamRequestQueryParam;
import io.github.aquerr.steamwebapiclient.request.SteamWebApiRequest;
import lombok.NonNull;

public class NewsForAppRequest
implements SteamWebApiRequest {
    @SteamRequestQueryParam(value="appid")
    @NonNull
    private int appId;
    @SteamRequestQueryParam(value="maxlength")
    private Integer maxLength;
    @SteamRequestQueryParam(value="enddate")
    private Long endDate;
    @SteamRequestQueryParam(value="count")
    private Integer count;
    @SteamRequestQueryParam(value="feeds")
    private String feeds;

    NewsForAppRequest(@NonNull int appId, Integer maxLength, Long endDate, Integer count, String feeds) {
        this.appId = appId;
        this.maxLength = maxLength;
        this.endDate = endDate;
        this.count = count;
        this.feeds = feeds;
    }

    public static NewsForAppRequestBuilder builder() {
        return new NewsForAppRequestBuilder();
    }

    @NonNull
    public int getAppId() {
        return this.appId;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getFeeds() {
        return this.feeds;
    }

    public void setAppId(@NonNull int appId) {
        this.appId = appId;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setFeeds(String feeds) {
        this.feeds = feeds;
    }

    public String toString() {
        return "NewsForAppRequest(appId=" + this.getAppId() + ", maxLength=" + this.getMaxLength() + ", endDate=" + this.getEndDate() + ", count=" + this.getCount() + ", feeds=" + this.getFeeds() + ")";
    }

    public static class NewsForAppRequestBuilder {
        private int appId;
        private Integer maxLength;
        private Long endDate;
        private Integer count;
        private String feeds;

        NewsForAppRequestBuilder() {
        }

        public NewsForAppRequestBuilder appId(@NonNull int appId) {
            this.appId = appId;
            return this;
        }

        public NewsForAppRequestBuilder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public NewsForAppRequestBuilder endDate(Long endDate) {
            this.endDate = endDate;
            return this;
        }

        public NewsForAppRequestBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public NewsForAppRequestBuilder feeds(String feeds) {
            this.feeds = feeds;
            return this;
        }

        public NewsForAppRequest build() {
            return new NewsForAppRequest(this.appId, this.maxLength, this.endDate, this.count, this.feeds);
        }

        public String toString() {
            return "NewsForAppRequest.NewsForAppRequestBuilder(appId=" + this.appId + ", maxLength=" + this.maxLength + ", endDate=" + this.endDate + ", count=" + this.count + ", feeds=" + this.feeds + ")";
        }
    }
}

