/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient;

import io.github.aquerr.steamwebapiclient.SteamHttpClient;
import io.github.aquerr.steamwebapiclient.SteamWebApiInterfaceMethod;
import io.github.aquerr.steamwebapiclient.exception.ClientException;
import io.github.aquerr.steamwebapiclient.request.CollectionDetailsRequest;
import io.github.aquerr.steamwebapiclient.request.PublishedFileDetailsRequest;
import io.github.aquerr.steamwebapiclient.response.CollectionDetailsResponse;
import io.github.aquerr.steamwebapiclient.response.PublishedFileDetailsResponse;
import io.github.aquerr.steamwebapiclient.util.UrlEncodedForm;
import java.util.HashMap;

public class SteamRemoteStorageClient {
    private final SteamHttpClient steamHttpClient;

    SteamRemoteStorageClient(SteamHttpClient steamHttpClient) {
        this.steamHttpClient = steamHttpClient;
    }

    public PublishedFileDetailsResponse getPublishedFileDetails(PublishedFileDetailsRequest request) throws ClientException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("itemcount", String.valueOf(request.getItemCount()));
        for (int i = 0; i < request.getItemCount(); ++i) {
            parameters.put("publishedfileids[" + i + "]", String.valueOf(request.getPublishedFileIds().get(i)));
        }
        return this.steamHttpClient.post(SteamWebApiInterfaceMethod.I_STEAM_REMOTE_STORAGE_GET_PUBLISHED_FILE_DETAILS, "v1", UrlEncodedForm.of(parameters), PublishedFileDetailsResponse.class);
    }

    public CollectionDetailsResponse getCollectionDetails(CollectionDetailsRequest request) throws ClientException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("collectioncount", String.valueOf(request.getCollectionCount()));
        for (int i = 0; i < request.getCollectionCount(); ++i) {
            parameters.put("publishedfileids[" + i + "]", String.valueOf(request.getCollectionIds().get(i)));
        }
        return this.steamHttpClient.post(SteamWebApiInterfaceMethod.I_STEAM_REMOTE_STORAGE_GET_COLLECTION_DETAILS, "v1", UrlEncodedForm.of(parameters), CollectionDetailsResponse.class);
    }
}

