/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient.response.shared;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class PublishedFileDetails {
    @JsonProperty(value="app_name")
    private String appName;
    @JsonProperty(value="ban_reason")
    private String banReason;
    @JsonProperty(value="ban_text_check_result")
    private int banTextCheckResult;
    @JsonProperty(value="banner")
    private String banner;
    @JsonProperty(value="can_be_deleted")
    private boolean canBeDeleted;
    @JsonProperty(value="can_subscribe")
    private boolean canSubscribe;
    @JsonProperty(value="consumer_appid")
    private int consumerAppId;
    @JsonProperty(value="consumer_shortcutid")
    private String consumerShortCutId;
    @JsonProperty(value="creator")
    private String creator;
    @JsonProperty(value="creator_appid")
    private int creatorAppId;
    @JsonProperty(value="favorited")
    private int favorited;
    @JsonProperty(value="file_description")
    private String fileDescription;
    @JsonProperty(value="short_description")
    private String shortDescription;
    @JsonProperty(value="file_size")
    private String fileSize;
    @JsonProperty(value="file_type")
    private int fileType;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="flags")
    private int flags;
    @JsonProperty(value="followers")
    private int followers;
    @JsonProperty(value="hcontent_file")
    private String hcontentFile;
    @JsonProperty(value="hcontent_preview")
    private String hcontentPreview;
    @JsonProperty(value="language")
    private int language;
    @JsonProperty(value="lifetime_favorited")
    private int lifetimeFavorited;
    @JsonProperty(value="lifetime_followers")
    private int lifetimeFollowers;
    @JsonProperty(value="lifetime_playtime")
    private String lifetimePlaytimeMinutes;
    @JsonProperty(value="lifetime_playtime_sessions")
    private String lifetimePlaytimeSessionsMinutes;
    @JsonProperty(value="lifetime_subscriptions")
    private int lifetimeSubscriptions;
    @JsonProperty(value="maybe_inappropriate_sex")
    private boolean maybeInappropriateSex;
    @JsonProperty(value="maybe_inappropriate_violence")
    private boolean maybeInappropriateViolence;
    @JsonProperty(value="num_children")
    private int numChildren;
    @JsonProperty(value="num_comments_public")
    private int numCommentsPublic;
    @JsonProperty(value="num_reports")
    private int numReports;
    @JsonProperty(value="previews")
    private List<Preview> previews = new ArrayList<Preview>();
    @JsonProperty(value="preview_file_size")
    private String previewFileSize;
    @JsonProperty(value="preview_url")
    private String previewUrl;
    @JsonProperty(value="publishedfileid")
    private String publishedFileId;
    @JsonProperty(value="result")
    private int result;
    @JsonProperty(value="revision")
    private int revision;
    private List<Reaction> reactions = new ArrayList<Reaction>();
    @JsonProperty(value="revision_change_number")
    private String revisionChangeNumber;
    @JsonProperty(value="show_subscribe_all")
    private boolean showSubscribeAll;
    @JsonProperty(value="subscriptions")
    private int subscriptions;
    @JsonProperty(value="tags")
    private List<Tag> tags = new LinkedList<Tag>();
    @JsonProperty(value="kvtags")
    private List<KeyValueTag> keyValueTags = new LinkedList<KeyValueTag>();
    @JsonProperty(value="children")
    private List<ChildItem> children = new LinkedList<ChildItem>();
    @JsonProperty(value="vote_data")
    private VoteData voteData;
    @JsonProperty(value="time_created")
    private long createdTimeSeconds;
    @JsonProperty(value="time_updated")
    private long updatedTimeSeconds;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="views")
    private int views;
    @JsonProperty(value="visibility")
    private int visibility;
    @JsonProperty(value="workshop_accepted")
    private boolean workshopAccepted;
    @JsonProperty(value="workshop_file")
    private boolean workshopFile;

    public ZonedDateTime getCreatedDateTime() {
        return ZonedDateTime.of(LocalDateTime.ofEpochSecond(this.createdTimeSeconds, 0, ZoneOffset.UTC), ZoneOffset.UTC);
    }

    public ZonedDateTime getUpdatedDateTime() {
        return ZonedDateTime.of(LocalDateTime.ofEpochSecond(this.updatedTimeSeconds, 0, ZoneOffset.UTC), ZoneOffset.UTC);
    }

    @Generated
    public PublishedFileDetails() {
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public String getBanReason() {
        return this.banReason;
    }

    @Generated
    public int getBanTextCheckResult() {
        return this.banTextCheckResult;
    }

    @Generated
    public String getBanner() {
        return this.banner;
    }

    @Generated
    public boolean isCanBeDeleted() {
        return this.canBeDeleted;
    }

    @Generated
    public boolean isCanSubscribe() {
        return this.canSubscribe;
    }

    @Generated
    public int getConsumerAppId() {
        return this.consumerAppId;
    }

    @Generated
    public String getConsumerShortCutId() {
        return this.consumerShortCutId;
    }

    @Generated
    public String getCreator() {
        return this.creator;
    }

    @Generated
    public int getCreatorAppId() {
        return this.creatorAppId;
    }

    @Generated
    public int getFavorited() {
        return this.favorited;
    }

    @Generated
    public String getFileDescription() {
        return this.fileDescription;
    }

    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Generated
    public String getFileSize() {
        return this.fileSize;
    }

    @Generated
    public int getFileType() {
        return this.fileType;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public int getFlags() {
        return this.flags;
    }

    @Generated
    public int getFollowers() {
        return this.followers;
    }

    @Generated
    public String getHcontentFile() {
        return this.hcontentFile;
    }

    @Generated
    public String getHcontentPreview() {
        return this.hcontentPreview;
    }

    @Generated
    public int getLanguage() {
        return this.language;
    }

    @Generated
    public int getLifetimeFavorited() {
        return this.lifetimeFavorited;
    }

    @Generated
    public int getLifetimeFollowers() {
        return this.lifetimeFollowers;
    }

    @Generated
    public String getLifetimePlaytimeMinutes() {
        return this.lifetimePlaytimeMinutes;
    }

    @Generated
    public String getLifetimePlaytimeSessionsMinutes() {
        return this.lifetimePlaytimeSessionsMinutes;
    }

    @Generated
    public int getLifetimeSubscriptions() {
        return this.lifetimeSubscriptions;
    }

    @Generated
    public boolean isMaybeInappropriateSex() {
        return this.maybeInappropriateSex;
    }

    @Generated
    public boolean isMaybeInappropriateViolence() {
        return this.maybeInappropriateViolence;
    }

    @Generated
    public int getNumChildren() {
        return this.numChildren;
    }

    @Generated
    public int getNumCommentsPublic() {
        return this.numCommentsPublic;
    }

    @Generated
    public int getNumReports() {
        return this.numReports;
    }

    @Generated
    public List<Preview> getPreviews() {
        return this.previews;
    }

    @Generated
    public String getPreviewFileSize() {
        return this.previewFileSize;
    }

    @Generated
    public String getPreviewUrl() {
        return this.previewUrl;
    }

    @Generated
    public String getPublishedFileId() {
        return this.publishedFileId;
    }

    @Generated
    public int getResult() {
        return this.result;
    }

    @Generated
    public int getRevision() {
        return this.revision;
    }

    @Generated
    public List<Reaction> getReactions() {
        return this.reactions;
    }

    @Generated
    public String getRevisionChangeNumber() {
        return this.revisionChangeNumber;
    }

    @Generated
    public boolean isShowSubscribeAll() {
        return this.showSubscribeAll;
    }

    @Generated
    public int getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public List<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public List<KeyValueTag> getKeyValueTags() {
        return this.keyValueTags;
    }

    @Generated
    public List<ChildItem> getChildren() {
        return this.children;
    }

    @Generated
    public VoteData getVoteData() {
        return this.voteData;
    }

    @Generated
    public long getCreatedTimeSeconds() {
        return this.createdTimeSeconds;
    }

    @Generated
    public long getUpdatedTimeSeconds() {
        return this.updatedTimeSeconds;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public int getViews() {
        return this.views;
    }

    @Generated
    public int getVisibility() {
        return this.visibility;
    }

    @Generated
    public boolean isWorkshopAccepted() {
        return this.workshopAccepted;
    }

    @Generated
    public boolean isWorkshopFile() {
        return this.workshopFile;
    }

    @JsonProperty(value="app_name")
    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @JsonProperty(value="ban_reason")
    @Generated
    public void setBanReason(String banReason) {
        this.banReason = banReason;
    }

    @JsonProperty(value="ban_text_check_result")
    @Generated
    public void setBanTextCheckResult(int banTextCheckResult) {
        this.banTextCheckResult = banTextCheckResult;
    }

    @JsonProperty(value="banner")
    @Generated
    public void setBanner(String banner) {
        this.banner = banner;
    }

    @JsonProperty(value="can_be_deleted")
    @Generated
    public void setCanBeDeleted(boolean canBeDeleted) {
        this.canBeDeleted = canBeDeleted;
    }

    @JsonProperty(value="can_subscribe")
    @Generated
    public void setCanSubscribe(boolean canSubscribe) {
        this.canSubscribe = canSubscribe;
    }

    @JsonProperty(value="consumer_appid")
    @Generated
    public void setConsumerAppId(int consumerAppId) {
        this.consumerAppId = consumerAppId;
    }

    @JsonProperty(value="consumer_shortcutid")
    @Generated
    public void setConsumerShortCutId(String consumerShortCutId) {
        this.consumerShortCutId = consumerShortCutId;
    }

    @JsonProperty(value="creator")
    @Generated
    public void setCreator(String creator) {
        this.creator = creator;
    }

    @JsonProperty(value="creator_appid")
    @Generated
    public void setCreatorAppId(int creatorAppId) {
        this.creatorAppId = creatorAppId;
    }

    @JsonProperty(value="favorited")
    @Generated
    public void setFavorited(int favorited) {
        this.favorited = favorited;
    }

    @JsonProperty(value="file_description")
    @Generated
    public void setFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
    }

    @JsonProperty(value="short_description")
    @Generated
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @JsonProperty(value="file_size")
    @Generated
    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    @JsonProperty(value="file_type")
    @Generated
    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    @JsonProperty(value="filename")
    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @JsonProperty(value="flags")
    @Generated
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @JsonProperty(value="followers")
    @Generated
    public void setFollowers(int followers) {
        this.followers = followers;
    }

    @JsonProperty(value="hcontent_file")
    @Generated
    public void setHcontentFile(String hcontentFile) {
        this.hcontentFile = hcontentFile;
    }

    @JsonProperty(value="hcontent_preview")
    @Generated
    public void setHcontentPreview(String hcontentPreview) {
        this.hcontentPreview = hcontentPreview;
    }

    @JsonProperty(value="language")
    @Generated
    public void setLanguage(int language) {
        this.language = language;
    }

    @JsonProperty(value="lifetime_favorited")
    @Generated
    public void setLifetimeFavorited(int lifetimeFavorited) {
        this.lifetimeFavorited = lifetimeFavorited;
    }

    @JsonProperty(value="lifetime_followers")
    @Generated
    public void setLifetimeFollowers(int lifetimeFollowers) {
        this.lifetimeFollowers = lifetimeFollowers;
    }

    @JsonProperty(value="lifetime_playtime")
    @Generated
    public void setLifetimePlaytimeMinutes(String lifetimePlaytimeMinutes) {
        this.lifetimePlaytimeMinutes = lifetimePlaytimeMinutes;
    }

    @JsonProperty(value="lifetime_playtime_sessions")
    @Generated
    public void setLifetimePlaytimeSessionsMinutes(String lifetimePlaytimeSessionsMinutes) {
        this.lifetimePlaytimeSessionsMinutes = lifetimePlaytimeSessionsMinutes;
    }

    @JsonProperty(value="lifetime_subscriptions")
    @Generated
    public void setLifetimeSubscriptions(int lifetimeSubscriptions) {
        this.lifetimeSubscriptions = lifetimeSubscriptions;
    }

    @JsonProperty(value="maybe_inappropriate_sex")
    @Generated
    public void setMaybeInappropriateSex(boolean maybeInappropriateSex) {
        this.maybeInappropriateSex = maybeInappropriateSex;
    }

    @JsonProperty(value="maybe_inappropriate_violence")
    @Generated
    public void setMaybeInappropriateViolence(boolean maybeInappropriateViolence) {
        this.maybeInappropriateViolence = maybeInappropriateViolence;
    }

    @JsonProperty(value="num_children")
    @Generated
    public void setNumChildren(int numChildren) {
        this.numChildren = numChildren;
    }

    @JsonProperty(value="num_comments_public")
    @Generated
    public void setNumCommentsPublic(int numCommentsPublic) {
        this.numCommentsPublic = numCommentsPublic;
    }

    @JsonProperty(value="num_reports")
    @Generated
    public void setNumReports(int numReports) {
        this.numReports = numReports;
    }

    @JsonProperty(value="previews")
    @Generated
    public void setPreviews(List<Preview> previews) {
        this.previews = previews;
    }

    @JsonProperty(value="preview_file_size")
    @Generated
    public void setPreviewFileSize(String previewFileSize) {
        this.previewFileSize = previewFileSize;
    }

    @JsonProperty(value="preview_url")
    @Generated
    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @JsonProperty(value="publishedfileid")
    @Generated
    public void setPublishedFileId(String publishedFileId) {
        this.publishedFileId = publishedFileId;
    }

    @JsonProperty(value="result")
    @Generated
    public void setResult(int result) {
        this.result = result;
    }

    @JsonProperty(value="revision")
    @Generated
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Generated
    public void setReactions(List<Reaction> reactions) {
        this.reactions = reactions;
    }

    @JsonProperty(value="revision_change_number")
    @Generated
    public void setRevisionChangeNumber(String revisionChangeNumber) {
        this.revisionChangeNumber = revisionChangeNumber;
    }

    @JsonProperty(value="show_subscribe_all")
    @Generated
    public void setShowSubscribeAll(boolean showSubscribeAll) {
        this.showSubscribeAll = showSubscribeAll;
    }

    @JsonProperty(value="subscriptions")
    @Generated
    public void setSubscriptions(int subscriptions) {
        this.subscriptions = subscriptions;
    }

    @JsonProperty(value="tags")
    @Generated
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="kvtags")
    @Generated
    public void setKeyValueTags(List<KeyValueTag> keyValueTags) {
        this.keyValueTags = keyValueTags;
    }

    @JsonProperty(value="children")
    @Generated
    public void setChildren(List<ChildItem> children) {
        this.children = children;
    }

    @JsonProperty(value="vote_data")
    @Generated
    public void setVoteData(VoteData voteData) {
        this.voteData = voteData;
    }

    @JsonProperty(value="time_created")
    @Generated
    public void setCreatedTimeSeconds(long createdTimeSeconds) {
        this.createdTimeSeconds = createdTimeSeconds;
    }

    @JsonProperty(value="time_updated")
    @Generated
    public void setUpdatedTimeSeconds(long updatedTimeSeconds) {
        this.updatedTimeSeconds = updatedTimeSeconds;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="url")
    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="views")
    @Generated
    public void setViews(int views) {
        this.views = views;
    }

    @JsonProperty(value="visibility")
    @Generated
    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    @JsonProperty(value="workshop_accepted")
    @Generated
    public void setWorkshopAccepted(boolean workshopAccepted) {
        this.workshopAccepted = workshopAccepted;
    }

    @JsonProperty(value="workshop_file")
    @Generated
    public void setWorkshopFile(boolean workshopFile) {
        this.workshopFile = workshopFile;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishedFileDetails)) {
            return false;
        }
        PublishedFileDetails other = (PublishedFileDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBanTextCheckResult() != other.getBanTextCheckResult()) {
            return false;
        }
        if (this.isCanBeDeleted() != other.isCanBeDeleted()) {
            return false;
        }
        if (this.isCanSubscribe() != other.isCanSubscribe()) {
            return false;
        }
        if (this.getConsumerAppId() != other.getConsumerAppId()) {
            return false;
        }
        if (this.getCreatorAppId() != other.getCreatorAppId()) {
            return false;
        }
        if (this.getFavorited() != other.getFavorited()) {
            return false;
        }
        if (this.getFileType() != other.getFileType()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getFollowers() != other.getFollowers()) {
            return false;
        }
        if (this.getLanguage() != other.getLanguage()) {
            return false;
        }
        if (this.getLifetimeFavorited() != other.getLifetimeFavorited()) {
            return false;
        }
        if (this.getLifetimeFollowers() != other.getLifetimeFollowers()) {
            return false;
        }
        if (this.getLifetimeSubscriptions() != other.getLifetimeSubscriptions()) {
            return false;
        }
        if (this.isMaybeInappropriateSex() != other.isMaybeInappropriateSex()) {
            return false;
        }
        if (this.isMaybeInappropriateViolence() != other.isMaybeInappropriateViolence()) {
            return false;
        }
        if (this.getNumChildren() != other.getNumChildren()) {
            return false;
        }
        if (this.getNumCommentsPublic() != other.getNumCommentsPublic()) {
            return false;
        }
        if (this.getNumReports() != other.getNumReports()) {
            return false;
        }
        if (this.getResult() != other.getResult()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        if (this.isShowSubscribeAll() != other.isShowSubscribeAll()) {
            return false;
        }
        if (this.getSubscriptions() != other.getSubscriptions()) {
            return false;
        }
        if (this.getCreatedTimeSeconds() != other.getCreatedTimeSeconds()) {
            return false;
        }
        if (this.getUpdatedTimeSeconds() != other.getUpdatedTimeSeconds()) {
            return false;
        }
        if (this.getViews() != other.getViews()) {
            return false;
        }
        if (this.getVisibility() != other.getVisibility()) {
            return false;
        }
        if (this.isWorkshopAccepted() != other.isWorkshopAccepted()) {
            return false;
        }
        if (this.isWorkshopFile() != other.isWorkshopFile()) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$banReason = this.getBanReason();
        String other$banReason = other.getBanReason();
        if (this$banReason == null ? other$banReason != null : !this$banReason.equals(other$banReason)) {
            return false;
        }
        String this$banner = this.getBanner();
        String other$banner = other.getBanner();
        if (this$banner == null ? other$banner != null : !this$banner.equals(other$banner)) {
            return false;
        }
        String this$consumerShortCutId = this.getConsumerShortCutId();
        String other$consumerShortCutId = other.getConsumerShortCutId();
        if (this$consumerShortCutId == null ? other$consumerShortCutId != null : !this$consumerShortCutId.equals(other$consumerShortCutId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$fileDescription = this.getFileDescription();
        String other$fileDescription = other.getFileDescription();
        if (this$fileDescription == null ? other$fileDescription != null : !this$fileDescription.equals(other$fileDescription)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        String this$fileSize = this.getFileSize();
        String other$fileSize = other.getFileSize();
        if (this$fileSize == null ? other$fileSize != null : !this$fileSize.equals(other$fileSize)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$hcontentFile = this.getHcontentFile();
        String other$hcontentFile = other.getHcontentFile();
        if (this$hcontentFile == null ? other$hcontentFile != null : !this$hcontentFile.equals(other$hcontentFile)) {
            return false;
        }
        String this$hcontentPreview = this.getHcontentPreview();
        String other$hcontentPreview = other.getHcontentPreview();
        if (this$hcontentPreview == null ? other$hcontentPreview != null : !this$hcontentPreview.equals(other$hcontentPreview)) {
            return false;
        }
        String this$lifetimePlaytimeMinutes = this.getLifetimePlaytimeMinutes();
        String other$lifetimePlaytimeMinutes = other.getLifetimePlaytimeMinutes();
        if (this$lifetimePlaytimeMinutes == null ? other$lifetimePlaytimeMinutes != null : !this$lifetimePlaytimeMinutes.equals(other$lifetimePlaytimeMinutes)) {
            return false;
        }
        String this$lifetimePlaytimeSessionsMinutes = this.getLifetimePlaytimeSessionsMinutes();
        String other$lifetimePlaytimeSessionsMinutes = other.getLifetimePlaytimeSessionsMinutes();
        if (this$lifetimePlaytimeSessionsMinutes == null ? other$lifetimePlaytimeSessionsMinutes != null : !this$lifetimePlaytimeSessionsMinutes.equals(other$lifetimePlaytimeSessionsMinutes)) {
            return false;
        }
        List<Preview> this$previews = this.getPreviews();
        List<Preview> other$previews = other.getPreviews();
        if (this$previews == null ? other$previews != null : !((Object)this$previews).equals(other$previews)) {
            return false;
        }
        String this$previewFileSize = this.getPreviewFileSize();
        String other$previewFileSize = other.getPreviewFileSize();
        if (this$previewFileSize == null ? other$previewFileSize != null : !this$previewFileSize.equals(other$previewFileSize)) {
            return false;
        }
        String this$previewUrl = this.getPreviewUrl();
        String other$previewUrl = other.getPreviewUrl();
        if (this$previewUrl == null ? other$previewUrl != null : !this$previewUrl.equals(other$previewUrl)) {
            return false;
        }
        String this$publishedFileId = this.getPublishedFileId();
        String other$publishedFileId = other.getPublishedFileId();
        if (this$publishedFileId == null ? other$publishedFileId != null : !this$publishedFileId.equals(other$publishedFileId)) {
            return false;
        }
        List<Reaction> this$reactions = this.getReactions();
        List<Reaction> other$reactions = other.getReactions();
        if (this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions)) {
            return false;
        }
        String this$revisionChangeNumber = this.getRevisionChangeNumber();
        String other$revisionChangeNumber = other.getRevisionChangeNumber();
        if (this$revisionChangeNumber == null ? other$revisionChangeNumber != null : !this$revisionChangeNumber.equals(other$revisionChangeNumber)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<KeyValueTag> this$keyValueTags = this.getKeyValueTags();
        List<KeyValueTag> other$keyValueTags = other.getKeyValueTags();
        if (this$keyValueTags == null ? other$keyValueTags != null : !((Object)this$keyValueTags).equals(other$keyValueTags)) {
            return false;
        }
        List<ChildItem> this$children = this.getChildren();
        List<ChildItem> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        VoteData this$voteData = this.getVoteData();
        VoteData other$voteData = other.getVoteData();
        if (this$voteData == null ? other$voteData != null : !((Object)this$voteData).equals(other$voteData)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PublishedFileDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBanTextCheckResult();
        result = result * 59 + (this.isCanBeDeleted() ? 79 : 97);
        result = result * 59 + (this.isCanSubscribe() ? 79 : 97);
        result = result * 59 + this.getConsumerAppId();
        result = result * 59 + this.getCreatorAppId();
        result = result * 59 + this.getFavorited();
        result = result * 59 + this.getFileType();
        result = result * 59 + this.getFlags();
        result = result * 59 + this.getFollowers();
        result = result * 59 + this.getLanguage();
        result = result * 59 + this.getLifetimeFavorited();
        result = result * 59 + this.getLifetimeFollowers();
        result = result * 59 + this.getLifetimeSubscriptions();
        result = result * 59 + (this.isMaybeInappropriateSex() ? 79 : 97);
        result = result * 59 + (this.isMaybeInappropriateViolence() ? 79 : 97);
        result = result * 59 + this.getNumChildren();
        result = result * 59 + this.getNumCommentsPublic();
        result = result * 59 + this.getNumReports();
        result = result * 59 + this.getResult();
        result = result * 59 + this.getRevision();
        result = result * 59 + (this.isShowSubscribeAll() ? 79 : 97);
        result = result * 59 + this.getSubscriptions();
        long $createdTimeSeconds = this.getCreatedTimeSeconds();
        result = result * 59 + (int)($createdTimeSeconds >>> 32 ^ $createdTimeSeconds);
        long $updatedTimeSeconds = this.getUpdatedTimeSeconds();
        result = result * 59 + (int)($updatedTimeSeconds >>> 32 ^ $updatedTimeSeconds);
        result = result * 59 + this.getViews();
        result = result * 59 + this.getVisibility();
        result = result * 59 + (this.isWorkshopAccepted() ? 79 : 97);
        result = result * 59 + (this.isWorkshopFile() ? 79 : 97);
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $banReason = this.getBanReason();
        result = result * 59 + ($banReason == null ? 43 : $banReason.hashCode());
        String $banner = this.getBanner();
        result = result * 59 + ($banner == null ? 43 : $banner.hashCode());
        String $consumerShortCutId = this.getConsumerShortCutId();
        result = result * 59 + ($consumerShortCutId == null ? 43 : $consumerShortCutId.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $fileDescription = this.getFileDescription();
        result = result * 59 + ($fileDescription == null ? 43 : $fileDescription.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        String $fileSize = this.getFileSize();
        result = result * 59 + ($fileSize == null ? 43 : $fileSize.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $hcontentFile = this.getHcontentFile();
        result = result * 59 + ($hcontentFile == null ? 43 : $hcontentFile.hashCode());
        String $hcontentPreview = this.getHcontentPreview();
        result = result * 59 + ($hcontentPreview == null ? 43 : $hcontentPreview.hashCode());
        String $lifetimePlaytimeMinutes = this.getLifetimePlaytimeMinutes();
        result = result * 59 + ($lifetimePlaytimeMinutes == null ? 43 : $lifetimePlaytimeMinutes.hashCode());
        String $lifetimePlaytimeSessionsMinutes = this.getLifetimePlaytimeSessionsMinutes();
        result = result * 59 + ($lifetimePlaytimeSessionsMinutes == null ? 43 : $lifetimePlaytimeSessionsMinutes.hashCode());
        List<Preview> $previews = this.getPreviews();
        result = result * 59 + ($previews == null ? 43 : ((Object)$previews).hashCode());
        String $previewFileSize = this.getPreviewFileSize();
        result = result * 59 + ($previewFileSize == null ? 43 : $previewFileSize.hashCode());
        String $previewUrl = this.getPreviewUrl();
        result = result * 59 + ($previewUrl == null ? 43 : $previewUrl.hashCode());
        String $publishedFileId = this.getPublishedFileId();
        result = result * 59 + ($publishedFileId == null ? 43 : $publishedFileId.hashCode());
        List<Reaction> $reactions = this.getReactions();
        result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
        String $revisionChangeNumber = this.getRevisionChangeNumber();
        result = result * 59 + ($revisionChangeNumber == null ? 43 : $revisionChangeNumber.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<KeyValueTag> $keyValueTags = this.getKeyValueTags();
        result = result * 59 + ($keyValueTags == null ? 43 : ((Object)$keyValueTags).hashCode());
        List<ChildItem> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        VoteData $voteData = this.getVoteData();
        result = result * 59 + ($voteData == null ? 43 : ((Object)$voteData).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublishedFileDetails(appName=" + this.getAppName() + ", banReason=" + this.getBanReason() + ", banTextCheckResult=" + this.getBanTextCheckResult() + ", banner=" + this.getBanner() + ", canBeDeleted=" + this.isCanBeDeleted() + ", canSubscribe=" + this.isCanSubscribe() + ", consumerAppId=" + this.getConsumerAppId() + ", consumerShortCutId=" + this.getConsumerShortCutId() + ", creator=" + this.getCreator() + ", creatorAppId=" + this.getCreatorAppId() + ", favorited=" + this.getFavorited() + ", fileDescription=" + this.getFileDescription() + ", shortDescription=" + this.getShortDescription() + ", fileSize=" + this.getFileSize() + ", fileType=" + this.getFileType() + ", filename=" + this.getFilename() + ", flags=" + this.getFlags() + ", followers=" + this.getFollowers() + ", hcontentFile=" + this.getHcontentFile() + ", hcontentPreview=" + this.getHcontentPreview() + ", language=" + this.getLanguage() + ", lifetimeFavorited=" + this.getLifetimeFavorited() + ", lifetimeFollowers=" + this.getLifetimeFollowers() + ", lifetimePlaytimeMinutes=" + this.getLifetimePlaytimeMinutes() + ", lifetimePlaytimeSessionsMinutes=" + this.getLifetimePlaytimeSessionsMinutes() + ", lifetimeSubscriptions=" + this.getLifetimeSubscriptions() + ", maybeInappropriateSex=" + this.isMaybeInappropriateSex() + ", maybeInappropriateViolence=" + this.isMaybeInappropriateViolence() + ", numChildren=" + this.getNumChildren() + ", numCommentsPublic=" + this.getNumCommentsPublic() + ", numReports=" + this.getNumReports() + ", previews=" + this.getPreviews() + ", previewFileSize=" + this.getPreviewFileSize() + ", previewUrl=" + this.getPreviewUrl() + ", publishedFileId=" + this.getPublishedFileId() + ", result=" + this.getResult() + ", revision=" + this.getRevision() + ", reactions=" + this.getReactions() + ", revisionChangeNumber=" + this.getRevisionChangeNumber() + ", showSubscribeAll=" + this.isShowSubscribeAll() + ", subscriptions=" + this.getSubscriptions() + ", tags=" + this.getTags() + ", keyValueTags=" + this.getKeyValueTags() + ", children=" + this.getChildren() + ", voteData=" + this.getVoteData() + ", createdTimeSeconds=" + this.getCreatedTimeSeconds() + ", updatedTimeSeconds=" + this.getUpdatedTimeSeconds() + ", title=" + this.getTitle() + ", url=" + this.getUrl() + ", views=" + this.getViews() + ", visibility=" + this.getVisibility() + ", workshopAccepted=" + this.isWorkshopAccepted() + ", workshopFile=" + this.isWorkshopFile() + ")";
    }

    public static class VoteData {
        @JsonProperty(value="score")
        private double score;
        @JsonProperty(value="votes_up")
        private int votesUp;
        @JsonProperty(value="votes_down")
        private int votesDown;

        @Generated
        public VoteData() {
        }

        @Generated
        public double getScore() {
            return this.score;
        }

        @Generated
        public int getVotesUp() {
            return this.votesUp;
        }

        @Generated
        public int getVotesDown() {
            return this.votesDown;
        }

        @JsonProperty(value="score")
        @Generated
        public void setScore(double score) {
            this.score = score;
        }

        @JsonProperty(value="votes_up")
        @Generated
        public void setVotesUp(int votesUp) {
            this.votesUp = votesUp;
        }

        @JsonProperty(value="votes_down")
        @Generated
        public void setVotesDown(int votesDown) {
            this.votesDown = votesDown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VoteData)) {
                return false;
            }
            VoteData other = (VoteData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getScore(), other.getScore()) != 0) {
                return false;
            }
            if (this.getVotesUp() != other.getVotesUp()) {
                return false;
            }
            return this.getVotesDown() == other.getVotesDown();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VoteData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $score = Double.doubleToLongBits(this.getScore());
            result = result * 59 + (int)($score >>> 32 ^ $score);
            result = result * 59 + this.getVotesUp();
            result = result * 59 + this.getVotesDown();
            return result;
        }

        @Generated
        public String toString() {
            return "PublishedFileDetails.VoteData(score=" + this.getScore() + ", votesUp=" + this.getVotesUp() + ", votesDown=" + this.getVotesDown() + ")";
        }
    }

    public static class ChildItem {
        @JsonProperty(value="publishedfileid")
        private String publishedFileId;
        @JsonProperty(value="sortorder")
        private int order;
        @JsonProperty(value="file_type")
        private int fileType;

        @Generated
        public ChildItem() {
        }

        @Generated
        public String getPublishedFileId() {
            return this.publishedFileId;
        }

        @Generated
        public int getOrder() {
            return this.order;
        }

        @Generated
        public int getFileType() {
            return this.fileType;
        }

        @JsonProperty(value="publishedfileid")
        @Generated
        public void setPublishedFileId(String publishedFileId) {
            this.publishedFileId = publishedFileId;
        }

        @JsonProperty(value="sortorder")
        @Generated
        public void setOrder(int order) {
            this.order = order;
        }

        @JsonProperty(value="file_type")
        @Generated
        public void setFileType(int fileType) {
            this.fileType = fileType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChildItem)) {
                return false;
            }
            ChildItem other = (ChildItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (this.getFileType() != other.getFileType()) {
                return false;
            }
            String this$publishedFileId = this.getPublishedFileId();
            String other$publishedFileId = other.getPublishedFileId();
            return !(this$publishedFileId == null ? other$publishedFileId != null : !this$publishedFileId.equals(other$publishedFileId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChildItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            result = result * 59 + this.getFileType();
            String $publishedFileId = this.getPublishedFileId();
            result = result * 59 + ($publishedFileId == null ? 43 : $publishedFileId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PublishedFileDetails.ChildItem(publishedFileId=" + this.getPublishedFileId() + ", order=" + this.getOrder() + ", fileType=" + this.getFileType() + ")";
        }
    }

    public static class KeyValueTag {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="value")
        private String value;

        @Generated
        public KeyValueTag() {
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @JsonProperty(value="key")
        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="value")
        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValueTag)) {
                return false;
            }
            KeyValueTag other = (KeyValueTag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeyValueTag;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PublishedFileDetails.KeyValueTag(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Tag {
        @JsonProperty(value="display_name")
        private String displayName;
        @JsonProperty(value="tag")
        private String tag;

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @JsonProperty(value="display_name")
        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="tag")
        @Generated
        public void setTag(String tag) {
            this.tag = tag;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tag;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PublishedFileDetails.Tag(displayName=" + this.getDisplayName() + ", tag=" + this.getTag() + ")";
        }

        @Generated
        public Tag() {
        }

        @Generated
        public Tag(String displayName, String tag) {
            this.displayName = displayName;
            this.tag = tag;
        }
    }

    public static class Preview {
        @JsonProperty(value="previewid")
        private String previewId;
        @JsonProperty(value="sortorder")
        private int sortOrder;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="youtubevideoid")
        private String youtubeVideoId;
        @JsonProperty(value="size")
        private int size;
        @JsonProperty(value="filename")
        private String filename;
        @JsonProperty(value="preview_type")
        private int previewType;
        @JsonProperty(value="external_reference")
        private String externalReference;

        public PreviewType getPreviewTypeAsEnum() {
            return PreviewType.findByCode(this.previewType);
        }

        @Generated
        public Preview() {
        }

        @Generated
        public String getPreviewId() {
            return this.previewId;
        }

        @Generated
        public int getSortOrder() {
            return this.sortOrder;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getYoutubeVideoId() {
            return this.youtubeVideoId;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public int getPreviewType() {
            return this.previewType;
        }

        @Generated
        public String getExternalReference() {
            return this.externalReference;
        }

        @JsonProperty(value="previewid")
        @Generated
        public void setPreviewId(String previewId) {
            this.previewId = previewId;
        }

        @JsonProperty(value="sortorder")
        @Generated
        public void setSortOrder(int sortOrder) {
            this.sortOrder = sortOrder;
        }

        @JsonProperty(value="url")
        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="youtubevideoid")
        @Generated
        public void setYoutubeVideoId(String youtubeVideoId) {
            this.youtubeVideoId = youtubeVideoId;
        }

        @JsonProperty(value="size")
        @Generated
        public void setSize(int size) {
            this.size = size;
        }

        @JsonProperty(value="filename")
        @Generated
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @JsonProperty(value="preview_type")
        @Generated
        public void setPreviewType(int previewType) {
            this.previewType = previewType;
        }

        @JsonProperty(value="external_reference")
        @Generated
        public void setExternalReference(String externalReference) {
            this.externalReference = externalReference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Preview)) {
                return false;
            }
            Preview other = (Preview)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSortOrder() != other.getSortOrder()) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getPreviewType() != other.getPreviewType()) {
                return false;
            }
            String this$previewId = this.getPreviewId();
            String other$previewId = other.getPreviewId();
            if (this$previewId == null ? other$previewId != null : !this$previewId.equals(other$previewId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$youtubeVideoId = this.getYoutubeVideoId();
            String other$youtubeVideoId = other.getYoutubeVideoId();
            if (this$youtubeVideoId == null ? other$youtubeVideoId != null : !this$youtubeVideoId.equals(other$youtubeVideoId)) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            String this$externalReference = this.getExternalReference();
            String other$externalReference = other.getExternalReference();
            return !(this$externalReference == null ? other$externalReference != null : !this$externalReference.equals(other$externalReference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Preview;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSortOrder();
            result = result * 59 + this.getSize();
            result = result * 59 + this.getPreviewType();
            String $previewId = this.getPreviewId();
            result = result * 59 + ($previewId == null ? 43 : $previewId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $youtubeVideoId = this.getYoutubeVideoId();
            result = result * 59 + ($youtubeVideoId == null ? 43 : $youtubeVideoId.hashCode());
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            String $externalReference = this.getExternalReference();
            result = result * 59 + ($externalReference == null ? 43 : $externalReference.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PublishedFileDetails.Preview(previewId=" + this.getPreviewId() + ", sortOrder=" + this.getSortOrder() + ", url=" + this.getUrl() + ", youtubeVideoId=" + this.getYoutubeVideoId() + ", size=" + this.getSize() + ", filename=" + this.getFilename() + ", previewType=" + this.getPreviewType() + ", externalReference=" + this.getExternalReference() + ")";
        }

        public static enum PreviewType {
            IMAGE(0),
            VIDEO(1),
            UNKNOWN(-1);

            private final int code;

            private PreviewType(int code) {
                this.code = code;
            }

            public static PreviewType findByCode(int resultCode) {
                return Arrays.stream(PreviewType.values()).filter(resultEnum -> resultCode == resultEnum.getCode()).findFirst().orElse(UNKNOWN);
            }

            @Generated
            public int getCode() {
                return this.code;
            }
        }
    }

    public static class Reaction {
        @JsonProperty(value="reactionid")
        private int reactionId;
        @JsonProperty(value="count")
        private int count;

        @Generated
        public Reaction() {
        }

        @Generated
        public int getReactionId() {
            return this.reactionId;
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @JsonProperty(value="reactionid")
        @Generated
        public void setReactionId(int reactionId) {
            this.reactionId = reactionId;
        }

        @JsonProperty(value="count")
        @Generated
        public void setCount(int count) {
            this.count = count;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reaction)) {
                return false;
            }
            Reaction other = (Reaction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReactionId() != other.getReactionId()) {
                return false;
            }
            return this.getCount() == other.getCount();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Reaction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReactionId();
            result = result * 59 + this.getCount();
            return result;
        }

        @Generated
        public String toString() {
            return "PublishedFileDetails.Reaction(reactionId=" + this.getReactionId() + ", count=" + this.getCount() + ")";
        }
    }
}

