/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.steamwebapiclient.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.aquerr.steamwebapiclient.request.SteamWebApiRequest;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class UrlEncodedForm {
    private final Map<String, String> parameters;

    public static UrlEncodedForm of(SteamWebApiRequest request) {
        try {
            return new UrlEncodedForm(UrlEncodedForm.retrieveParameters(request));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static UrlEncodedForm of(Map<String, String> parameters) {
        return new UrlEncodedForm(new HashMap<String, String>(parameters));
    }

    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
            stringBuilder.append("=");
            stringBuilder.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public byte[] getAsByteArray() {
        return this.getAsString().getBytes(StandardCharsets.UTF_8);
    }

    private static Map<String, String> retrieveParameters(SteamWebApiRequest request) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Field field : fields = request.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JsonProperty.class)) continue;
            field.setAccessible(true);
            parameters.put(field.getAnnotation(JsonProperty.class).value(), String.valueOf(field.get(request)));
            field.setAccessible(false);
        }
        return parameters;
    }

    @Generated
    private UrlEncodedForm(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlEncodedForm)) {
            return false;
        }
        UrlEncodedForm other = (UrlEncodedForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UrlEncodedForm;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UrlEncodedForm(parameters=" + this.getParameters() + ")";
    }
}

