/*
 * Decompiled with CFR 0.152.
 */
package io.github.archipelagomw;

import io.github.archipelagomw.Client;
import io.github.archipelagomw.WebSocket;
import io.github.archipelagomw.events.ReceiveItemEvent;
import io.github.archipelagomw.network.client.SyncPacket;
import io.github.archipelagomw.parts.DataPackage;
import io.github.archipelagomw.parts.NetworkItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ItemManager {
    private final Client client;
    private WebSocket webSocket;
    private List<NetworkItem> receivedItems = new ArrayList<NetworkItem>();
    private final AtomicInteger index = new AtomicInteger();

    public ItemManager(Client client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveItems(List<NetworkItem> ids, int index) {
        if (index == 0) {
            this.receivedItems = new ArrayList<NetworkItem>();
        }
        if (this.receivedItems.size() == index) {
            ItemManager itemManager = this;
            synchronized (itemManager) {
                this.receivedItems.addAll(ids);
            }
            DataPackage dp = this.client.getDataPackage();
            int myTeam = this.client.getTeam();
            for (int i = this.index.get(); i < this.receivedItems.size(); ++i) {
                NetworkItem item = this.receivedItems.get(i);
                item.itemName = dp.getItem(item.itemID, this.client.getGame());
                item.locationName = dp.getLocation(item.locationID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)item.playerID)).game);
                item.playerName = this.client.getRoomInfo().getPlayer((int)myTeam, (int)item.playerID).alias;
                this.client.getEventManager().callEvent(new ReceiveItemEvent(item, i + 1));
            }
            this.index.set(this.receivedItems.size());
        } else if (this.webSocket != null) {
            this.webSocket.sendPacket(new SyncPacket());
            this.client.getLocationManager().resendAllCheckedLocations();
        }
    }

    public void writeFromSave(List<NetworkItem> receivedItems, int index) {
        this.receivedItems = new ArrayList<NetworkItem>(receivedItems);
        this.index.set(index);
    }

    void setAPWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public int getIndex() {
        return this.index.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkItem> getReceivedItems() {
        ItemManager itemManager = this;
        synchronized (itemManager) {
            return new ArrayList<NetworkItem>(this.receivedItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getReceivedItemIDs() {
        ArrayList<Long> ids = new ArrayList<Long>();
        ItemManager itemManager = this;
        synchronized (itemManager) {
            for (NetworkItem receivedItem : this.receivedItems) {
                ids.add(receivedItem.itemID);
            }
        }
        return ids;
    }
}

