/*
 * Decompiled with CFR 0.152.
 */
package io.github.artsok.extension;

import io.github.artsok.RepeatedIfExceptionsTest;
import io.github.artsok.extension.RepeatedIfException;
import io.github.artsok.extension.RepeatedIfExceptionsDisplayNameFormatter;
import io.github.artsok.extension.RepeatedIfExceptionsInvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatIfExceptionsCondition
implements TestTemplateInvocationContextProvider,
AfterTestExecutionCallback {
    private static final Logger log = LoggerFactory.getLogger(RepeatIfExceptionsCondition.class);
    private boolean exceptionAppear = false;
    private int totalRepeats = 0;
    private RepeatedIfExceptionsDisplayNameFormatter formatter;
    static List<Boolean> historyExceptionAppear;
    static final String MINIMUM_SUCCESS_KEY = "MINIMUM_SUCCESS_KEY";

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        return AnnotationUtils.isAnnotated((Optional)extensionContext.getTestMethod(), RepeatedIfExceptionsTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        Preconditions.notNull(extensionContext.getTestMethod().orElse(null), (String)"Test method must not be null");
        RepeatedIfExceptionsTest annotationParams = (RepeatedIfExceptionsTest)extensionContext.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, RepeatedIfExceptionsTest.class)).orElseThrow(() -> new RepeatedIfException("The extension should not be executed unless the test method is annotated with @RepeatedIfExceptionsTest."));
        this.totalRepeats = annotationParams.repeats();
        int minSuccess = annotationParams.minSuccess();
        historyExceptionAppear = Collections.synchronizedList(new ArrayList());
        Preconditions.condition((this.totalRepeats > 0 ? 1 : 0) != 0, (String)"Total repeats must be higher than 0");
        Preconditions.condition((minSuccess >= 1 ? 1 : 0) != 0, (String)"Total minimum success must be higher or equals than 1");
        extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)MINIMUM_SUCCESS_KEY, (Object)minSuccess);
        log.debug("Total repeats '{}' and minSuccess", (Object)this.totalRepeats, (Object)minSuccess);
        String displayName = extensionContext.getDisplayName();
        this.formatter = this.displayNameFormatter(annotationParams, displayName);
        Spliterator<TestTemplateInvocationContext> spliterator = Spliterators.spliteratorUnknownSize(new TestTemplateIterator(), 256);
        return StreamSupport.stream(spliterator, false);
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        Object[] exceptionPool = ((RepeatedIfExceptionsTest)extensionContext.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, RepeatedIfExceptionsTest.class)).orElseThrow(() -> new IllegalStateException("The extension should not be executed "))).exceptions();
        log.debug("Exceptions Pool in RepeatedIfExceptionsTest '{}'", exceptionPool);
        Class<?> exception = ((Throwable)extensionContext.getExecutionException().orElse(new RepeatedIfException("There is no exception in context"))).getClass();
        log.debug("Exception in test '{}'", exception);
        boolean result = Stream.of(exceptionPool).anyMatch(ex -> ex.isAssignableFrom(exception) && !RepeatedIfException.class.isAssignableFrom(exception));
        historyExceptionAppear.add(result);
        this.exceptionAppear = this.exceptionAppear || result;
    }

    private RepeatedIfExceptionsDisplayNameFormatter displayNameFormatter(RepeatedIfExceptionsTest test, String displayName) {
        String pattern = test.name().trim();
        if (StringUtils.isBlank((String)pattern)) {
            pattern = (String)AnnotationUtils.getDefaultValue((Annotation)test, (String)"name", String.class).orElseThrow(() -> new RepeatedIfException("Exception occurred with name parameter of RepeatedIfExceptionsTest annotation"));
        }
        return new RepeatedIfExceptionsDisplayNameFormatter(pattern, displayName);
    }

    class TestTemplateIterator
    implements Iterator<TestTemplateInvocationContext> {
        int currentIndex = 0;

        TestTemplateIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == 0) {
                return true;
            }
            return RepeatIfExceptionsCondition.this.exceptionAppear && this.currentIndex < RepeatIfExceptionsCondition.this.totalRepeats;
        }

        @Override
        public TestTemplateInvocationContext next() {
            if (this.hasNext()) {
                ++this.currentIndex;
                return new RepeatedIfExceptionsInvocationContext(this.currentIndex, RepeatIfExceptionsCondition.this.totalRepeats, RepeatIfExceptionsCondition.this.formatter);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

