/*
 * Decompiled with CFR 0.152.
 */
package io.github.artsok.extension;

import io.github.artsok.RepeatedIfExceptionsTest;
import io.github.artsok.extension.RepeatedIfException;
import io.github.artsok.extension.RepeatedIfExceptionsDisplayNameFormatter;
import io.github.artsok.extension.RepeatedIfExceptionsInvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.TestAbortedException;

public class RepeatIfExceptionsCondition
implements TestTemplateInvocationContextProvider,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
TestExecutionExceptionHandler {
    private int totalRepeats = 0;
    private int minSuccess = 1;
    private List<Class<? extends Throwable>> repeatableExceptions;
    private boolean repeatableExceptionAppeared = false;
    private RepeatedIfExceptionsDisplayNameFormatter formatter;
    private List<Boolean> historyExceptionAppear;

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        return AnnotationUtils.isAnnotated((Optional)extensionContext.getTestMethod(), RepeatedIfExceptionsTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        Preconditions.notNull(extensionContext.getTestMethod().orElse(null), (String)"Test method must not be null");
        RepeatedIfExceptionsTest annotationParams = (RepeatedIfExceptionsTest)extensionContext.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, RepeatedIfExceptionsTest.class)).orElseThrow(() -> new RepeatedIfException("The extension should not be executed unless the test method is annotated with @RepeatedIfExceptionsTest."));
        this.totalRepeats = annotationParams.repeats();
        this.minSuccess = annotationParams.minSuccess();
        this.historyExceptionAppear = Collections.synchronizedList(new ArrayList());
        Preconditions.condition((this.totalRepeats > 0 ? 1 : 0) != 0, (String)"Total repeats must be higher than 0");
        Preconditions.condition((this.minSuccess >= 1 ? 1 : 0) != 0, (String)"Total minimum success must be higher or equals than 1");
        String displayName = extensionContext.getDisplayName();
        this.formatter = this.displayNameFormatter(annotationParams, displayName);
        Spliterator<TestTemplateInvocationContext> spliterator = Spliterators.spliteratorUnknownSize(new TestTemplateIterator(), 256);
        return StreamSupport.stream(spliterator, false);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.repeatableExceptions = Stream.of(((RepeatedIfExceptionsTest)context.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, RepeatedIfExceptionsTest.class)).orElseThrow(() -> new IllegalStateException("The extension should not be executed "))).exceptions()).collect(Collectors.toList());
        this.repeatableExceptions.add(TestAbortedException.class);
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        boolean exceptionAppeared = this.exceptionAppeared(extensionContext);
        this.historyExceptionAppear.add(exceptionAppeared);
    }

    private boolean exceptionAppeared(ExtensionContext extensionContext) {
        Class<?> exception = ((Throwable)extensionContext.getExecutionException().orElse(new RepeatedIfException("There is no exception in context"))).getClass();
        return this.repeatableExceptions.stream().anyMatch(ex -> ex.isAssignableFrom(exception) && !RepeatedIfException.class.isAssignableFrom(exception));
    }

    private RepeatedIfExceptionsDisplayNameFormatter displayNameFormatter(RepeatedIfExceptionsTest test, String displayName) {
        String pattern = test.name().trim();
        if (StringUtils.isBlank((String)pattern)) {
            pattern = Optional.of(test.name()).orElseThrow(() -> new RepeatedIfException("Exception occurred with name parameter of RepeatedIfExceptionsTest annotation"));
        }
        return new RepeatedIfExceptionsDisplayNameFormatter(pattern, displayName);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (this.appearedExceptionDoesNotAllowRepetitions(throwable)) {
            throw throwable;
        }
        this.repeatableExceptionAppeared = true;
        long currentSuccessCount = this.historyExceptionAppear.stream().filter(exceptionAppeared -> exceptionAppeared == false).count();
        if (currentSuccessCount < (long)this.minSuccess) {
            if (this.isMinSuccessTargetStillReachable(this.minSuccess)) {
                throw new TestAbortedException("Do not fail completely but repeat the test", throwable);
            }
            throw throwable;
        }
    }

    private boolean appearedExceptionDoesNotAllowRepetitions(Throwable appearedException) {
        return this.repeatableExceptions.stream().noneMatch(ex -> ex.isAssignableFrom(appearedException.getClass()));
    }

    private boolean isMinSuccessTargetStillReachable(long minSuccessCount) {
        return this.historyExceptionAppear.stream().filter(bool -> bool).count() < (long)this.totalRepeats - minSuccessCount;
    }

    class TestTemplateIterator
    implements Iterator<TestTemplateInvocationContext> {
        int currentIndex = 0;

        TestTemplateIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == 0) {
                return true;
            }
            return RepeatIfExceptionsCondition.this.historyExceptionAppear.stream().anyMatch(ex -> ex) && this.currentIndex < RepeatIfExceptionsCondition.this.totalRepeats;
        }

        @Override
        public TestTemplateInvocationContext next() {
            int successfulTestRepetitionsCount = Math.toIntExact(RepeatIfExceptionsCondition.this.historyExceptionAppear.stream().filter(b -> b == false).count());
            if (this.hasNext()) {
                ++this.currentIndex;
                return new RepeatedIfExceptionsInvocationContext(this.currentIndex, RepeatIfExceptionsCondition.this.totalRepeats, successfulTestRepetitionsCount, RepeatIfExceptionsCondition.this.minSuccess, RepeatIfExceptionsCondition.this.repeatableExceptionAppeared, RepeatIfExceptionsCondition.this.formatter);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

