/*
 * Decompiled with CFR 0.152.
 */
package io.github.artsok.params;

import io.github.artsok.ParameterizedRepeatedIfExceptionsTest;
import io.github.artsok.extension.RepeatedIfException;
import io.github.artsok.params.ParameterizedRepeatedIfExceptionsTestNameFormatter;
import io.github.artsok.params.ParameterizedRepeatedMethodContext;
import io.github.artsok.params.ParameterizedTestInvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.opentest4j.TestAbortedException;

public class ParameterizedRepeatedTestExtension
implements TestTemplateInvocationContextProvider,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
TestExecutionExceptionHandler {
    private int totalRepeats = 0;
    private int minSuccess = 1;
    private List<Class<? extends Throwable>> repeatableExceptions;
    private boolean repeatableExceptionAppeared = false;
    private final List<Boolean> historyExceptionAppear = Collections.synchronizedList(new ArrayList());
    private static final String METHOD_CONTEXT_KEY = "context";

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        if (!extensionContext.getTestMethod().isPresent()) {
            return false;
        }
        Method testMethod = (Method)extensionContext.getTestMethod().get();
        if (!AnnotationUtils.isAnnotated((AnnotatedElement)testMethod, ParameterizedRepeatedIfExceptionsTest.class)) {
            return false;
        }
        ParameterizedRepeatedMethodContext methodContext = new ParameterizedRepeatedMethodContext(testMethod);
        Preconditions.condition((boolean)methodContext.hasPotentiallyValidSignature(), () -> String.format("@ParameterizedRepeatedIfExceptionsTest method [%s] declares formal parameters in an invalid order: argument aggregators must be declared after any indexed arguments and before any arguments resolved by another ParameterResolver.", testMethod.toGenericString()));
        this.getStore(extensionContext).put((Object)METHOD_CONTEXT_KEY, (Object)methodContext);
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        Method templateMethod = extensionContext.getRequiredTestMethod();
        String displayName = extensionContext.getDisplayName();
        ParameterizedRepeatedMethodContext methodContext = (ParameterizedRepeatedMethodContext)this.getStore(extensionContext).get((Object)METHOD_CONTEXT_KEY, ParameterizedRepeatedMethodContext.class);
        ParameterizedRepeatedIfExceptionsTestNameFormatter formatter = this.createNameFormatter(templateMethod, displayName);
        ParameterizedRepeatedIfExceptionsTest annotationParams = (ParameterizedRepeatedIfExceptionsTest)extensionContext.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, ParameterizedRepeatedIfExceptionsTest.class)).orElseThrow(() -> new RepeatedIfException("The extension should not be executed unless the test method is annotated with @ParameterizedRepeatedIfExceptionsTest."));
        this.totalRepeats = annotationParams.repeats();
        this.minSuccess = annotationParams.minSuccess();
        Preconditions.condition((this.totalRepeats > 0 ? 1 : 0) != 0, (String)"Total repeats must be higher than 0");
        Preconditions.condition((this.minSuccess >= 1 ? 1 : 0) != 0, (String)"Total minimum success must be higher or equals than 1");
        List<Object[]> collect = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)templateMethod, ArgumentsSource.class).stream().map(ArgumentsSource::value).map(this::instantiateArgumentsProvider).map(provider -> (ArgumentsProvider)AnnotationConsumerInitializer.initialize((AnnotatedElement)templateMethod, (Object)provider)).flatMap(provider -> ParameterizedRepeatedTestExtension.arguments(provider, extensionContext)).map(Arguments::get).map(arguments -> this.consumedArguments((Object[])arguments, methodContext)).collect(Collectors.toList());
        Spliterator<TestTemplateInvocationContext> spliterator = Spliterators.spliteratorUnknownSize(new TestTemplateIteratorParams(collect, formatter, methodContext), 256);
        return StreamSupport.stream(spliterator, false);
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.repeatableExceptions = Stream.of(((ParameterizedRepeatedIfExceptionsTest)context.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, ParameterizedRepeatedIfExceptionsTest.class)).orElseThrow(() -> new IllegalStateException("The extension should not be executed "))).exceptions()).collect(Collectors.toList());
        this.repeatableExceptions.add(TestAbortedException.class);
    }

    public void afterTestExecution(ExtensionContext context) {
        boolean exceptionAppeared = this.exceptionAppeared(context);
        this.historyExceptionAppear.add(exceptionAppeared);
    }

    private boolean exceptionAppeared(ExtensionContext extensionContext) {
        if (extensionContext.getExecutionException().isPresent()) {
            Class<?> exception = ((Throwable)extensionContext.getExecutionException().get()).getClass();
            return this.repeatableExceptions.stream().anyMatch(ex -> ex.isAssignableFrom(exception));
        }
        return false;
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.repeatableExceptionAppeared = true;
        throw throwable;
    }

    private ParameterizedRepeatedIfExceptionsTestNameFormatter createNameFormatter(Method templateMethod, String displayName) {
        ParameterizedRepeatedIfExceptionsTest parameterizedTest = (ParameterizedRepeatedIfExceptionsTest)AnnotationUtils.findAnnotation((AnnotatedElement)templateMethod, ParameterizedRepeatedIfExceptionsTest.class).get();
        String pattern = Preconditions.notBlank((String)parameterizedTest.name().trim(), () -> String.format("Configuration error: @ParameterizedRepeatedIfExceptionsTest on method [%s] must be declared with a non-empty name.", templateMethod));
        String repeatedPattern = Preconditions.notBlank((String)parameterizedTest.repeatedName(), () -> String.format("Configuration error: @ParameterizedRepeatedIfExceptionsTest on method [%s] must be declared with a non-empty repeated name.", templateMethod));
        return new ParameterizedRepeatedIfExceptionsTestNameFormatter(pattern, displayName, repeatedPattern);
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ExtensionContext context) {
        try {
            return provider.provideArguments(context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)e);
        }
    }

    private Object[] consumedArguments(Object[] arguments, ParameterizedRepeatedMethodContext methodContext) {
        int parameterCount = methodContext.getParameterCount();
        return methodContext.hasAggregator() ? arguments : (arguments.length > parameterCount ? Arrays.copyOf(arguments, parameterCount) : arguments);
    }

    private ArgumentsProvider instantiateArgumentsProvider(Class<? extends ArgumentsProvider> clazz) {
        try {
            return (ArgumentsProvider)ReflectionUtils.newInstance(clazz, (Object[])new Object[0]);
        }
        catch (Exception ex) {
            if (ex instanceof NoSuchMethodException) {
                String message = String.format("Failed to find a no-argument constructor for ArgumentsProvider [%s]. Please ensure that a no-argument constructor exists and that the class is either a top-level class or a static nested class", clazz.getName());
                throw new JUnitException(message, (Throwable)ex);
            }
            throw ex;
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedRepeatedTestExtension.class, context.getRequiredTestMethod()}));
    }

    class TestTemplateIteratorParams
    implements Iterator<TestTemplateInvocationContext> {
        private final List<Object[]> params;
        private final ParameterizedRepeatedIfExceptionsTestNameFormatter formatter;
        private final ParameterizedRepeatedMethodContext methodContext;
        private final AtomicLong invocationCount;
        private final AtomicLong paramsCount;
        private int currentIndex = 0;

        TestTemplateIteratorParams(List<Object[]> arguments, ParameterizedRepeatedIfExceptionsTestNameFormatter formatter, ParameterizedRepeatedMethodContext methodContext) {
            this.params = arguments;
            this.formatter = formatter;
            this.methodContext = methodContext;
            this.invocationCount = new AtomicLong(this.params.size() - 1);
            this.paramsCount = new AtomicLong(0L);
        }

        @Override
        public boolean hasNext() {
            if (ParameterizedRepeatedTestExtension.this.historyExceptionAppear.stream().anyMatch(ex -> ex) && this.currentIndex < ParameterizedRepeatedTestExtension.this.totalRepeats) {
                return ParameterizedRepeatedTestExtension.this.historyExceptionAppear.stream().anyMatch(ex -> ex) && this.currentIndex < ParameterizedRepeatedTestExtension.this.totalRepeats;
            }
            return this.invocationCount.get() >= this.paramsCount.get();
        }

        @Override
        public TestTemplateInvocationContext next() {
            if (this.hasNext()) {
                int currentParam = this.paramsCount.intValue();
                int errorTestRepetitionsCountForOneParameter = Math.toIntExact(ParameterizedRepeatedTestExtension.this.historyExceptionAppear.stream().filter(b -> b).count());
                int successfulTestRepetitionsCountForOneParameter = Math.toIntExact(ParameterizedRepeatedTestExtension.this.historyExceptionAppear.stream().skip(ParameterizedRepeatedTestExtension.this.historyExceptionAppear.size() - ParameterizedRepeatedTestExtension.this.minSuccess <= 0 ? 0L : (long)(ParameterizedRepeatedTestExtension.this.historyExceptionAppear.size() - ParameterizedRepeatedTestExtension.this.minSuccess)).filter(b -> b == false).count());
                if (errorTestRepetitionsCountForOneParameter >= 1 && this.currentIndex < ParameterizedRepeatedTestExtension.this.totalRepeats && successfulTestRepetitionsCountForOneParameter != ParameterizedRepeatedTestExtension.this.minSuccess) {
                    ++this.currentIndex;
                    ParameterizedRepeatedTestExtension.this.repeatableExceptionAppeared = false;
                    return new ParameterizedTestInvocationContext(this.currentIndex, ParameterizedRepeatedTestExtension.this.totalRepeats, this.formatter, this.methodContext, this.params.get(currentParam - 1));
                }
                if (this.currentIndex == ParameterizedRepeatedTestExtension.this.totalRepeats || !ParameterizedRepeatedTestExtension.this.repeatableExceptionAppeared) {
                    this.paramsCount.incrementAndGet();
                    ParameterizedRepeatedTestExtension.this.repeatableExceptionAppeared = false;
                    ParameterizedRepeatedTestExtension.this.historyExceptionAppear.clear();
                }
                this.currentIndex = 0;
                return new ParameterizedTestInvocationContext(0, 0, this.formatter, this.methodContext, this.params.get(currentParam));
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

