/*
 * Decompiled with CFR 0.152.
 */
package io.github.artsok.params;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedRepeatedIfExceptionsTestNameFormatter {
    private final String pattern;
    private final String displayName;
    private final String repeatedNamePattern;

    ParameterizedRepeatedIfExceptionsTestNameFormatter(String pattern, String displayName, String repeatedNamePattern) {
        this.pattern = pattern;
        this.displayName = displayName;
        this.repeatedNamePattern = repeatedNamePattern;
    }

    String format(int invocationIndex, int currentRepetition, int totalRepetitions, Object ... arguments) {
        try {
            return this.formatSafely(invocationIndex, currentRepetition, totalRepetitions, arguments);
        }
        catch (Exception ex) {
            String message = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message, (Throwable)ex);
        }
    }

    private String formatSafely(int invocationIndex, int currentRepetition, int totalRepetitions, Object[] arguments) {
        String pattern = this.prepareMessageFormatPattern(invocationIndex, currentRepetition, totalRepetitions, arguments);
        MessageFormat format = new MessageFormat(pattern);
        Object[] humanReadableArguments = this.makeReadable(format, arguments);
        return format.format(humanReadableArguments);
    }

    private String prepareMessageFormatPattern(int invocationIndex, int currentRepetition, int totalRepetitions, Object[] arguments) {
        String result = currentRepetition != 0 && totalRepetitions != 0 ? this.pattern.replace("{displayName}", this.displayName).replace("{index}", String.valueOf(invocationIndex)).concat(this.repeatedNamePattern).replace("{currentRepetition}", String.valueOf(currentRepetition)).replace("{totalRepetitions}", String.valueOf(totalRepetitions)) : this.pattern.replace("{displayName}", this.displayName).replace("{index}", String.valueOf(invocationIndex)).replace(this.repeatedNamePattern, "");
        if (result.contains("{arguments}")) {
            String replacement = IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
            result = result.replace("{arguments}", replacement);
        }
        return result;
    }

    private Object[] makeReadable(MessageFormat format, Object[] arguments) {
        Format[] formats = format.getFormatsByArgumentIndex();
        Object[] result = Arrays.copyOf(arguments, Math.min(arguments.length, formats.length), Object[].class);
        for (int i = 0; i < result.length; ++i) {
            if (formats[i] != null) continue;
            result[i] = StringUtils.nullSafeToString((Object)arguments[i]);
        }
        return result;
    }
}

