/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.source;

import io.github.ascopes.protobufmavenplugin.source.ImmutableProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoArchiveExtractor;
import io.github.ascopes.protobufmavenplugin.source.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoFilePredicates;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtoSourceResolver
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ProtoArchiveExtractor.class);
    private final ProtoArchiveExtractor protoArchiveExtractor;
    private final ExecutorService executorService;

    @Inject
    public ProtoSourceResolver(ProtoArchiveExtractor protoArchiveExtractor) {
        int concurrency = Runtime.getRuntime().availableProcessors() * 8;
        this.protoArchiveExtractor = protoArchiveExtractor;
        this.executorService = Executors.newWorkStealingPool(concurrency);
    }

    @Override
    @PreDestroy
    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            log.warn("Shutdown was interrupted and will be aborted", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    public Optional<ProtoFileListing> createProtoFileListing(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            log.debug("Skipping lookup in path {} as it does not exist", (Object)path);
            return Optional.empty();
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return this.protoArchiveExtractor.extractProtoFiles(path);
        }
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            Optional<ProtoFileListing> optional = stream.filter(ProtoFilePredicates::isProtoFile).peek(protoFile -> log.debug("Found proto file in root {}: {}", (Object)path, protoFile)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Optional::of)).filter(Predicate.not(Set::isEmpty)).map(protoFiles -> ImmutableProtoFileListing.builder().addAllProtoFiles((Iterable<? extends Path>)protoFiles).protoFilesRoot(path).originalRoot(path).build());
            return optional;
        }
    }

    public Collection<ProtoFileListing> createProtoFileListings(Collection<Path> originalPaths) throws IOException {
        ArrayList results = new ArrayList();
        ArrayList exceptions = new ArrayList();
        originalPaths.stream().map(this::submitProtoFileListingTask).collect(Collectors.toList()).stream().forEach(task -> {
            try {
                results.add((Optional)task.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                exceptions.add(ex);
            }
        });
        if (!exceptions.isEmpty()) {
            Iterator<Exception> causeIterator = exceptions.iterator();
            IOException ex = new IOException("Failed to discover protobuf sources in some locations");
            ex.initCause((Throwable)causeIterator.next());
            causeIterator.forEachRemaining(ex::addSuppressed);
            throw ex;
        }
        return results.stream().flatMap(Optional::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private FutureTask<Optional<ProtoFileListing>> submitProtoFileListingTask(Path path) {
        log.debug("Searching for proto files in '{}' asynchronously...", (Object)path);
        FutureTask<Optional<ProtoFileListing>> task = new FutureTask<Optional<ProtoFileListing>>(() -> this.createProtoFileListing(path));
        this.executorService.submit(task);
        return task;
    }

    private <T> Consumer<FutureTask<T>> partitionResultsForTasks(Collection<T> results, Collection<Exception> exceptions) {
        return task -> {};
    }
}

