/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.generate.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.platform.Digests;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import io.github.ascopes.protobufmavenplugin.platform.HostSystem;
import io.github.ascopes.protobufmavenplugin.platform.Shlex;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;

@Named
public final class JvmPluginResolver {
    private static final Set<String> SCOPES = Set.of("compile", "runtime", "system");
    private final HostSystem hostSystem;
    private final MavenDependencyPathResolver dependencyPathResolver;
    private final TemporarySpace temporarySpace;

    @Inject
    public JvmPluginResolver(HostSystem hostSystem, MavenDependencyPathResolver dependencyPathResolver, TemporarySpace temporarySpace) {
        this.hostSystem = hostSystem;
        this.dependencyPathResolver = dependencyPathResolver;
        this.temporarySpace = temporarySpace;
    }

    public Collection<ResolvedPlugin> resolveMavenPlugins(MavenSession session, Collection<? extends DependableCoordinate> plugins) throws IOException, ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (DependableCoordinate dependableCoordinate : plugins) {
            resolvedPlugins.add(this.resolve(session, dependableCoordinate));
        }
        return resolvedPlugins;
    }

    private ResolvedPlugin resolve(MavenSession session, DependableCoordinate plugin) throws IOException, ResolutionException {
        String pluginId = this.pluginIdDigest(plugin);
        List<String> argLine = this.resolveAndBuildArgLine(session, plugin);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsBatchScript(pluginId, argLine) : this.writeShellScript(pluginId, argLine);
        return ImmutableResolvedPlugin.builder().id(pluginId).path(scriptPath).build();
    }

    private List<String> resolveAndBuildArgLine(MavenSession session, DependableCoordinate pluginDependencyCoordinate) throws ResolutionException {
        Iterator<Path> dependencyIterator = this.dependencyPathResolver.resolveDependencyTreePaths(session, SCOPES, pluginDependencyCoordinate).iterator();
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        args.add("-jar");
        args.add(dependencyIterator.next().toString());
        if (dependencyIterator.hasNext()) {
            StringBuilder sb = new StringBuilder().append(dependencyIterator.next());
            while (dependencyIterator.hasNext()) {
                sb.append(":").append(dependencyIterator.next());
            }
            args.add("-classpath");
            args.add(sb.toString());
        }
        return args;
    }

    private String pluginIdDigest(DependableCoordinate dependableCoordinate) {
        String digestableString = String.join((CharSequence)":", Objects.requireNonNullElse(dependableCoordinate.getGroupId(), ""), Objects.requireNonNullElse(dependableCoordinate.getArtifactId(), ""), Objects.requireNonNullElse(dependableCoordinate.getVersion(), ""), Objects.requireNonNullElse(dependableCoordinate.getType(), ""), Objects.requireNonNullElse(dependableCoordinate.getClassifier(), ""));
        return Digests.sha1(digestableString);
    }

    private Path resolvePluginScriptPath() {
        return this.temporarySpace.createTemporarySpace("plugins", "jvm");
    }

    private Path writeWindowsBatchScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".bat");
        String script = "@echo off\r\n" + Shlex.quoteBatchArgs(argLine) + "\r\n";
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.ISO_8859_1, new OpenOption[0]);
        return fullScriptPath;
    }

    private Path writeShellScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".sh");
        String script = "#!/usr/bin/env sh\nset -eu\n" + Shlex.quoteShellArgs(argLine) + "\n";
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.UTF_8, new OpenOption[0]);
        FileUtils.makeExecutable(fullScriptPath);
        return fullScriptPath;
    }
}

