/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.execute;

import io.github.ascopes.protobufmavenplugin.generate.Language;
import io.github.ascopes.protobufmavenplugin.plugin.ResolvedPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ArgLineBuilder {
    private final List<String> args = new ArrayList<String>();
    private int outputTargetCount;

    public ArgLineBuilder(Path protocPath) {
        this.args.add(protocPath.toString());
        this.outputTargetCount = 0;
    }

    public List<String> compile(Collection<Path> sourcesToCompile) {
        if (this.outputTargetCount == 0) {
            throw new IllegalStateException("No output targets were provided");
        }
        ArrayList<String> finalArgs = new ArrayList<String>(this.args);
        for (Path path : sourcesToCompile) {
            finalArgs.add(path.toString());
        }
        return Collections.unmodifiableList(finalArgs);
    }

    public ArgLineBuilder fatalWarnings(boolean fatalWarnings) {
        if (fatalWarnings) {
            this.args.add("--fatal_warnings");
        }
        return this;
    }

    public ArgLineBuilder generateCodeFor(Language language, Path outputPath, boolean lite) {
        ++this.outputTargetCount;
        String flag = lite ? "--" + language.getFlagName() + "_out=lite:" : "--" + language.getFlagName() + "_out=";
        this.args.add(flag + outputPath);
        return this;
    }

    public ArgLineBuilder importPaths(Collection<Path> includePaths) {
        for (Path includePath : includePaths) {
            this.args.add("--proto_path=" + includePath);
        }
        return this;
    }

    public ArgLineBuilder plugins(Collection<ResolvedPlugin> plugins, Path outputPath) {
        for (ResolvedPlugin plugin : plugins) {
            ++this.outputTargetCount;
            this.args.add("--plugin=protoc-gen-" + plugin.getId() + "=" + plugin.getPath());
            this.args.add("--" + plugin.getId() + "_out=" + outputPath);
        }
        return this;
    }

    public List<String> version() {
        return List.of(this.args.get(0), "--version");
    }
}

