/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.util.Iterator;
import java.util.function.BiConsumer;

public final class Shlex {
    private Shlex() {
    }

    public static String quoteShellArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex::quoteShellArg);
    }

    public static String quoteBatchArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex::quoteBatchArg);
    }

    private static String quote(Iterable<String> args, BiConsumer<StringBuilder, String> quoter) {
        Iterator<String> iter = args.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        quoter.accept(sb, iter.next());
        while (iter.hasNext()) {
            sb.append(' ');
            quoter.accept(sb, iter.next());
        }
        return sb.toString();
    }

    private static void quoteShellArg(StringBuilder sb, String arg) {
        if (Shlex.isSafe(arg)) {
            sb.append(arg);
            return;
        }
        sb.append('\'');
        block6: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("'\"'\"'");
                    continue block6;
                }
                case '\n': {
                    sb.append("'$'\\n''");
                    continue block6;
                }
                case '\r': {
                    sb.append("'$'\\r''");
                    continue block6;
                }
                case '\t': {
                    sb.append("'$'\\t''");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\'');
    }

    private static void quoteBatchArg(StringBuilder sb, String arg) {
        if (Shlex.isSafe(arg)) {
            sb.append(arg);
            return;
        }
        block4: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '%': {
                    sb.append("%%");
                    continue block4;
                }
                case '\t': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '|': {
                    sb.append('^').append(c);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static boolean isSafe(String arg) {
        for (int i = 0; i < arg.length(); ++i) {
            boolean safe;
            char c = arg.charAt(i);
            boolean bl = safe = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '/' || c == '_' || c == '.' || c == '=';
            if (safe) continue;
            return false;
        }
        return true;
    }
}

