/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;

@Named
public final class MavenProjectDependencyPathResolver {
    private final MavenSession mavenSession;

    @Inject
    public MavenProjectDependencyPathResolver(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public Collection<Path> resolveProjectDependencies(DependencyResolutionDepth dependencyResolutionDepth) {
        return this.mavenSession.getCurrentProject().getArtifacts().stream().filter(dependencyResolutionDepth == DependencyResolutionDepth.DIRECT ? this.artifactIsDirectDependency() : this.always()).map(Artifact::getFile).map(File::toPath).distinct().collect(Collectors.toList());
    }

    private Predicate<Artifact> always() {
        return anything -> true;
    }

    private Predicate<Artifact> artifactIsDirectDependency() {
        List dependencies = this.mavenSession.getCurrentProject().getDependencies();
        return artifact -> dependencies.stream().anyMatch(dependency -> Objects.equals(dependency.getGroupId(), artifact.getGroupId()) && Objects.equals(dependency.getArtifactId(), artifact.getArtifactId()) && Objects.equals(dependency.getVersion(), artifact.getVersion()) && Objects.equals(dependency.getClassifier(), artifact.getClassifier()) && Objects.equals(dependency.getType(), artifact.getType()) && Objects.equals(dependency.getScope(), artifact.getScope()));
    }
}

