/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generate;

import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.MavenProjectDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.execute.ArgLineBuilder;
import io.github.ascopes.protobufmavenplugin.execute.CommandLineExecutor;
import io.github.ascopes.protobufmavenplugin.generate.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.generate.Language;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugin.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugin.JvmPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugin.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocResolver;
import io.github.ascopes.protobufmavenplugin.source.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoSourceResolver;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class SourceCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeGenerator.class);
    private final MavenSession mavenSession;
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final MavenProjectDependencyPathResolver mavenProjectDependencyPathResolver;
    private final ProtocResolver protocResolver;
    private final BinaryPluginResolver binaryPluginResolver;
    private final JvmPluginResolver jvmPluginResolver;
    private final ProtoSourceResolver protoListingResolver;
    private final CommandLineExecutor commandLineExecutor;

    @Inject
    public SourceCodeGenerator(MavenSession mavenSession, MavenDependencyPathResolver mavenDependencyPathResolver, MavenProjectDependencyPathResolver mavenProjectDependencyPathResolver, ProtocResolver protocResolver, BinaryPluginResolver binaryPluginResolver, JvmPluginResolver jvmPluginResolver, ProtoSourceResolver protoListingResolver, CommandLineExecutor commandLineExecutor) {
        this.mavenSession = mavenSession;
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.mavenProjectDependencyPathResolver = mavenProjectDependencyPathResolver;
        this.protocResolver = protocResolver;
        this.binaryPluginResolver = binaryPluginResolver;
        this.jvmPluginResolver = jvmPluginResolver;
        this.protoListingResolver = protoListingResolver;
        this.commandLineExecutor = commandLineExecutor;
    }

    public boolean generate(GenerationRequest request) throws ResolutionException, IOException {
        Path protocPath = this.discoverProtocPath(request);
        Collection<ResolvedProtocPlugin> plugins = this.discoverPlugins(request);
        Collection<ProtoFileListing> importPaths = this.discoverImportPaths(request);
        Collection<ProtoFileListing> sourcePaths = this.discoverCompilableSources(request);
        if (sourcePaths.isEmpty()) {
            if (request.isFailOnMissingSources()) {
                log.error("No protobuf sources found. If this is unexpected, check your configuration and try again.");
                return false;
            }
            log.warn("No protobuf sources found; nothing to do!");
            return true;
        }
        this.createOutputDirectories(request);
        ArgLineBuilder argLineBuilder = new ArgLineBuilder(protocPath).fatalWarnings(request.isFatalWarnings()).importPaths(importPaths.stream().map(ProtoFileListing::getProtoFilesRoot).collect(Collectors.toCollection(LinkedHashSet::new))).importPaths(request.getSourceRoots()).plugins(plugins, request.getOutputDirectory());
        request.getEnabledLanguages().forEach(language -> argLineBuilder.generateCodeFor((Language)((Object)language), request.getOutputDirectory(), request.isLiteEnabled()));
        LinkedHashSet sourceFiles = sourcePaths.stream().map(ProtoFileListing::getProtoFiles).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!this.logProtocVersion(protocPath)) {
            log.error("Unable to execute protoc. Ensure the binary is compatible for this platform!");
            return false;
        }
        if (!this.commandLineExecutor.execute(argLineBuilder.compile(sourceFiles))) {
            return false;
        }
        this.registerSourceRoots(request);
        return true;
    }

    private Path discoverProtocPath(GenerationRequest request) throws ResolutionException {
        return this.protocResolver.resolve(request.getProtocVersion());
    }

    private boolean logProtocVersion(Path protocPath) throws IOException {
        List<String> args = new ArgLineBuilder(protocPath).version();
        return this.commandLineExecutor.execute(args);
    }

    private Collection<ResolvedProtocPlugin> discoverPlugins(GenerationRequest request) throws IOException, ResolutionException {
        return SourceCodeGenerator.concat(this.binaryPluginResolver.resolveMavenPlugins(request.getBinaryMavenPlugins()), this.binaryPluginResolver.resolvePathPlugins(request.getBinaryPathPlugins()), this.binaryPluginResolver.resolveUrlPlugins(request.getBinaryUrlPlugins()), this.jvmPluginResolver.resolveMavenPlugins(request.getJvmMavenPlugins()));
    }

    private Collection<ProtoFileListing> discoverImportPaths(GenerationRequest request) throws IOException, ResolutionException {
        ArrayList<ProtoFileListing> importPaths = new ArrayList<ProtoFileListing>();
        if (!request.getImportDependencies().isEmpty()) {
            log.debug("Finding importable protobuf sources from explicitly provided import dependencies ({})", request.getImportDependencies());
            Collection<Path> importDependencies = this.mavenDependencyPathResolver.resolveAll(request.getImportDependencies(), request.getDependencyResolutionDepth());
            importPaths.addAll(this.protoListingResolver.createProtoFileListings(importDependencies));
        }
        if (!request.getImportPaths().isEmpty()) {
            log.debug("Finding importable protobuf sources from explicitly provided import paths ({})", request.getImportPaths());
            importPaths.addAll(this.protoListingResolver.createProtoFileListings(request.getImportPaths()));
        }
        if (!request.getSourceDependencies().isEmpty()) {
            log.debug("Finding importable protobuf sources from explicitly provided source dependencies ({})", request.getSourceDependencies());
            Collection<Path> sourceDependencyPaths = this.mavenDependencyPathResolver.resolveAll(request.getSourceDependencies(), request.getDependencyResolutionDepth());
            importPaths.addAll(this.protoListingResolver.createProtoFileListings(sourceDependencyPaths));
        }
        if (!request.isIgnoreProjectDependencies()) {
            log.debug("Finding importable protobuf sources from project dependencies");
            Collection<Path> projectDependencyPaths = this.mavenProjectDependencyPathResolver.resolveProjectDependencies(request.getDependencyResolutionDepth());
            importPaths.addAll(this.protoListingResolver.createProtoFileListings(projectDependencyPaths));
        }
        return importPaths;
    }

    private Collection<ProtoFileListing> discoverCompilableSources(GenerationRequest request) throws IOException, ResolutionException {
        log.debug("Discovering all compilable protobuf source files");
        Collection<ProtoFileListing> sourcePathsListings = this.protoListingResolver.createProtoFileListings(request.getSourceRoots());
        Collection<Path> sourceDependencies = this.mavenDependencyPathResolver.resolveAll(request.getSourceDependencies(), request.getDependencyResolutionDepth());
        Collection<ProtoFileListing> sourceDependencyListings = this.protoListingResolver.createProtoFileListings(sourceDependencies);
        List<ProtoFileListing> sourcePaths = SourceCodeGenerator.concat(sourcePathsListings, sourceDependencyListings);
        log.info("Will generate source code for {} protobuf file(s)", (Object)sourcePaths.size());
        return sourcePaths;
    }

    private void createOutputDirectories(GenerationRequest request) throws IOException {
        Path directory = request.getOutputDirectory();
        log.debug("Creating {}", (Object)directory);
        FileUtils.getFileExtension(directory).filter(".jar"::equalsIgnoreCase).ifPresent(ext -> {
            throw new IllegalArgumentException("The output directory '" + directory + "' cannot be a path with a JAR file extension");
        });
        Files.createDirectories(directory, new FileAttribute[0]);
    }

    private void registerSourceRoots(GenerationRequest request) {
        Path directory = request.getOutputDirectory();
        if (request.isRegisterAsCompilationRoot()) {
            SourceRootRegistrar registrar = request.getSourceRootRegistrar();
            log.debug("Registering {} as {} compilation root", (Object)directory, (Object)registrar);
            registrar.registerSourceRoot(this.mavenSession, directory);
        } else {
            log.debug("Not registering {} as a compilation root", (Object)directory);
        }
    }

    @SafeVarargs
    private static <T> List<T> concat(Collection<T> ... collections) {
        return Stream.of(collections).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

