/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugin;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.ImmutableMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.PathProtocPlugin;
import io.github.ascopes.protobufmavenplugin.ProtocPlugin;
import io.github.ascopes.protobufmavenplugin.UrlProtocPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformClassifierFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.dependency.UrlResourceFetcher;
import io.github.ascopes.protobufmavenplugin.plugin.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugin.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class BinaryPluginResolver {
    private final MavenDependencyPathResolver dependencyResolver;
    private final PlatformClassifierFactory platformClassifierFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UrlResourceFetcher urlResourceFetcher;

    @Inject
    public BinaryPluginResolver(MavenDependencyPathResolver dependencyResolver, PlatformClassifierFactory platformClassifierFactory, SystemPathBinaryResolver systemPathResolver, UrlResourceFetcher urlResourceFetcher) {
        this.dependencyResolver = dependencyResolver;
        this.platformClassifierFactory = platformClassifierFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    public Collection<ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolveMavenPlugin);
    }

    public Collection<ResolvedProtocPlugin> resolvePathPlugins(Collection<? extends PathProtocPlugin> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolvePathPlugin);
    }

    public Collection<ResolvedProtocPlugin> resolveUrlPlugins(Collection<? extends UrlProtocPlugin> plugins) throws ResolutionException {
        return this.resolveAll(plugins, this::resolveUrlPlugin);
    }

    private ResolvedProtocPlugin resolveMavenPlugin(MavenProtocPlugin plugin) throws ResolutionException {
        ImmutableMavenProtocPlugin.Builder pluginBuilder = ImmutableMavenProtocPlugin.builder().from(plugin);
        if (plugin.getClassifier() == null) {
            String classifier = this.platformClassifierFactory.getClassifier(plugin.getArtifactId());
            pluginBuilder.classifier(classifier);
        }
        if (plugin.getType() == null) {
            pluginBuilder.type("exe");
        }
        plugin = pluginBuilder.build();
        Path path = this.dependencyResolver.resolveOne(plugin, DependencyResolutionDepth.DIRECT).iterator().next();
        this.makeExecutable(path);
        return this.createResolvedProtocPlugin(plugin, path);
    }

    private ResolvedProtocPlugin resolvePathPlugin(PathProtocPlugin plugin) throws ResolutionException {
        Path path = this.systemPathResolver.resolve(plugin.getName()).orElseThrow(() -> new ResolutionException("No executable '" + plugin.getName() + "' was found on the system path"));
        return this.createResolvedProtocPlugin(plugin, path);
    }

    private ResolvedProtocPlugin resolveUrlPlugin(UrlProtocPlugin plugin) throws ResolutionException {
        Path path = this.urlResourceFetcher.fetchFileFromUrl(plugin.getUrl(), ".exe");
        this.makeExecutable(path);
        return this.createResolvedProtocPlugin(plugin, path);
    }

    private ResolvedProtocPlugin createResolvedProtocPlugin(ProtocPlugin plugin, Path path) {
        return ImmutableResolvedProtocPlugin.builder().id(Digests.sha1(path.toString())).path(path).options(plugin.getOptions()).build();
    }

    private <A> Collection<ResolvedProtocPlugin> resolveAll(Collection<A> plugins, Resolver<A> resolver) throws ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        for (A plugin : plugins) {
            resolvedPlugins.add(resolver.resolve(plugin));
        }
        return resolvedPlugins;
    }

    private void makeExecutable(Path path) throws ResolutionException {
        try {
            FileUtils.makeExecutable(path);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc plugin", ex);
        }
    }

    @FunctionalInterface
    private static interface Resolver<A> {
        public ResolvedProtocPlugin resolve(A var1) throws ResolutionException;
    }
}

