/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.MavenArtifactBean;
import io.github.ascopes.protobufmavenplugin.MavenProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.PathProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.UrlProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.ImmutableGenerationRequest;
import io.github.ascopes.protobufmavenplugin.generate.Language;
import io.github.ascopes.protobufmavenplugin.generate.SourceCodeGenerator;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jspecify.annotations.Nullable;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    @Component
    SourceCodeGenerator sourceCodeGenerator;
    @Component
    MavenProject mavenProject;
    @Parameter
    @Nullable List<MavenProtocPluginBean> binaryMavenPlugins;
    @Parameter
    @Nullable List<PathProtocPluginBean> binaryPathPlugins;
    @Parameter
    @Nullable List<UrlProtocPluginBean> binaryUrlPlugins;
    @Parameter(defaultValue="TRANSITIVE")
    DependencyResolutionDepth dependencyResolutionDepth;
    @Parameter(defaultValue="true")
    boolean failOnMissingSources;
    @Parameter(defaultValue="true")
    boolean failOnMissingTargets;
    @Parameter(defaultValue="false")
    boolean fatalWarnings;
    @Parameter(defaultValue="false")
    boolean ignoreProjectDependencies;
    @Parameter
    @Nullable List<MavenArtifactBean> importDependencies;
    @Parameter
    @Nullable List<File> importPaths;
    @Parameter
    @Nullable List<MavenProtocPluginBean> jvmMavenPlugins;
    @Parameter(defaultValue="false")
    boolean liteOnly;
    @Parameter
    @Nullable File outputDirectory;
    @Parameter(required=true, property="protoc.version")
    String protocVersion;
    @Parameter(defaultValue="true")
    boolean registerAsCompilationRoot;
    @Parameter
    @Nullable List<MavenArtifactBean> sourceDependencies;
    @Parameter
    @Nullable List<File> sourceDirectories;
    @Parameter(defaultValue="false")
    boolean cppEnabled;
    @Parameter(defaultValue="false")
    boolean csharpEnabled;
    @Parameter(defaultValue="true")
    boolean javaEnabled;
    @Parameter(defaultValue="false")
    boolean kotlinEnabled;
    @Parameter(defaultValue="false")
    boolean objcEnabled;
    @Parameter(defaultValue="false")
    boolean phpEnabled;
    @Parameter(defaultValue="false")
    boolean pythonEnabled;
    @Parameter(defaultValue="false")
    boolean pythonStubsEnabled;
    @Parameter(defaultValue="false")
    boolean rubyEnabled;
    @Parameter(defaultValue="false")
    boolean rustEnabled;

    abstract SourceRootRegistrar sourceRootRegistrar();

    abstract Path defaultSourceDirectory();

    abstract Path defaultOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        EnumSet<Language> enabledLanguages = Language.setBuilder().addIf(this.cppEnabled, Language.CPP).addIf(this.csharpEnabled, Language.C_SHARP).addIf(this.javaEnabled, Language.JAVA).addIf(this.kotlinEnabled, Language.KOTLIN).addIf(this.objcEnabled, Language.OBJECTIVE_C).addIf(this.phpEnabled, Language.PHP).addIf(this.pythonEnabled, Language.PYTHON).addIf(this.pythonStubsEnabled, Language.PYI).addIf(this.rubyEnabled, Language.RUBY).addIf(this.rustEnabled, Language.RUST).build();
        ImmutableGenerationRequest request = ImmutableGenerationRequest.builder().binaryMavenPlugins(this.nonNullList(this.binaryMavenPlugins)).binaryPathPlugins(this.nonNullList(this.binaryPathPlugins)).binaryUrlPlugins(this.nonNullList(this.binaryUrlPlugins)).dependencyResolutionDepth(this.dependencyResolutionDepth).enabledLanguages(enabledLanguages).jvmMavenPlugins(this.nonNullList(this.jvmMavenPlugins)).importDependencies(this.nonNullList(this.importDependencies)).importPaths(this.nonNullList(this.importPaths).stream().map(File::toPath).collect(Collectors.toList())).isFailOnMissingSources(this.failOnMissingSources).isFailOnMissingTargets(this.failOnMissingTargets).isFatalWarnings(this.fatalWarnings).isIgnoreProjectDependencies(this.ignoreProjectDependencies).isLiteEnabled(this.liteOnly).isRegisterAsCompilationRoot(this.registerAsCompilationRoot).outputDirectory(this.outputDirectory()).protocVersion(this.protocVersion()).sourceDependencies(this.nonNullList(this.sourceDependencies)).sourceRootRegistrar(this.sourceRootRegistrar()).sourceRoots(this.sourceDirectories()).build();
        try {
            if (!this.sourceCodeGenerator.generate(request)) {
                throw new MojoExecutionException("Protoc invocation failed");
            }
        }
        catch (ResolutionException | IOException ex) {
            MojoFailureException mojoFailureException = new MojoFailureException((Object)this, ex.getMessage(), ex.getMessage());
            mojoFailureException.initCause((Throwable)ex);
            throw mojoFailureException;
        }
    }

    private Path outputDirectory() {
        return Optional.ofNullable(this.outputDirectory).map(File::toPath).orElseGet(this::defaultOutputDirectory);
    }

    private Collection<Path> sourceDirectories() {
        if (this.sourceDirectories == null || this.sourceDirectories.isEmpty()) {
            return List.of(this.defaultSourceDirectory());
        }
        return this.sourceDirectories.stream().map(File::toPath).collect(Collectors.toList());
    }

    private String protocVersion() {
        String overriddenVersion = System.getProperty("protoc.version");
        Objects.requireNonNull(this.protocVersion, "protocVersion has not been set");
        return Objects.requireNonNullElse(overriddenVersion, this.protocVersion);
    }

    private <T> List<T> nonNullList(@Nullable List<T> list) {
        return Objects.requireNonNullElseGet(list, List::of);
    }
}

