/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class MavenDependencyPathResolver {
    private static final Logger log = LoggerFactory.getLogger(MavenDependencyPathResolver.class);
    private final MavenSession mavenSession;
    private final RepositorySystem repositorySystem;
    private final ArtifactHandler artifactHandler;

    @Inject
    public MavenDependencyPathResolver(MavenSession mavenSession, RepositorySystem repositorySystem, ArtifactHandler artifactHandler) {
        this.mavenSession = mavenSession;
        this.repositorySystem = repositorySystem;
        this.artifactHandler = artifactHandler;
    }

    public Collection<Path> resolveOne(MavenArtifact mavenArtifact, DependencyResolutionDepth dependencyResolutionDepth) throws ResolutionException {
        return this.resolveAll(List.of(mavenArtifact), dependencyResolutionDepth);
    }

    public Collection<Path> resolveAll(Collection<? extends MavenArtifact> mavenArtifacts, DependencyResolutionDepth dependencyResolutionDepth) throws ResolutionException {
        if (mavenArtifacts.isEmpty()) {
            log.debug("No artifacts provided, not resolving anything in this round...");
            return List.of();
        }
        Collection<Artifact> artifacts = dependencyResolutionDepth == DependencyResolutionDepth.DIRECT ? this.resolveDirect(mavenArtifacts) : this.resolveTransitive(mavenArtifacts);
        return artifacts.stream().map(Artifact::getFile).map(File::toPath).collect(Collectors.toList());
    }

    private Collection<Artifact> resolveDirect(Collection<? extends MavenArtifact> mavenArtifacts) throws ResolutionException {
        return this.resolveDirectWithBackReferences(mavenArtifacts).keySet();
    }

    private Map<Artifact, MavenArtifact> resolveDirectWithBackReferences(Collection<? extends MavenArtifact> mavenArtifacts) throws ResolutionException {
        log.debug("Resolving direct artifacts {}", mavenArtifacts);
        LinkedHashMap<ArtifactRequest, MavenArtifact> artifactRequests = new LinkedHashMap<ArtifactRequest, MavenArtifact>();
        for (MavenArtifact mavenArtifact : mavenArtifacts) {
            artifactRequests.put(this.getArtifactRequest(mavenArtifact), mavenArtifact);
        }
        try {
            return this.repositorySystem.resolveArtifacts(this.mavenSession.getRepositorySession(), artifactRequests.keySet()).stream().collect(Collectors.toMap(ArtifactResult::getArtifact, result -> (MavenArtifact)artifactRequests.get(result.getRequest())));
        }
        catch (ArtifactResolutionException ex) {
            throw new ResolutionException("Failed to resolve one or more artifacts", ex);
        }
    }

    private ArtifactRequest getArtifactRequest(MavenArtifact mavenArtifact) {
        DefaultArtifact artifact = new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), this.specifiedOrElse(mavenArtifact.getClassifier(), () -> ((ArtifactHandler)this.artifactHandler).getClassifier()), this.specifiedOrElse(mavenArtifact.getType(), () -> "jar"), mavenArtifact.getVersion());
        return new ArtifactRequest((Artifact)artifact, this.remoteRepositories(), null);
    }

    private Collection<Artifact> resolveTransitive(Collection<? extends MavenArtifact> mavenArtifacts) throws ResolutionException {
        Map<Artifact, MavenArtifact> resolvedArtifacts = this.resolveDirectWithBackReferences(mavenArtifacts);
        List<Dependency> dependenciesToResolve = resolvedArtifacts.keySet().stream().filter(artifact -> ((MavenArtifact)resolvedArtifacts.get(artifact)).getDependencyResolutionDepth() != DependencyResolutionDepth.DIRECT).map(this::createDependencyFromArtifact).collect(Collectors.toList());
        log.debug("Resolving transitive dependencies for {}", dependenciesToResolve);
        CollectRequest collectRequest = new CollectRequest(dependenciesToResolve, this.createDependencyManagementFor(dependenciesToResolve, resolvedArtifacts.keySet()), this.remoteRepositories());
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        try {
            Stream<Artifact> resolvedDependencies = this.repositorySystem.resolveDependencies(this.mavenSession.getRepositorySession(), dependencyRequest).getArtifactResults().stream().map(ArtifactResult::getArtifact);
            return Stream.concat(resolvedArtifacts.keySet().stream(), resolvedDependencies).distinct().collect(Collectors.toList());
        }
        catch (DependencyResolutionException ex) {
            throw new ResolutionException("Failed to resolve one or more dependencies", ex);
        }
    }

    private Dependency createDependencyFromArtifact(Artifact artifact) {
        return new Dependency(artifact, null, Boolean.valueOf(false));
    }

    private List<Dependency> createDependencyManagementFor(List<Dependency> dependencies, Collection<Artifact> artifacts) {
        return Stream.concat(artifacts.stream().map(this::createDependencyFromArtifact), dependencies.stream()).collect(Collectors.toList());
    }

    private List<RemoteRepository> remoteRepositories() {
        return RepositoryUtils.toRepos((List)this.mavenSession.getProjectBuildingRequest().getRemoteRepositories());
    }

    private @Nullable String specifiedOrElse(@Nullable String value, Supplier<@Nullable String> elseGet) {
        return value == null || value.isBlank() ? elseGet.get() : value;
    }
}

