/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.Maven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class UrlResourceFetcher {
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private static final String USER_AGENT = "User-Agent";
    private static final Logger log = LoggerFactory.getLogger(UrlResourceFetcher.class);
    private final TemporarySpace temporarySpace;

    @Inject
    public UrlResourceFetcher(TemporarySpace temporarySpace) {
        this.temporarySpace = temporarySpace;
    }

    public Optional<Path> fetchFileFromUrl(URL url, String extension) throws ResolutionException {
        return url.getProtocol().equalsIgnoreCase("file") ? this.handleFileSystemUrl(url) : this.handleOtherUrl(url, extension);
    }

    private Optional<Path> handleFileSystemUrl(URL url) throws ResolutionException {
        try {
            return Optional.of(url.toURI()).map(Path::of).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        }
        catch (URISyntaxException ex) {
            throw new ResolutionException("Failed to resolve '" + url + "' due to malformed syntax", ex);
        }
    }

    private Optional<Path> handleOtherUrl(URL url, String extension) throws ResolutionException {
        Path targetFile = this.targetFile(url, extension);
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout((int)CONNECT_TIMEOUT.toMillis());
            conn.setReadTimeout((int)CONNECT_TIMEOUT.toMillis());
            conn.setAllowUserInteraction(false);
            conn.setDoOutput(false);
            conn.setRequestProperty(USER_AGENT, this.userAgent());
            conn.setUseCaches(true);
            log.debug("Connecting to '{}' to copy resources to '{}'", (Object)url, (Object)targetFile);
            conn.connect();
            try (InputStream responseBody = conn.getInputStream();){
                this.copyToFile(responseBody, targetFile);
            }
            catch (FileNotFoundException ex) {
                return Optional.empty();
            }
            log.info("Copied {} to {}", (Object)url, (Object)targetFile);
        }
        catch (IOException ex) {
            throw this.failedToCopy(url, targetFile, ex);
        }
        return Optional.of(targetFile);
    }

    private ResolutionException failedToCopy(URL source, Path destination, Exception cause) {
        return new ResolutionException("Failed to copy '" + source + "' to '" + destination + "'", cause);
    }

    private void copyToFile(InputStream inputStream, Path file) throws IOException {
        try (BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            inputStream.transferTo(fileStream);
        }
    }

    private String userAgent() {
        return "protobuf-maven-plugin/" + this.getClass().getPackage().getImplementationVersion() + " Apache-Maven/" + Maven.class.getPackage().getImplementationVersion() + " Java/" + Runtime.version().toString();
    }

    private Path targetFile(URL url, String extension) {
        String digest = Digests.sha1(url.toExternalForm());
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        String fileName = lastSlash < 0 ? digest : path.substring(lastSlash + 1) + "-" + digest;
        return this.temporarySpace.createTemporarySpace("url", url.getProtocol()).resolve(fileName + extension);
    }
}

