/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugin;

import io.github.ascopes.protobufmavenplugin.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generate.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.plugin.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugin.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugin.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class JvmPluginResolver {
    private static final Logger log = LoggerFactory.getLogger(BinaryPluginResolver.class);
    private final HostSystem hostSystem;
    private final MavenDependencyPathResolver dependencyResolver;
    private final TemporarySpace temporarySpace;

    @Inject
    public JvmPluginResolver(HostSystem hostSystem, MavenDependencyPathResolver dependencyResolver, TemporarySpace temporarySpace) {
        this.hostSystem = hostSystem;
        this.dependencyResolver = dependencyResolver;
        this.temporarySpace = temporarySpace;
    }

    public Collection<ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> plugins) throws IOException, ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        for (MavenProtocPlugin mavenProtocPlugin : plugins) {
            if (mavenProtocPlugin.isSkip()) {
                log.info("Skipping plugin {}", (Object)mavenProtocPlugin);
                continue;
            }
            resolvedPlugins.add(this.resolve(mavenProtocPlugin));
        }
        return resolvedPlugins;
    }

    private ResolvedProtocPlugin resolve(MavenProtocPlugin plugin) throws IOException, ResolutionException {
        log.debug("Resolving JVM-based Maven protoc plugin {} and generating OS-specific boostrap scripts", (Object)plugin);
        String pluginId = this.pluginIdDigest(plugin);
        List<String> argLine = this.resolveAndBuildArgLine(plugin);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsBatchScript(pluginId, argLine) : this.writeShellScript(pluginId, argLine);
        return ImmutableResolvedProtocPlugin.builder().id(pluginId).path(scriptPath).options(plugin.getOptions()).build();
    }

    private List<String> resolveAndBuildArgLine(MavenProtocPlugin plugin) throws ResolutionException {
        Iterator<Path> dependencyIterator = this.dependencyResolver.resolveOne(plugin, DependencyResolutionDepth.TRANSITIVE).iterator();
        Path pluginPath = dependencyIterator.next();
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        if (dependencyIterator.hasNext()) {
            args.add("-classpath");
            args.add(this.buildClasspath(dependencyIterator));
        }
        args.add("-jar");
        args.add(pluginPath.toString());
        return args;
    }

    private String buildClasspath(Iterator<Path> paths) {
        StringBuilder sb = new StringBuilder().append(paths.next());
        while (paths.hasNext()) {
            sb.append(":").append(paths.next());
        }
        return sb.toString();
    }

    private String pluginIdDigest(MavenProtocPlugin plugin) {
        return Digests.sha1(plugin.toString());
    }

    private Path resolvePluginScriptPath() {
        return this.temporarySpace.createTemporarySpace("plugins", "jvm");
    }

    private Path writeWindowsBatchScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".bat");
        String script = "@echo off\r\n" + Shlex.quoteBatchArgs(argLine) + "\r\n";
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.ISO_8859_1, new OpenOption[0]);
        return fullScriptPath;
    }

    private Path writeShellScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".sh");
        String script = "#!/usr/bin/env sh\nset -eu\n" + Shlex.quoteShellArgs(argLine) + "\n";
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.UTF_8, new OpenOption[0]);
        FileUtils.makeExecutable(fullScriptPath);
        return fullScriptPath;
    }
}

