/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.util.Iterator;
import java.util.function.Function;

public final class Shlex {
    private static final int LINE_LENGTH_TARGET = 99;
    private static final String INDENT = " ".repeat(4);

    private Shlex() {
    }

    public static String quoteShellArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex::quoteShellArg, " \\\n");
    }

    public static String quoteBatchArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex::quoteBatchArg, " ^\r\n");
    }

    private static String quote(Iterable<String> args, Function<String, String> quoter, String continuation) {
        Iterator<String> iter = args.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(quoter.apply(iter.next()));
        int lineLength = sb.length();
        while (iter.hasNext()) {
            String next = quoter.apply(iter.next());
            if (lineLength + next.length() >= 99) {
                sb.append(continuation);
                lineLength = INDENT.length();
                sb.append(INDENT);
            } else {
                sb.append(" ");
                ++lineLength;
            }
            sb.append(next);
            lineLength += next.length();
        }
        return sb.toString();
    }

    private static String quoteShellArg(String arg) {
        if (Shlex.isSafe(arg)) {
            return arg;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        block6: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("'\"'\"'");
                    continue block6;
                }
                case '\n': {
                    sb.append("'$'\\n''");
                    continue block6;
                }
                case '\r': {
                    sb.append("'$'\\r''");
                    continue block6;
                }
                case '\t': {
                    sb.append("'$'\\t''");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\'');
        return sb.toString();
    }

    private static String quoteBatchArg(String arg) {
        if (Shlex.isSafe(arg)) {
            return arg;
        }
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '%': {
                    sb.append("%%");
                    continue block4;
                }
                case '\t': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '|': {
                    sb.append('^').append(c);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static boolean isSafe(String arg) {
        for (int i = 0; i < arg.length(); ++i) {
            boolean safe;
            char c = arg.charAt(i);
            boolean bl = safe = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '/' || c == '_' || c == '.' || c == '=';
            if (safe) continue;
            return false;
        }
        return true;
    }
}

