/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class CommandLineExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandLineExecutor.class);

    @Inject
    public CommandLineExecutor() {
    }

    public boolean execute(List<String> args) throws IOException {
        log.info("Calling protoc with the following command line:\n{}", (Object)Shlex.quoteShellArgs(args));
        ProcessBuilder procBuilder = new ProcessBuilder(args);
        procBuilder.environment().putAll(System.getenv());
        procBuilder.inheritIO();
        try {
            return this.run(procBuilder);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Compilation was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private boolean run(ProcessBuilder procBuilder) throws InterruptedException, IOException {
        long startTimeNs = System.nanoTime();
        Process proc = procBuilder.start();
        int exitCode = proc.waitFor();
        long elapsedTimeMs = (System.nanoTime() - startTimeNs) / 1000000L;
        if (exitCode == 0) {
            log.info("Protoc returned exit code 0 (success) after {}ms", (Object)elapsedTimeMs);
            return true;
        }
        log.error("Protoc returned exit code {} (error) after {}ms", (Object)exitCode, (Object)elapsedTimeMs);
        return false;
    }
}

