/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import io.github.ascopes.protobufmavenplugin.sources.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceRootRegistrar {
    public static final SourceRootRegistrar MAIN = new SourceRootRegistrar("main", MavenProject::addCompileSourceRoot, Build::getOutputDirectory);
    public static final SourceRootRegistrar TEST = new SourceRootRegistrar("test", MavenProject::addTestCompileSourceRoot, Build::getTestOutputDirectory);
    private static final Logger log = LoggerFactory.getLogger(SourceRootRegistrar.class);
    private final String name;
    private final BiConsumer<MavenProject, String> sourceRootRegistrar;
    private final Function<Build, String> classOutputDirectoryGetter;

    private SourceRootRegistrar(String name, BiConsumer<MavenProject, String> sourceRootRegistrar, Function<Build, String> classOutputDirectoryGetter) {
        this.name = name;
        this.sourceRootRegistrar = sourceRootRegistrar;
        this.classOutputDirectoryGetter = classOutputDirectoryGetter;
    }

    public void registerSourceRoot(MavenSession session, Path path) {
        log.info("Registering {} as a {} source root", (Object)path, (Object)this);
        this.sourceRootRegistrar.accept(session.getCurrentProject(), path.toString());
    }

    public void embedListing(MavenSession session, ProtoFileListing listing) throws IOException {
        log.info("Embedding sources from {} in {} class outputs", (Object)listing.getProtoFilesRoot(), (Object)this);
        Path targetDirectory = this.classOutputDirectoryGetter.andThen(x$0 -> Path.of(x$0, new String[0])).apply(session.getCurrentProject().getBuild());
        for (Path sourceFile : listing.getProtoFiles()) {
            Path targetFile = FileUtils.changeRelativePath(targetDirectory, listing.getProtoFilesRoot(), sourceFile);
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public String toString() {
        return "Maven " + this.name;
    }
}

