/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class PlatformClassifierFactory {
    private final HostSystem hostSystem;

    @Inject
    public PlatformClassifierFactory(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    public String getClassifier(String binaryName) {
        String rawOs = this.hostSystem.getOperatingSystem();
        String rawArch = this.hostSystem.getCpuArchitecture();
        if (this.hostSystem.isProbablyLinux()) {
            switch (rawArch) {
                case "ppc64le": 
                case "ppc64": {
                    return "linux-ppcle_64";
                }
                case "s390x": 
                case "zarch_64": {
                    return "linux-s390_64";
                }
                case "aarch64": {
                    return "linux-aarch_64";
                }
                case "amd64": {
                    return "linux-x86_64";
                }
            }
        } else if (this.hostSystem.isProbablyMacOs()) {
            switch (rawArch) {
                case "aarch64": {
                    return "osx-aarch_64";
                }
                case "amd64": 
                case "x86_64": {
                    return "osx-x86_64";
                }
            }
        } else if (this.hostSystem.isProbablyWindows()) {
            switch (rawArch) {
                case "amd64": 
                case "x86_64": {
                    return "windows-x86_64";
                }
                case "x86": 
                case "x86_32": {
                    return "windows-x86_32";
                }
            }
        }
        String message = String.format("No '%s' binary is available for reported OS '%s' and CPU architecture '%s'", binaryName, rawOs, rawArch);
        throw new UnsupportedOperationException(message);
    }
}

