/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generation.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.Maven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class UrlResourceFetcher {
    private static final int TIMEOUT = 30000;
    private static final String USER_AGENT = "User-Agent";
    private static final Logger log = LoggerFactory.getLogger(UrlResourceFetcher.class);
    private final TemporarySpace temporarySpace;

    @Inject
    public UrlResourceFetcher(TemporarySpace temporarySpace) {
        this.temporarySpace = temporarySpace;
    }

    public Optional<Path> fetchFileFromUrl(URL url, String extension) throws ResolutionException {
        return url.getProtocol().equalsIgnoreCase("file") ? this.handleFileSystemUrl(url) : this.handleOtherUrl(url, extension);
    }

    private Optional<Path> handleFileSystemUrl(URL url) throws ResolutionException {
        try {
            return Optional.of(url.toURI()).map(Path::of).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        }
        catch (URISyntaxException ex) {
            throw new ResolutionException("Failed to resolve '" + String.valueOf(url) + "' due to malformed syntax", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<Path> handleOtherUrl(URL url, String extension) throws ResolutionException {
        Path targetFile = this.targetFile(url, extension);
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setAllowUserInteraction(false);
            conn.setRequestProperty(USER_AGENT, this.userAgent());
            log.debug("Connecting to '{}' to copy resources to '{}'", (Object)url, (Object)targetFile);
            conn.connect();
            try (InputStream responseStream = conn.getInputStream();){
                Optional<Path> optional;
                try (BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(targetFile, new OpenOption[0]));){
                    responseStream.transferTo(fileStream);
                    log.info("Copied {} to {}", (Object)url, (Object)targetFile);
                    optional = Optional.of(targetFile);
                }
                return optional;
            }
            catch (FileNotFoundException ex) {
                log.debug("Resource at {} was not found", (Object)url);
                return Optional.empty();
            }
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to copy '" + String.valueOf(url) + "' to '" + String.valueOf(targetFile) + "'", ex);
        }
    }

    private String userAgent() {
        return "io.github.ascopes.protobuf-maven-plugin/" + this.version(this.getClass()) + " org.apache.maven/" + this.version(Maven.class) + " (Java " + Runtime.version().toString() + ")";
    }

    private String version(Class<?> cls) {
        return cls.getPackage().getImplementationVersion();
    }

    private Path targetFile(URL url, String extension) {
        String digest = Digests.sha1(url.toExternalForm());
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        String fileName = lastSlash < 0 ? digest : path.substring(lastSlash + 1) + "-" + digest;
        return this.temporarySpace.createTemporarySpace("url", url.getProtocol()).resolve(fileName + extension);
    }
}

