/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ScopeDependencyFilter;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AetherResolver {
    private static final Logger log = LoggerFactory.getLogger(AetherResolver.class);
    private final RepositorySystem repositorySystem;
    private final ProtobufMavenPluginRepositorySession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;

    AetherResolver(RepositorySystem repositorySystem, ProtobufMavenPluginRepositorySession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
    }

    RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    ProtobufMavenPluginRepositorySession getRepositorySystemSession() {
        return this.repositorySystemSession;
    }

    List<RemoteRepository> getRemoteRepositories() {
        return Collections.unmodifiableList(this.remoteRepositories);
    }

    Artifact resolveArtifact(Artifact unresolvedArtifact) throws ResolutionException {
        log.info("Resolving artifact {} from repositories", (Object)unresolvedArtifact);
        ArtifactRequest request = new ArtifactRequest(unresolvedArtifact, this.remoteRepositories, null);
        try {
            ArtifactResult response = this.repositorySystem.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, request);
            if (response.isResolved()) {
                this.logWarnings("resolving artifact " + String.valueOf(unresolvedArtifact), response.getExceptions());
                return Objects.requireNonNull(response.getArtifact(), "No artifact was returned! Panic!");
            }
            throw this.resolutionException("failed to resolve artifact " + String.valueOf(unresolvedArtifact), response.getExceptions());
        }
        catch (ArtifactResolutionException ex) {
            throw new ResolutionException("Failed to resolve artifact " + String.valueOf(unresolvedArtifact), ex);
        }
    }

    Collection<Artifact> resolveDependenciesToArtifacts(List<Dependency> unresolvedDependencies, Set<String> dependencyScopes, boolean failOnInvalidDependencies) throws ResolutionException {
        ScopeDependencyFilter scopeFilter = new ScopeDependencyFilter(dependencyScopes);
        CollectRequest collectRequest = new CollectRequest(unresolvedDependencies, null, this.remoteRepositories);
        DependencyRequest request = new DependencyRequest(collectRequest, (DependencyFilter)scopeFilter);
        log.debug("Attempting to resolve the following dependencies in this pass: {}", unresolvedDependencies);
        DependencyResult response = this.resolveDependencies(request, failOnInvalidDependencies);
        return this.extractArtifactsFromResolvedDependencies(response);
    }

    private DependencyResult resolveDependencies(DependencyRequest request, boolean failOnInvalidDependencies) throws ResolutionException {
        DependencyResult response;
        try {
            response = this.repositorySystem.resolveDependencies((RepositorySystemSession)this.repositorySystemSession, request);
        }
        catch (DependencyResolutionException ex) {
            response = ex.getResult();
            if (response == null || failOnInvalidDependencies) {
                throw new ResolutionException("Failed to resolve dependencies from repositories", ex);
            }
            log.warn("Error resolving one or more dependencies, dependencies may be missing during protobuf compilation! {}", (Object)ex.getMessage(), (Object)ex);
        }
        return response;
    }

    private List<Artifact> extractArtifactsFromResolvedDependencies(DependencyResult response) throws ResolutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        boolean failedAtLeastOnce = false;
        for (ArtifactResult artifactResponse : response.getArtifactResults()) {
            exceptions.addAll(artifactResponse.getExceptions());
            Artifact artifact = artifactResponse.getArtifact();
            if (artifact == null) {
                failedAtLeastOnce = true;
                continue;
            }
            artifacts.add(artifact);
        }
        if (failedAtLeastOnce) {
            throw this.resolutionException("Failed to resolve artifacts for dependencies", exceptions);
        }
        return artifacts;
    }

    private ResolutionException resolutionException(String errorMessage, Iterable<Exception> causes) {
        ResolutionException ex = new ResolutionException(errorMessage);
        Iterator<Exception> iterator = causes.iterator();
        if (iterator.hasNext()) {
            ex.initCause(iterator.next());
            iterator.forEachRemaining(ex::addSuppressed);
        }
        return ex;
    }

    private void logWarnings(String descriptionOfAction, Iterable<Exception> exceptions) {
        Iterator<Exception> iterator = exceptions.iterator();
        if (iterator.hasNext()) {
            iterator.forEachRemaining(ex -> log.debug("Encountered a non-fatal resolution error while {}", (Object)descriptionOfAction, ex));
        }
    }
}

