/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.WildcardAwareDependencyTraverser;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AetherArtifactMapper {
    private static final String DEFAULT_EXTENSION = "jar";
    private static final String DEFAULT_SCOPE = "compile";
    private static final Logger log = LoggerFactory.getLogger(AetherArtifactMapper.class);
    private final ArtifactTypeRegistry artifactTypeRegistry;

    AetherArtifactMapper(ArtifactTypeRegistry artifactTypeRegistry) {
        this.artifactTypeRegistry = artifactTypeRegistry;
    }

    ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    Path mapEclipseArtifactToPath(Artifact eclipseArtifact) {
        File file = eclipseArtifact.getFile();
        return FileUtils.normalize(file.toPath());
    }

    Artifact mapPmpArtifactToEclipseArtifact(MavenArtifact mavenArtifact) {
        ArtifactType type = this.dependencyTypeToEclipseArtifactType(mavenArtifact.getType());
        return new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getClassifier() == null || mavenArtifact.getClassifier().trim().isEmpty() ? type.getClassifier() : mavenArtifact.getClassifier(), type.getExtension(), mavenArtifact.getVersion());
    }

    Dependency mapPmpArtifactToEclipseDependency(MavenArtifact mavenArtifact, DependencyResolutionDepth defaultDepth) {
        DependencyResolutionDepth effectiveDependencyResolutionDepth = Objects.requireNonNullElse(mavenArtifact.getDependencyResolutionDepth(), defaultDepth);
        List<Object> exclusions = effectiveDependencyResolutionDepth == DependencyResolutionDepth.DIRECT ? List.of(WildcardAwareDependencyTraverser.WILDCARD_EXCLUSION) : List.of();
        Artifact artifact = this.mapPmpArtifactToEclipseArtifact(mavenArtifact);
        return new Dependency(artifact, DEFAULT_SCOPE, Boolean.valueOf(false), exclusions);
    }

    Dependency mapMavenDependencyToEclipseDependency(org.apache.maven.model.Dependency mavenDependency) {
        return RepositoryUtils.toDependency((org.apache.maven.model.Dependency)mavenDependency, (ArtifactTypeRegistry)this.artifactTypeRegistry);
    }

    private ArtifactType dependencyTypeToEclipseArtifactType(@Nullable String depType) {
        final String adjustedType = depType == null ? DEFAULT_EXTENSION : depType;
        ArtifactType type = this.artifactTypeRegistry.get(adjustedType);
        if (type == null) {
            log.debug("Could not resolve extension {} to any known Aether artifact type", (Object)adjustedType);
            type = new ArtifactType(){
                final /* synthetic */ AetherArtifactMapper this$0;
                {
                    this.this$0 = this$0;
                }

                public String getId() {
                    return adjustedType;
                }

                public String getExtension() {
                    return adjustedType;
                }

                public String getClassifier() {
                    return "";
                }

                public Map<String, String> getProperties() {
                    return Map.of();
                }
            };
        } else {
            log.debug("Resolved extension {} to Aether artifact type (classifier: {}, type: {}, id: {}, {})", new Object[]{adjustedType, type.getClassifier(), type.getExtension(), type.getId(), type.getProperties()});
        }
        return type;
    }
}

