/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;

final class SerializedIncrementalCacheModule
extends SimpleModule {
    SerializedIncrementalCacheModule() {
        this.addKeyDeserializer(Path.class, new PathKeyDeserializer());
        this.addKeySerializer(Path.class, (JsonSerializer)new PathKeySerializer());
    }

    private static final class PathKeyDeserializer
    extends KeyDeserializer {
        private PathKeyDeserializer() {
        }

        public Path deserializeKey(String key, DeserializationContext context) {
            return Path.of(URI.create(key));
        }
    }

    private static final class PathKeySerializer
    extends StdSerializer<Path> {
        private PathKeySerializer() {
            super(Path.class);
        }

        public void serialize(Path path, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeFieldName(path.toUri().toASCIIString());
        }
    }
}

