/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.mojo;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenDependencyBean;
import io.github.ascopes.protobufmavenplugin.generation.ImmutableGenerationRequest;
import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.generation.OutputDescriptorAttachmentRegistrar;
import io.github.ascopes.protobufmavenplugin.generation.ProtobufBuildOrchestrator;
import io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.plugins.UrlProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    private static final String DEFAULT_FALSE = "false";
    private static final String DEFAULT_TRUE = "true";
    private static final String DEFAULT_TRANSITIVE = "TRANSITIVE";
    private static final String PROTOBUF_COMPILER_EXCLUDES = "protobuf.compiler.excludes";
    private static final String PROTOBUF_COMPILER_INCLUDES = "protobuf.compiler.includes";
    private static final String PROTOBUF_COMPILER_INCREMENTAL = "protobuf.compiler.incremental";
    private static final String PROTOBUF_COMPILER_VERSION = "protobuf.compiler.version";
    private static final String PROTOBUF_SKIP = "protobuf.skip";
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerateMojo.class);
    @Inject
    ProtobufBuildOrchestrator sourceCodeGenerator;
    @Inject
    MavenProject mavenProject;
    @Inject
    MavenProjectHelper mavenProjectHelper;
    @Parameter
    @Nullable List<MavenProtocPluginBean> binaryMavenPlugins;
    @Parameter
    @Nullable List<PathProtocPluginBean> binaryPathPlugins;
    @Parameter
    @Nullable List<UrlProtocPluginBean> binaryUrlPlugins;
    @Parameter(defaultValue="false")
    boolean cppEnabled;
    @Parameter(defaultValue="false")
    boolean csharpEnabled;
    @Parameter(defaultValue="TRANSITIVE")
    DependencyResolutionDepth dependencyResolutionDepth;
    @Parameter
    @Nullable Set<String> dependencyScopes;
    @Parameter(defaultValue="false")
    boolean embedSourcesInClassOutputs;
    @Parameter(property="protobuf.compiler.excludes")
    @Nullable List<String> excludes;
    @Parameter(defaultValue="false")
    boolean failOnInvalidDependencies;
    @Parameter(defaultValue="true")
    boolean failOnMissingSources;
    @Parameter(defaultValue="true")
    boolean failOnMissingTargets;
    @Parameter(defaultValue="false")
    boolean fatalWarnings;
    @Parameter(defaultValue="false")
    boolean ignoreProjectDependencies;
    @Parameter
    @Nullable List<MavenDependencyBean> importDependencies;
    @Parameter
    @Nullable List<File> importPaths;
    @Parameter(property="protobuf.compiler.includes")
    @Nullable List<String> includes;
    @Parameter(defaultValue="true", property="protobuf.compiler.incremental")
    boolean incrementalCompilation;
    @Parameter(defaultValue="true")
    boolean javaEnabled;
    @Parameter
    @Nullable List<MavenProtocPluginBean> jvmMavenPlugins;
    @Parameter(defaultValue="false")
    boolean kotlinEnabled;
    @Parameter(defaultValue="false")
    boolean liteOnly;
    @Parameter(defaultValue="false")
    boolean objcEnabled;
    @Parameter
    @Nullable File outputDescriptorFile;
    @Parameter(defaultValue="false")
    boolean outputDescriptorAttached;
    @Parameter
    @Nullable String outputDescriptorAttachmentType;
    @Parameter
    @Nullable String outputDescriptorAttachmentClassifier;
    @Parameter(defaultValue="false")
    boolean outputDescriptorIncludeImports;
    @Parameter(defaultValue="false")
    boolean outputDescriptorIncludeSourceInfo;
    @Parameter(defaultValue="false")
    boolean outputDescriptorRetainOptions;
    @Parameter
    @Nullable File outputDirectory;
    @Parameter(defaultValue="false")
    boolean phpEnabled;
    @Parameter(required=true, property="protobuf.compiler.version")
    String protocVersion;
    @Parameter(defaultValue="false")
    boolean pythonEnabled;
    @Parameter(defaultValue="false")
    boolean pythonStubsEnabled;
    @Parameter(defaultValue="true")
    boolean registerAsCompilationRoot;
    @Parameter(defaultValue="false")
    boolean rubyEnabled;
    @Parameter(defaultValue="false")
    boolean rustEnabled;
    @Parameter(defaultValue="false", property="protobuf.skip")
    boolean skip;
    @Parameter
    @Nullable List<MavenDependencyBean> sourceDependencies;
    @Parameter
    @Nullable List<File> sourceDirectories;

    abstract Path defaultSourceDirectory();

    abstract Path defaultOutputDirectory();

    abstract Set<String> defaultDependencyScopes();

    abstract SourceRootRegistrar sourceRootRegistrar();

    abstract OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            log.info("Execution of this plugin has been skipped in the configuration");
            return;
        }
        EnumSet<Language> enabledLanguages = Language.languageSet().addIf(this.cppEnabled, Language.CPP).addIf(this.csharpEnabled, Language.C_SHARP).addIf(this.javaEnabled, Language.JAVA).addIf(this.kotlinEnabled, Language.KOTLIN).addIf(this.objcEnabled, Language.OBJECTIVE_C).addIf(this.phpEnabled, Language.PHP).addIf(this.pythonEnabled, Language.PYTHON).addIf(this.pythonStubsEnabled, Language.PYI).addIf(this.rubyEnabled, Language.RUBY).addIf(this.rustEnabled, Language.RUST).build();
        ImmutableGenerationRequest request = ImmutableGenerationRequest.builder().binaryMavenPlugins(this.nonNullList(this.binaryMavenPlugins)).binaryPathPlugins(this.nonNullList(this.binaryPathPlugins)).binaryUrlPlugins(this.nonNullList(this.binaryUrlPlugins)).dependencyResolutionDepth(this.dependencyResolutionDepth).dependencyScopes(this.dependencyScopes()).enabledLanguages(enabledLanguages).excludes(this.nonNullList(this.excludes)).jvmMavenPlugins(this.nonNullList(this.jvmMavenPlugins)).importDependencies(this.nonNullList(this.importDependencies)).importPaths(this.importPaths()).includes(this.nonNullList(this.includes)).isEmbedSourcesInClassOutputs(this.embedSourcesInClassOutputs).isFailOnInvalidDependencies(this.failOnInvalidDependencies).isFailOnMissingSources(this.failOnMissingSources).isFailOnMissingTargets(this.failOnMissingTargets).isFatalWarnings(this.fatalWarnings).isIncrementalCompilationEnabled(this.incrementalCompilation).isIgnoreProjectDependencies(this.ignoreProjectDependencies).isLiteEnabled(this.liteOnly).isOutputDescriptorAttached(this.outputDescriptorAttached).isOutputDescriptorIncludeImports(this.outputDescriptorIncludeImports).isOutputDescriptorIncludeSourceInfo(this.outputDescriptorIncludeSourceInfo).isOutputDescriptorRetainOptions(this.outputDescriptorRetainOptions).isRegisterAsCompilationRoot(this.registerAsCompilationRoot).outputDescriptorAttachmentRegistrar(this.outputDescriptorAttachmentRegistrar()).outputDescriptorAttachmentType(this.outputDescriptorAttachmentType).outputDescriptorAttachmentClassifier(this.outputDescriptorAttachmentClassifier).outputDescriptorFile(this.outputDescriptorFile()).outputDirectory(this.outputDirectory()).protocVersion(this.protocVersion()).sourceDependencies(this.nonNullList(this.sourceDependencies)).sourceRootRegistrar(this.sourceRootRegistrar()).sourceRoots(this.sourceDirectories()).build();
        try {
            if (!this.sourceCodeGenerator.generate(request)) {
                throw new MojoExecutionException("Protoc invocation failed");
            }
        }
        catch (ResolutionException | IOException ex) {
            MojoFailureException mojoFailureException = new MojoFailureException((Object)this, ex.getMessage(), ex.getMessage());
            mojoFailureException.initCause((Throwable)ex);
            throw mojoFailureException;
        }
    }

    private Set<String> dependencyScopes() {
        return Optional.ofNullable(this.dependencyScopes).filter(Predicate.not(Set::isEmpty)).orElseGet(this::defaultDependencyScopes);
    }

    private @Nullable Path outputDescriptorFile() {
        return Optional.ofNullable(this.outputDescriptorFile).map(File::toPath).orElse(null);
    }

    private Path outputDirectory() {
        return Optional.ofNullable(this.outputDirectory).map(File::toPath).orElseGet(this::defaultOutputDirectory);
    }

    private Collection<Path> sourceDirectories() {
        List transformedSourceDirectories = Optional.ofNullable(this.sourceDirectories).filter(Predicate.not(Collection::isEmpty)).stream().flatMap(Collection::stream).map(File::toPath).collect(Collectors.toUnmodifiableList());
        List finalDirectories = transformedSourceDirectories.isEmpty() ? List.of(this.defaultSourceDirectory()) : transformedSourceDirectories;
        return finalDirectories.stream().filter(this::sourceDirectoryExists).collect(Collectors.toUnmodifiableList());
    }

    private boolean sourceDirectoryExists(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            log.info("Ignoring source directory {} as it does not appear to actually exist", (Object)path);
            return false;
        }
        return true;
    }

    private Collection<Path> importPaths() {
        return this.nonNullList(this.importPaths).stream().map(File::toPath).collect(Collectors.toUnmodifiableList());
    }

    private String protocVersion() {
        String overriddenVersion = System.getProperty(PROTOBUF_COMPILER_VERSION);
        return overriddenVersion == null ? Objects.requireNonNull(this.protocVersion, "protocVersion has not been set") : overriddenVersion;
    }

    private <T> List<T> nonNullList(@Nullable List<T> list) {
        return Objects.requireNonNullElseGet(list, List::of);
    }
}

