/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherArtifactMapper;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
final class AetherMavenArtifactPathResolver
implements MavenArtifactPathResolver {
    private static final Logger log = LoggerFactory.getLogger(AetherMavenArtifactPathResolver.class);
    private final MavenSession mavenSession;
    private final AetherArtifactMapper aetherMapper;
    private final AetherResolver aetherResolver;

    @Inject
    AetherMavenArtifactPathResolver(MavenSession mavenSession, RepositorySystem repositorySystem) {
        List remoteRepositories = mavenSession.getCurrentProject().getRemoteProjectRepositories();
        this.mavenSession = mavenSession;
        ProtobufMavenPluginRepositorySession repositorySystemSession = new ProtobufMavenPluginRepositorySession(mavenSession.getRepositorySession());
        this.aetherMapper = new AetherArtifactMapper(repositorySystemSession.getArtifactTypeRegistry());
        this.aetherResolver = new AetherResolver(repositorySystem, repositorySystemSession, remoteRepositories);
        log.debug("Using remote repositories: {}", (Object)remoteRepositories);
        log.debug("Using repository system session: {}", (Object)repositorySystemSession);
    }

    MavenSession getMavenSession() {
        return this.mavenSession;
    }

    AetherArtifactMapper getAetherMapper() {
        return this.aetherMapper;
    }

    AetherResolver getAetherResolver() {
        return this.aetherResolver;
    }

    @Override
    public Path resolveArtifact(MavenArtifact mavenArtifact) throws ResolutionException {
        log.debug("Resolving artifact: {}", (Object)mavenArtifact);
        Artifact unresolvedArtifact = this.aetherMapper.mapPmpArtifactToEclipseArtifact(mavenArtifact);
        Artifact resolvedArtifact = this.aetherResolver.resolveArtifact(unresolvedArtifact);
        return this.aetherMapper.mapEclipseArtifactToPath(resolvedArtifact);
    }

    @Override
    public List<Path> resolveDependencies(Collection<? extends MavenArtifact> artifacts, DependencyResolutionDepth defaultDepth, Set<String> dependencyScopes, boolean includeProjectDependencies, boolean failOnInvalidDependencies) throws ResolutionException {
        ArrayList<Dependency> unresolvedDependencies = new ArrayList<Dependency>();
        artifacts.stream().peek(artifact -> log.debug("Resolving artifact as dependency: {}", artifact)).map(artifact -> this.aetherMapper.mapPmpArtifactToEclipseDependency((MavenArtifact)artifact, defaultDepth)).forEach(unresolvedDependencies::add);
        if (includeProjectDependencies) {
            this.mavenSession.getCurrentProject().getDependencies().stream().peek(dependency -> log.debug("Resolving project dependency: {}", dependency)).map(this.aetherMapper::mapMavenDependencyToEclipseDependency).forEach(unresolvedDependencies::add);
        }
        Collection<Artifact> resolvedArtifacts = this.aetherResolver.resolveDependenciesToArtifacts(unresolvedDependencies, dependencyScopes, failOnInvalidDependencies);
        return resolvedArtifacts.stream().map(this.aetherMapper::mapEclipseArtifactToPath).distinct().collect(Collectors.toUnmodifiableList());
    }
}

