/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.utils.TemporarySpace;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Resolves and packages JVM protoc plugins from various remote and local locations")
@MojoExecutionScoped
@Named
final class JvmPluginResolver {
    private static final Set<String> ALLOWED_SCOPES = Set.of("compile", "runtime", "system");
    private static final List<String> DEFAULT_JVM_ARGS = List.of();
    private static final List<String> DEFAULT_JVM_CONFIG_ARGS = List.of("-Xshare:auto", "-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1");
    private static final Logger log = LoggerFactory.getLogger(JvmPluginResolver.class);
    private final HostSystem hostSystem;
    private final MavenArtifactPathResolver artifactPathResolver;
    private final TemporarySpace temporarySpace;
    private final SystemPathBinaryResolver pathResolver;

    @Inject
    JvmPluginResolver(HostSystem hostSystem, MavenArtifactPathResolver artifactPathResolver, TemporarySpace temporarySpace, SystemPathBinaryResolver pathResolver) {
        this.hostSystem = hostSystem;
        this.artifactPathResolver = artifactPathResolver;
        this.temporarySpace = temporarySpace;
        this.pathResolver = pathResolver;
    }

    Collection<? extends ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> pluginDescriptors) throws ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        int index = 0;
        for (MavenProtocPlugin mavenProtocPlugin : pluginDescriptors) {
            if (mavenProtocPlugin.isSkip()) {
                log.info("Skipping plugin {}", (Object)mavenProtocPlugin);
                continue;
            }
            ResolvedProtocPlugin resolvedPlugin = this.resolveMavenPlugin(mavenProtocPlugin, index++);
            resolvedPlugins.add(resolvedPlugin);
        }
        return Collections.unmodifiableList(resolvedPlugins);
    }

    private ResolvedProtocPlugin resolveMavenPlugin(MavenProtocPlugin pluginDescriptor, int index) throws ResolutionException {
        log.debug("Resolving JVM-based Maven protoc plugin {} and generating OS-specific bootstrap scripts", (Object)pluginDescriptor);
        String id = this.hashPlugin(pluginDescriptor, index);
        ArgumentFileBuilder argLine = this.buildArgLine(pluginDescriptor);
        Path javaPath = this.hostSystem.getJavaExecutablePath();
        Path scratchDir = this.temporarySpace.createTemporarySpace("plugins", "jvm", id);
        log.debug("Arguments for JVM plugin {} (id {}) are:\n{}", new Object[]{pluginDescriptor, id, argLine});
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsScripts(javaPath, scratchDir, argLine) : this.writePosixScripts(javaPath, scratchDir, argLine);
        return ImmutableResolvedProtocPlugin.builder().id(id).path(scriptPath).options(pluginDescriptor.getOptions()).order(pluginDescriptor.getOrder()).build();
    }

    private String hashPlugin(MavenProtocPlugin plugin, int index) {
        return Digests.sha1(plugin.toString()) + "-" + index;
    }

    private ArgumentFileBuilder buildArgLine(MavenProtocPlugin plugin) throws ResolutionException {
        List<Path> dependencies = this.artifactPathResolver.resolveDependencies(List.of(plugin), DependencyResolutionDepth.TRANSITIVE, ALLOWED_SCOPES, false, true).stream().collect(Collectors.toUnmodifiableList());
        ArgumentFileBuilder args = new ArgumentFileBuilder();
        args.add("-classpath");
        args.add(this.buildJavaPath(dependencies));
        List<Path> modules = this.findJavaModules(dependencies);
        if (!modules.isEmpty()) {
            args.add("--module-path");
            args.add(this.buildJavaPath(modules));
        }
        Objects.requireNonNullElse(plugin.getJvmConfigArgs(), DEFAULT_JVM_CONFIG_ARGS).stream().filter(this.checkValidJvmConfigArg(plugin)).forEach(args::add);
        args.add(this.determineMainClass(plugin, dependencies.get(0)));
        Objects.requireNonNullElse(plugin.getJvmArgs(), DEFAULT_JVM_ARGS).forEach(args::add);
        return args;
    }

    private String determineMainClass(MavenProtocPlugin plugin, Path pluginPath) throws ResolutionException {
        if (plugin.getMainClass() != null) {
            log.debug("Using user-provided main class for {}", (Object)plugin);
            return plugin.getMainClass();
        }
        if (!Files.isDirectory(pluginPath, new LinkOption[0])) {
            String mainClass = this.tryToDetermineMainClassFromJarManifest(pluginPath);
            if (mainClass == null) {
                log.warn("No Main-Class manifest attribute found in {}, this is probably a bug with how that JAR was built", (Object)pluginPath);
            } else {
                log.debug("Determined main class to be {} from manifest for {}", (Object)mainClass, (Object)pluginPath);
                return mainClass;
            }
        }
        throw new IllegalArgumentException("No main class was described for " + String.valueOf(pluginPath) + ", please provide an explicit 'mainClass' attribute when configuring the " + plugin.getArtifactId() + " JVM plugin");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private @Nullable String tryToDetermineMainClassFromJarManifest(Path pluginPath) throws ResolutionException {
        try (FileSystem zip = FileUtils.openZipAsFileSystem(pluginPath);){
            String string;
            block14: {
                InputStream manifestStream = Files.newInputStream(zip.getPath("META-INF", "MANIFEST.MF"), new OpenOption[0]);
                try {
                    string = new Manifest(manifestStream).getMainAttributes().getValue("Main-Class");
                    if (manifestStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (manifestStream != null) {
                        try {
                            manifestStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                manifestStream.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to determine the main class in the MANIFEST.MF for JAR corresponding to " + String.valueOf(pluginPath) + ": an unexpected IO error occurred", ex);
        }
    }

    private String buildJavaPath(Iterable<Path> iterable) {
        Iterator<Path> iterator = iterable.iterator();
        StringBuilder sb = new StringBuilder().append(iterator.next());
        while (iterator.hasNext()) {
            sb.append(this.hostSystem.getPathSeparator()).append(iterator.next());
        }
        return sb.toString();
    }

    private List<Path> findJavaModules(List<Path> paths) {
        return ModuleFinder.of((Path[])paths.toArray(Path[]::new)).findAll().stream().map(ModuleReference::location).flatMap(Optional::stream).map(Path::of).map(FileUtils::normalize).peek(modulePath -> log.trace("Looks like {} is a JPMS module!", modulePath)).sorted(Comparator.comparing(Path::toString)).collect(Collectors.toUnmodifiableList());
    }

    private Predicate<String> checkValidJvmConfigArg(MavenProtocPlugin plugin) {
        return arg -> {
            if (arg.startsWith("-") && arg.length() > 1) {
                return true;
            }
            log.warn("Dropping illegal JVM argument '{}' for Maven plugin '{}'", arg, (Object)plugin.getArtifactId());
            return false;
        };
    }

    private Path writePosixScripts(Path javaExecutable, Path scratchDir, ArgumentFileBuilder argFileBuilder) throws ResolutionException {
        Path sh = this.pathResolver.resolve("sh").orElseThrow();
        Path argumentFile = this.writeArgumentFile(StandardCharsets.UTF_8, scratchDir, argFileBuilder);
        Path script = scratchDir.resolve("invoke.sh");
        JvmPluginResolver.writeAndPropagateExceptions(script, StandardCharsets.UTF_8, true, writer -> {
            writer.append("#!").append(sh.toString()).append('\n').append("set -o errexit\n");
            this.quoteShellArg(writer, javaExecutable.toString());
            writer.append(' ');
            this.quoteShellArg(writer, "@" + String.valueOf(argumentFile));
            writer.append('\n');
        });
        return script;
    }

    private Path writeWindowsScripts(Path javaExecutable, Path scratchDir, ArgumentFileBuilder argFileBuilder) throws ResolutionException {
        Path argumentFile = this.writeArgumentFile(StandardCharsets.ISO_8859_1, scratchDir, argFileBuilder);
        Path script = scratchDir.resolve("invoke.bat");
        JvmPluginResolver.writeAndPropagateExceptions(script, StandardCharsets.ISO_8859_1, false, writer -> {
            writer.append("@echo off\r\n");
            this.quoteBatchArg(writer, javaExecutable.toString());
            writer.append(" ");
            this.quoteBatchArg(writer, "@" + String.valueOf(argumentFile));
            writer.append("\r\n");
        });
        return script;
    }

    private Path writeArgumentFile(Charset charset, Path scratchDir, ArgumentFileBuilder argumentFileBuilder) throws ResolutionException {
        Path argumentFile = scratchDir.resolve("args.txt");
        JvmPluginResolver.writeAndPropagateExceptions(argumentFile, charset, false, argumentFileBuilder::writeToJavaArgumentFile);
        return argumentFile;
    }

    private void quoteShellArg(Appendable appendable, String arg) throws IOException {
        appendable.append('\'');
        block7: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\\': {
                    appendable.append("\\\\");
                    continue block7;
                }
                case '\'': {
                    appendable.append("'\"'\"'");
                    continue block7;
                }
                case '\n': {
                    appendable.append("'$'\\n''");
                    continue block7;
                }
                case '\r': {
                    appendable.append("'$'\\r''");
                    continue block7;
                }
                case '\t': {
                    appendable.append("'$'\\t''");
                    continue block7;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
        appendable.append('\'');
    }

    private void quoteBatchArg(Appendable appendable, String arg) throws IOException {
        appendable.append("\"").append(arg.replaceAll("\"", "\"\"\"")).append("\"");
    }

    private static void writeAndPropagateExceptions(Path file, Charset charset, boolean makeExecutable, WriteOperation writeOperation) throws ResolutionException {
        try {
            try (BufferedWriter writer = Files.newBufferedWriter(file, charset, new OpenOption[0]);){
                writeOperation.writeTo(writer);
            }
            if (makeExecutable) {
                FileUtils.makeExecutable(file);
            }
        }
        catch (IOException ex) {
            throw new ResolutionException("An unexpected IO error occurred while writing to " + String.valueOf(file), ex);
        }
    }

    @FunctionalInterface
    private static interface WriteOperation {
        public void writeTo(BufferedWriter var1) throws IOException;
    }
}

