/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.incremental.ImmutableIncrementalCache;
import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCache;
import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCacheSerializer;
import io.github.ascopes.protobufmavenplugin.utils.ConcurrentExecutor;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.TemporarySpace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class IncrementalCacheManager {
    private static final String SPEC_VERSION = "2.0";
    private static final Logger log = LoggerFactory.getLogger(IncrementalCacheManager.class);
    private final ConcurrentExecutor concurrentExecutor;
    private final TemporarySpace temporarySpace;
    private final IncrementalCacheSerializer serializedIncrementalCacheSerializer;

    @Inject
    IncrementalCacheManager(ConcurrentExecutor concurrentExecutor, TemporarySpace temporarySpace, IncrementalCacheSerializer serializedIncrementalCacheSerializer) {
        this.concurrentExecutor = concurrentExecutor;
        this.temporarySpace = temporarySpace;
        this.serializedIncrementalCacheSerializer = serializedIncrementalCacheSerializer;
    }

    public void updateIncrementalCache() throws IOException {
        Path previousCache = this.getPreviousIncrementalCachePath();
        Path nextCache = this.getNextIncrementalCachePath();
        if (Files.exists(nextCache, new LinkOption[0])) {
            log.debug("Overwriting incremental build cache at {} with {}", (Object)previousCache, (Object)nextCache);
            Files.move(nextCache, previousCache, StandardCopyOption.REPLACE_EXISTING);
        } else {
            log.debug("No new incremental cache was created, so nothing will be updated...");
        }
    }

    public Collection<Path> determineSourcesToCompile(ProjectInputListing listing) throws IOException {
        IncrementalCache nextBuildCache = this.buildIncrementalCache(listing);
        this.writeIncrementalCache(this.getNextIncrementalCachePath(), nextBuildCache);
        Optional<IncrementalCache> maybePreviousBuildCache = this.readIncrementalCache(this.getPreviousIncrementalCachePath());
        if (maybePreviousBuildCache.isEmpty()) {
            log.info("All sources will be compiled, as no previous build data was detected");
            return SourceListing.flattenSourceProtoFiles(listing.getCompilableSources());
        }
        IncrementalCache previousBuildCache = maybePreviousBuildCache.get();
        if (!previousBuildCache.getDependencies().equals(nextBuildCache.getDependencies())) {
            log.info("Detected a change in dependencies, all sources will be recompiled");
            return SourceListing.flattenSourceProtoFiles(listing.getCompilableSources());
        }
        boolean sourceFilesChanged = nextBuildCache.getSources().keySet().stream().anyMatch(this.isSourceFileDifferent(previousBuildCache, nextBuildCache));
        if (sourceFilesChanged) {
            log.info("Detected that source files have changed, all sources will be recompiled.");
            return SourceListing.flattenSourceProtoFiles(listing.getCompilableSources());
        }
        return List.of();
    }

    private Predicate<Path> isSourceFileDifferent(IncrementalCache previousBuildCache, IncrementalCache nextBuildCache) {
        return file -> !Objects.equals(previousBuildCache.getSources().get(file), nextBuildCache.getSources().get(file));
    }

    private Optional<IncrementalCache> readIncrementalCache(Path path) throws IOException {
        Optional<IncrementalCache> optional;
        block8: {
            log.debug("Reading incremental cache in from {}", (Object)path);
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                optional = Optional.of(this.serializedIncrementalCacheSerializer.deserialize(reader));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException ex) {
                    log.debug("No file found at {}", (Object)path);
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    private void writeIncrementalCache(Path path, IncrementalCache cache) throws IOException {
        log.debug("Writing incremental cache out to {}", (Object)path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.serializedIncrementalCacheSerializer.serialize(cache, writer);
        }
    }

    private IncrementalCache buildIncrementalCache(ProjectInputListing listing) {
        Iterator results = Stream.of(listing.getDependencySources(), listing.getCompilableSources()).map(this::createSerializedFileDigestsAsync).collect(this.concurrentExecutor.awaiting()).iterator();
        return ImmutableIncrementalCache.builder().dependencies((Map)results.next()).sources((Map)results.next()).build();
    }

    private FutureTask<Map<Path, String>> createSerializedFileDigestsAsync(Collection<SourceListing> listings) {
        return this.concurrentExecutor.submit(() -> listings.stream().map(SourceListing::getSourceProtoFiles).flatMap(Collection::stream).map(this::createSerializedFileDigestAsync).collect(this.concurrentExecutor.awaiting()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private FutureTask<Map.Entry<Path, String>> createSerializedFileDigestAsync(Path file) {
        return this.concurrentExecutor.submit(() -> {
            log.trace("Generating digest for {}", (Object)file);
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                String digest = Digests.sha512ForStream(inputStream);
                Map.Entry<Path, String> entry = Map.entry(file, digest);
                return entry;
            }
        });
    }

    private Path getIncrementalCacheRoot() {
        return this.temporarySpace.createTemporarySpace("incremental-build-cache", SPEC_VERSION);
    }

    private Path getPreviousIncrementalCachePath() {
        return this.getIncrementalCacheRoot().resolve("previous.json");
    }

    private Path getNextIncrementalCachePath() {
        return this.getIncrementalCacheRoot().resolve("next.json");
    }
}

