/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.MultipleFailuresException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ConcurrentExecutor {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentExecutor.class);
    private final ExecutorService executorService;

    public ConcurrentExecutor() {
        ExecutorService executorService;
        try {
            log.debug("Trying to create new Loom virtual thread pool");
            executorService = (ExecutorService)Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]).invoke(null, new Object[0]);
            log.debug("Loom virtual thread pool creation was successful!");
        }
        catch (Exception ex) {
            int concurrency = Runtime.getRuntime().availableProcessors() * 8;
            log.debug("Falling back to new work-stealing thread pool (concurrency={}, Loom is unavailable)", (Object)concurrency);
            executorService = Executors.newWorkStealingPool(concurrency);
        }
        this.executorService = executorService;
    }

    @PreDestroy
    public void destroy() throws InterruptedException {
        log.debug("Shutting down executor...");
        this.executorService.shutdown();
        log.debug("Awaiting executor termination...");
        this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        List<Runnable> remaining = this.executorService.shutdownNow();
        log.debug("Shutdown ended, stubborn remaining tasks that will be orphaned: {}", remaining);
    }

    public <R> FutureTask<R> submit(Callable<R> task) {
        FutureTask<R> futureTask = new FutureTask<R>(task);
        this.executorService.submit(futureTask);
        return futureTask;
    }

    public <R> Collector<FutureTask<R>, ?, List<R>> awaiting() {
        return Collectors.collectingAndThen(Collectors.toUnmodifiableList(), this::await);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<R> await(List<FutureTask<R>> scheduledTasks) {
        try {
            ArrayList<R> results = new ArrayList<R>();
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (FutureTask<R> task : scheduledTasks) {
                try {
                    results.add(task.get());
                }
                catch (ExecutionException ex) {
                    exceptions.add(ex.getCause());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    ArrayList<R> arrayList = results;
                    for (FutureTask<R> task2 : scheduledTasks) {
                        task2.cancel(true);
                    }
                    return arrayList;
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleFailuresException.create(exceptions);
            }
            ArrayList<R> arrayList = results;
            return arrayList;
        }
        finally {
            for (FutureTask<R> task : scheduledTasks) {
                task.cancel(true);
            }
        }
    }
}

