/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherMavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.JvmPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.protoc.ArgLineBuilder;
import io.github.ascopes.protobufmavenplugin.protoc.CommandLineExecutor;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocResolver;
import io.github.ascopes.protobufmavenplugin.sources.ProtoFileFilter;
import io.github.ascopes.protobufmavenplugin.sources.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.sources.ProtoSourceResolver;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class SourceCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeGenerator.class);
    private final MavenSession mavenSession;
    private final AetherMavenArtifactPathResolver artifactPathResolver;
    private final ProtocResolver protocResolver;
    private final BinaryPluginResolver binaryPluginResolver;
    private final JvmPluginResolver jvmPluginResolver;
    private final ProtoSourceResolver protoListingResolver;
    private final CommandLineExecutor commandLineExecutor;

    @Inject
    public SourceCodeGenerator(MavenSession mavenSession, AetherMavenArtifactPathResolver artifactPathResolver, ProtocResolver protocResolver, BinaryPluginResolver binaryPluginResolver, JvmPluginResolver jvmPluginResolver, ProtoSourceResolver protoListingResolver, CommandLineExecutor commandLineExecutor) {
        this.mavenSession = mavenSession;
        this.artifactPathResolver = artifactPathResolver;
        this.protocResolver = protocResolver;
        this.binaryPluginResolver = binaryPluginResolver;
        this.jvmPluginResolver = jvmPluginResolver;
        this.protoListingResolver = protoListingResolver;
        this.commandLineExecutor = commandLineExecutor;
    }

    public boolean generate(GenerationRequest request) throws ResolutionException, IOException {
        log.debug("Protobuf GenerationRequest is: {}", (Object)request);
        Path protocPath = this.discoverProtocPath(request);
        Collection<ResolvedProtocPlugin> resolvedPlugins = this.discoverPlugins(request);
        Collection<ProtoFileListing> sourcePaths = this.discoverCompilableSources(request);
        Collection<ProtoFileListing> importPaths = this.discoverImportPaths(sourcePaths, request);
        if (sourcePaths.isEmpty()) {
            if (request.isFailOnMissingSources()) {
                log.error("No protobuf sources found. If this is unexpected, check your configuration and try again.");
                return false;
            }
            log.warn("No protobuf sources were found. There is nothing to do!");
            return true;
        }
        if (resolvedPlugins.isEmpty() && request.getEnabledLanguages().isEmpty()) {
            if (request.isFailOnMissingTargets()) {
                log.error("No languages are enabled and no plugins found, check your configuration and try again.");
                return false;
            }
            log.warn("No languages are enabled and no plugins were found. There is nothing to do!");
            return true;
        }
        this.createOutputDirectories(request);
        ArgLineBuilder argLineBuilder = new ArgLineBuilder(protocPath).fatalWarnings(request.isFatalWarnings()).importPaths(importPaths.stream().map(ProtoFileListing::getProtoFilesRoot).collect(Collectors.toCollection(LinkedHashSet::new)));
        request.getEnabledLanguages().forEach(language -> argLineBuilder.generateCodeFor((Language)((Object)language), request.getOutputDirectory(), request.isLiteEnabled()));
        argLineBuilder.plugins(resolvedPlugins, request.getOutputDirectory());
        LinkedHashSet sourceFiles = sourcePaths.stream().map(ProtoFileListing::getProtoFiles).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        List<String> argLine = argLineBuilder.compile(sourceFiles);
        if (!this.commandLineExecutor.execute(argLine)) {
            return false;
        }
        this.registerSourceRoots(request);
        if (request.isEmbedSourcesInClassOutputs()) {
            this.embedSourcesInClassOutputs(request.getSourceRootRegistrar(), sourcePaths);
        }
        return true;
    }

    private Path discoverProtocPath(GenerationRequest request) throws ResolutionException {
        return this.protocResolver.resolve(request.getProtocVersion()).orElseThrow(() -> new ResolutionException("Protoc binary was not found"));
    }

    private Collection<ResolvedProtocPlugin> discoverPlugins(GenerationRequest request) throws IOException, ResolutionException {
        List plugins = SourceCodeGenerator.concat(this.binaryPluginResolver.resolveMavenPlugins(request.getBinaryMavenPlugins()), this.binaryPluginResolver.resolvePathPlugins(request.getBinaryPathPlugins()), this.binaryPluginResolver.resolveUrlPlugins(request.getBinaryUrlPlugins()), this.jvmPluginResolver.resolveMavenPlugins(request.getJvmMavenPlugins()));
        return plugins.stream().sorted(Comparator.comparingInt(ResolvedProtocPlugin::getOrder)).collect(Collectors.toUnmodifiableList());
    }

    private Collection<ProtoFileListing> discoverImportPaths(Collection<ProtoFileListing> sourcePathListings, GenerationRequest request) throws ResolutionException {
        List<Path> artifactPaths = this.artifactPathResolver.resolveDependencies(request.getImportDependencies(), request.getDependencyResolutionDepth(), request.getDependencyScopes(), !request.isIgnoreProjectDependencies(), request.isFailOnInvalidDependencies());
        ProtoFileFilter filter = new ProtoFileFilter();
        Collection<ProtoFileListing> importPathListings = this.protoListingResolver.createProtoFileListings(SourceCodeGenerator.concat(request.getImportPaths(), artifactPaths), filter);
        return Stream.concat(sourcePathListings.stream(), importPathListings.stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    private Collection<ProtoFileListing> discoverCompilableSources(GenerationRequest request) throws ResolutionException {
        log.debug("Discovering all compilable protobuf source files");
        ProtoFileFilter filter = new ProtoFileFilter(request.getIncludes(), request.getExcludes());
        Collection<ProtoFileListing> sourcePathsListings = this.protoListingResolver.createProtoFileListings(request.getSourceRoots(), filter);
        List<Path> sourceDependencies = this.artifactPathResolver.resolveDependencies(request.getSourceDependencies(), request.getDependencyResolutionDepth(), request.getDependencyScopes(), false, request.isFailOnInvalidDependencies());
        Collection<ProtoFileListing> sourceDependencyListings = this.protoListingResolver.createProtoFileListings(sourceDependencies, filter);
        List<ProtoFileListing> sourcePaths = SourceCodeGenerator.concat(sourcePathsListings, sourceDependencyListings);
        int sourceFileCount = sourcePaths.stream().mapToInt(sourcePath -> sourcePath.getProtoFiles().size()).sum();
        log.info("Generating source code for {} from {}", (Object)SourceCodeGenerator.pluralize(sourceFileCount, "protobuf file"), (Object)SourceCodeGenerator.pluralize(sourcePaths.size(), "source file tree"));
        return sourcePaths;
    }

    private void createOutputDirectories(GenerationRequest request) throws IOException {
        Path directory = request.getOutputDirectory();
        log.debug("Creating {}", (Object)directory);
        FileUtils.getFileExtension(directory).filter(".jar"::equalsIgnoreCase).ifPresent(ext -> {
            throw new IllegalArgumentException("The output directory '" + String.valueOf(directory) + "' cannot be a path with a JAR file extension, due to limitations with how protoc operates on file names.");
        });
        Files.createDirectories(directory, new FileAttribute[0]);
    }

    private void registerSourceRoots(GenerationRequest request) {
        Path directory = request.getOutputDirectory();
        if (request.isRegisterAsCompilationRoot()) {
            SourceRootRegistrar registrar = request.getSourceRootRegistrar();
            log.debug("Registering {} as {} compilation root in this Maven project.", (Object)directory, (Object)registrar);
            registrar.registerSourceRoot(this.mavenSession, directory);
        } else {
            log.debug("Not registering {} as a compilation root", (Object)directory);
        }
    }

    private void embedSourcesInClassOutputs(SourceRootRegistrar registrar, Collection<ProtoFileListing> listings) throws ResolutionException {
        for (ProtoFileListing listing : listings) {
            try {
                registrar.embedListing(this.mavenSession, listing);
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to embed " + String.valueOf(listing.getProtoFilesRoot()) + " into the class outputs directory", ex);
            }
        }
    }

    @SafeVarargs
    private static <T> List<T> concat(Collection<? extends T> ... collections) {
        return Stream.of(collections).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    private static String pluralize(int count, String name) {
        return count == 1 ? "1 " + name : count + " " + name + "s";
    }
}

