/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherMavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.generation.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class JvmPluginResolver {
    private static final Set<String> ALLOWED_SCOPES = Set.of("compile", "runtime", "system");
    private static final Logger log = LoggerFactory.getLogger(BinaryPluginResolver.class);
    private final HostSystem hostSystem;
    private final AetherMavenArtifactPathResolver artifactPathResolver;
    private final TemporarySpace temporarySpace;

    @Inject
    public JvmPluginResolver(HostSystem hostSystem, AetherMavenArtifactPathResolver artifactPathResolver, TemporarySpace temporarySpace) {
        this.hostSystem = hostSystem;
        this.artifactPathResolver = artifactPathResolver;
        this.temporarySpace = temporarySpace;
    }

    public Collection<ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> plugins) throws IOException, ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        for (MavenProtocPlugin mavenProtocPlugin : plugins) {
            if (mavenProtocPlugin.isSkip()) {
                log.info("Skipping plugin {}", (Object)mavenProtocPlugin);
                continue;
            }
            resolvedPlugins.add(this.resolve(mavenProtocPlugin));
        }
        return resolvedPlugins;
    }

    private ResolvedProtocPlugin resolve(MavenProtocPlugin plugin) throws IOException, ResolutionException {
        log.debug("Resolving JVM-based Maven protoc plugin {} and generating OS-specific boostrap scripts", (Object)plugin);
        String pluginId = this.pluginIdDigest(plugin);
        List<String> argLine = this.resolveAndBuildArgLine(plugin);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsBatchScript(pluginId, argLine) : this.writeShellScript(pluginId, argLine);
        return ImmutableResolvedProtocPlugin.builder().id(pluginId).path(scriptPath).options(plugin.getOptions()).order(plugin.getOrder()).build();
    }

    private List<String> resolveAndBuildArgLine(MavenProtocPlugin plugin) throws ResolutionException, IOException {
        List<Path> dependencies = this.artifactPathResolver.resolveDependencies(List.of(plugin), DependencyResolutionDepth.TRANSITIVE, ALLOWED_SCOPES, false, true);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.hostSystem.getJavaExecutablePath().toString());
        args.add("-classpath");
        args.add(this.buildJavaPath(dependencies));
        List<Path> modules = this.findJavaModules(dependencies);
        if (!modules.isEmpty()) {
            args.add("--module-path");
            args.add(this.buildJavaPath(modules));
        }
        args.add(this.determineMainClass(plugin, dependencies.get(0)));
        return Collections.unmodifiableList(args);
    }

    private String determineMainClass(MavenProtocPlugin plugin, Path pluginPath) throws IOException {
        if (plugin.getMainClass() != null) {
            log.debug("Using user-provided main class for {}", (Object)plugin);
            return plugin.getMainClass();
        }
        if (!Files.isDirectory(pluginPath, new LinkOption[0])) {
            String mainClass = this.tryToDetermineMainClassFromJarManifest(pluginPath);
            if (mainClass == null) {
                log.warn("No Main-Class manifest attribute found in {}, this is probably a bug with how that JAR was built", (Object)pluginPath);
            } else {
                log.debug("Determined main class to be {} from manifest for {}", (Object)mainClass, (Object)pluginPath);
                return mainClass;
            }
        }
        throw new IllegalArgumentException("No main class was described for " + String.valueOf(pluginPath) + ", please provide an explicit 'mainClass' attribute when configuring the " + plugin.getArtifactId() + " JVM plugin");
    }

    private @Nullable String tryToDetermineMainClassFromJarManifest(Path pluginPath) throws IOException {
        try (FileSystem zip = FileUtils.openZipAsFileSystem(pluginPath);){
            String string;
            block12: {
                InputStream manifestStream = Files.newInputStream(zip.getPath("META-INF", "MANIFEST.MF"), new OpenOption[0]);
                try {
                    string = new Manifest(manifestStream).getMainAttributes().getValue("Main-Class");
                    if (manifestStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (manifestStream != null) {
                        try {
                            manifestStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                manifestStream.close();
            }
            return string;
        }
    }

    private String buildJavaPath(Iterable<Path> iterable) {
        Iterator<Path> iterator = iterable.iterator();
        StringBuilder sb = new StringBuilder().append(iterator.next());
        while (iterator.hasNext()) {
            sb.append(this.hostSystem.getPathSeparator()).append(iterator.next());
        }
        return sb.toString();
    }

    private String pluginIdDigest(MavenProtocPlugin plugin) {
        return Digests.sha1(plugin.toString());
    }

    private Path resolvePluginScriptPath() {
        return this.temporarySpace.createTemporarySpace("plugins", "jvm");
    }

    private Path writeWindowsBatchScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".bat");
        String script = String.join((CharSequence)"\r\n", "@echo off", "", ":: ##################################################", ":: ### Generated by ascopes/protobuf-maven-plugin ###", ":: ###   Users should not invoke this script      ###", ":: ###   directly, unless they know what they are ###", ":: ###   doing.                                   ###", ":: ##################################################", "", Shlex.quoteBatchArgs(argLine), "");
        this.writeScript(fullScriptPath, script, StandardCharsets.ISO_8859_1);
        return fullScriptPath;
    }

    private Path writeShellScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".sh");
        String script = String.join((CharSequence)"\n", "#!/usr/bin/env sh", "", "##################################################", "### Generated by ascopes/protobuf-maven-plugin ###", "###   Users should not invoke this script      ###", "###   directly unless they know what they are  ###", "###   doing.                                   ###", "##################################################", "", "set -eu", "", Shlex.quoteShellArgs(argLine), "");
        this.writeScript(fullScriptPath, script, StandardCharsets.UTF_8);
        return fullScriptPath;
    }

    private void writeScript(Path path, String content, Charset charset) throws IOException {
        log.debug("Writing the following script to {} as {}:\n{}", new Object[]{path, charset, content});
        Files.writeString(path, (CharSequence)content, charset, new OpenOption[0]);
        FileUtils.makeExecutable(path);
    }

    private List<Path> findJavaModules(List<Path> paths) {
        return ModuleFinder.of((Path[])paths.toArray(Path[]::new)).findAll().stream().map(ModuleReference::location).flatMap(Optional::stream).map(Path::of).map(FileUtils::normalize).peek(modulePath -> log.debug("Looks like {} is a JPMS module!", modulePath)).collect(Collectors.toUnmodifiableList());
    }
}

