/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.generation.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import io.github.ascopes.protobufmavenplugin.utils.SystemPathBinaryResolver;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class JvmPluginResolver {
    private static final Set<String> ALLOWED_SCOPES = Set.of("compile", "runtime", "system");
    private static final List<String> DEFAULT_JVM_ARGS = List.of();
    private static final List<String> DEFAULT_JVM_CONFIG_ARGS = List.of("-Xshare:auto", "-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1");
    private static final Logger log = LoggerFactory.getLogger(JvmPluginResolver.class);
    private final HostSystem hostSystem;
    private final MavenArtifactPathResolver artifactPathResolver;
    private final TemporarySpace temporarySpace;
    private final SystemPathBinaryResolver pathResolver;

    @Inject
    public JvmPluginResolver(HostSystem hostSystem, MavenArtifactPathResolver artifactPathResolver, TemporarySpace temporarySpace, SystemPathBinaryResolver pathResolver) {
        this.hostSystem = hostSystem;
        this.artifactPathResolver = artifactPathResolver;
        this.temporarySpace = temporarySpace;
        this.pathResolver = pathResolver;
    }

    public Collection<? extends ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> pluginDescriptors) throws IOException, ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        for (MavenProtocPlugin mavenProtocPlugin : pluginDescriptors) {
            if (mavenProtocPlugin.isSkip()) {
                log.info("Skipping plugin {}", (Object)mavenProtocPlugin);
                continue;
            }
            ResolvedProtocPlugin resolvedPlugin = this.resolveMavenPlugin(mavenProtocPlugin);
            resolvedPlugins.add(resolvedPlugin);
        }
        return Collections.unmodifiableList(resolvedPlugins);
    }

    private ResolvedProtocPlugin resolveMavenPlugin(MavenProtocPlugin pluginDescriptor) throws IOException, ResolutionException {
        log.debug("Resolving JVM-based Maven protoc plugin {} and generating OS-specific boostrap scripts", (Object)pluginDescriptor);
        String id = this.hashPlugin(pluginDescriptor);
        ArgumentFileBuilder argLine = this.buildArgLine(pluginDescriptor);
        Path javaPath = this.hostSystem.getJavaExecutablePath();
        Path scratchDir = this.temporarySpace.createTemporarySpace("plugins", "jvm", id);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsScripts(id, javaPath, scratchDir, argLine) : this.writePosixScripts(id, javaPath, scratchDir, argLine);
        return ImmutableResolvedProtocPlugin.builder().id(id).path(scriptPath).options(pluginDescriptor.getOptions()).order(pluginDescriptor.getOrder()).build();
    }

    private ArgumentFileBuilder buildArgLine(MavenProtocPlugin plugin) throws ResolutionException, IOException {
        List<Path> dependencies = this.artifactPathResolver.resolveDependencies(List.of(plugin), DependencyResolutionDepth.TRANSITIVE, ALLOWED_SCOPES, false, true).stream().collect(Collectors.toUnmodifiableList());
        ArgumentFileBuilder args = new ArgumentFileBuilder();
        args.add("-classpath");
        args.add(this.buildJavaPath(dependencies));
        List<Path> modules = this.findJavaModules(dependencies);
        if (!modules.isEmpty()) {
            args.add("--module-path");
            args.add(this.buildJavaPath(modules));
        }
        Objects.requireNonNullElse(plugin.getJvmConfigArgs(), DEFAULT_JVM_CONFIG_ARGS).stream().filter(this.checkValidJvmConfigArg(plugin)).forEach(args::add);
        args.add(this.determineMainClass(plugin, dependencies.get(0)));
        Objects.requireNonNullElse(plugin.getJvmArgs(), DEFAULT_JVM_ARGS).forEach(args::add);
        return args;
    }

    private String determineMainClass(MavenProtocPlugin plugin, Path pluginPath) throws IOException {
        if (plugin.getMainClass() != null) {
            log.debug("Using user-provided main class for {}", (Object)plugin);
            return plugin.getMainClass();
        }
        if (!Files.isDirectory(pluginPath, new LinkOption[0])) {
            String mainClass = this.tryToDetermineMainClassFromJarManifest(pluginPath);
            if (mainClass == null) {
                log.warn("No Main-Class manifest attribute found in {}, this is probably a bug with how that JAR was built", (Object)pluginPath);
            } else {
                log.debug("Determined main class to be {} from manifest for {}", (Object)mainClass, (Object)pluginPath);
                return mainClass;
            }
        }
        throw new IllegalArgumentException("No main class was described for " + String.valueOf(pluginPath) + ", please provide an explicit 'mainClass' attribute when configuring the " + plugin.getArtifactId() + " JVM plugin");
    }

    private @Nullable String tryToDetermineMainClassFromJarManifest(Path pluginPath) throws IOException {
        try (FileSystem zip = FileUtils.openZipAsFileSystem(pluginPath);){
            String string;
            block12: {
                InputStream manifestStream = Files.newInputStream(zip.getPath("META-INF", "MANIFEST.MF"), new OpenOption[0]);
                try {
                    string = new Manifest(manifestStream).getMainAttributes().getValue("Main-Class");
                    if (manifestStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (manifestStream != null) {
                        try {
                            manifestStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                manifestStream.close();
            }
            return string;
        }
    }

    private String buildJavaPath(Iterable<Path> iterable) {
        Iterator<Path> iterator = iterable.iterator();
        StringBuilder sb = new StringBuilder().append(iterator.next());
        while (iterator.hasNext()) {
            sb.append(this.hostSystem.getPathSeparator()).append(iterator.next());
        }
        return sb.toString();
    }

    private List<Path> findJavaModules(List<Path> paths) {
        return ModuleFinder.of((Path[])paths.toArray(Path[]::new)).findAll().stream().map(ModuleReference::location).flatMap(Optional::stream).map(Path::of).map(FileUtils::normalize).peek(modulePath -> log.debug("Looks like {} is a JPMS module!", modulePath)).sorted(Comparator.comparing(Path::toString)).collect(Collectors.toUnmodifiableList());
    }

    private Predicate<String> checkValidJvmConfigArg(MavenProtocPlugin plugin) {
        return arg -> {
            if (arg.startsWith("-") && arg.length() > 1) {
                return true;
            }
            log.warn("Dropping illegal JVM argument '{}' for Maven plugin {}", arg, (Object)plugin.getArtifactId());
            return false;
        };
    }

    private Path writePosixScripts(String id, Path javaExecutable, Path scratchDir, ArgumentFileBuilder argumentFileBuilder) throws IOException, ResolutionException {
        Path sh = this.pathResolver.resolve("sh").orElseThrow();
        Path argLineFile = this.writeArgLineFile(id, StandardCharsets.UTF_8, scratchDir, argumentFileBuilder);
        Path file = scratchDir.resolve("invoke.sh");
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
            writer.write("#!");
            writer.write(sh.toString());
            writer.write("\n");
            writer.write("set -o errexit");
            writer.write("\n");
            writer.write(Shlex.quoteShellArgs(List.of(javaExecutable.toString(), "@" + String.valueOf(argLineFile))));
            writer.write("\n");
        }
        FileUtils.makeExecutable(file);
        return file;
    }

    private Path writeWindowsScripts(String id, Path javaExecutable, Path scratchDir, ArgumentFileBuilder argumentFileBuilder) throws IOException {
        Path argLineFile = this.writeArgLineFile(id, StandardCharsets.ISO_8859_1, scratchDir, argumentFileBuilder);
        Path file = scratchDir.resolve("invoke.bat");
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.ISO_8859_1, StandardOpenOption.CREATE_NEW);){
            writer.write("@echo off");
            writer.write("\r\n");
            writer.write(Shlex.quoteBatchArgs(List.of(javaExecutable.toString(), "@" + String.valueOf(argLineFile))));
            writer.write("\r\n");
        }
        return file;
    }

    private Path writeArgLineFile(String id, Charset charset, Path scratchDir, ArgumentFileBuilder argumentFileBuilder) throws IOException {
        Path file = scratchDir.resolve("args.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, StandardOpenOption.CREATE_NEW);){
            argumentFileBuilder.write(writer);
        }
        return file;
    }

    private String hashPlugin(MavenProtocPlugin plugin) {
        return Digests.sha1(plugin.toString());
    }
}

