/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class CommandLineExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandLineExecutor.class);
    private final HostSystem hostSystem;

    @Inject
    public CommandLineExecutor(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    public boolean execute(List<String> args) throws IOException {
        this.reportInvocation(args);
        ProcessBuilder procBuilder = new ProcessBuilder(args);
        procBuilder.environment().putAll(System.getenv());
        try {
            return this.run(procBuilder);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Execution was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private void reportInvocation(List<String> args) {
        String renderedCommandLine = this.hostSystem.isProbablyWindows() ? Shlex.quoteBatchArgs(args) : Shlex.quoteShellArgs(args);
        log.info("Calling protoc with the following invocation:");
        renderedCommandLine.lines().map("  "::concat).map(String::stripTrailing).forEach(arg_0 -> ((Logger)log).info(arg_0));
    }

    private boolean run(ProcessBuilder procBuilder) throws InterruptedException, IOException {
        long startTimeNs = System.nanoTime();
        Process proc = procBuilder.start();
        Thread stdoutThread = this.redirectOutput(proc.getInputStream(), arg_0 -> ((Logger)log).info(arg_0));
        Thread stderrThread = this.redirectOutput(proc.getErrorStream(), arg_0 -> ((Logger)log).warn(arg_0));
        int exitCode = proc.waitFor();
        long elapsedTimeMs = (System.nanoTime() - startTimeNs) / 1000000L;
        stdoutThread.join();
        stderrThread.join();
        if (exitCode == 0) {
            log.info("protoc returned exit code 0 (success) after {}ms", (Object)elapsedTimeMs);
            return true;
        }
        log.error("protoc returned exit code {} (error) after {}ms", (Object)exitCode, (Object)elapsedTimeMs);
        return false;
    }

    private Thread redirectOutput(InputStream stream, Consumer<String> logger) {
        Thread thread = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.accept(line.stripTrailing());
                }
            }
            catch (IOException ex) {
                log.error("Stream error, output will be discarded", (Throwable)ex);
            }
        });
        thread.setDaemon(true);
        thread.setName("protoc output redirector thread for " + String.valueOf(stream));
        thread.start();
        return thread;
    }
}

