/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class ArgumentFileBuilder {
    private final List<String> arguments = new ArrayList<String>();

    public ArgumentFileBuilder add(Object argument) {
        this.arguments.add(argument.toString());
        return this;
    }

    public void write(Writer writer) throws IOException {
        for (String argument : this.arguments) {
            if (argument.chars().noneMatch(c -> " \n\r\t'\"".indexOf(c) >= 0)) {
                writer.append(argument).append("\n");
                continue;
            }
            writer.append('\"');
            block9: for (int i = 0; i < argument.length(); ++i) {
                char nextChar = argument.charAt(i);
                switch (nextChar) {
                    case '\"': {
                        writer.append("\\\"");
                        continue block9;
                    }
                    case '\'': {
                        writer.append("\\'");
                        continue block9;
                    }
                    case '\\': {
                        writer.append("\\\\");
                        continue block9;
                    }
                    case '\n': {
                        writer.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        writer.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        writer.append("\\t");
                        continue block9;
                    }
                    default: {
                        writer.append(nextChar);
                    }
                }
            }
            writer.append("\"\n");
        }
    }
}

