/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Shlex {
    private static final int LINE_LENGTH_TARGET = 99;
    private static final String INDENT = " ".repeat(4);

    private Shlex() {
    }

    public static String quoteShellArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex.quoter(Shlex::isSafe, Shlex::quoteShellArg), " \\\n");
    }

    public static String quoteBatchArgs(Iterable<String> args) {
        return Shlex.quote(args, Shlex.quoter(Shlex::isSafe, Shlex::quoteBatchArg), " ^\r\n");
    }

    private static String quote(Iterable<String> args, Function<String, String> quoter, String continuation) {
        Iterator<String> iter = args.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(quoter.apply(iter.next()));
        int lineLength = sb.length();
        while (iter.hasNext()) {
            String next = quoter.apply(iter.next());
            if (lineLength + next.length() >= 99) {
                sb.append(continuation);
                lineLength = INDENT.length();
                sb.append(INDENT);
            } else {
                sb.append(" ");
                ++lineLength;
            }
            sb.append(next);
            lineLength += next.length();
        }
        return sb.toString();
    }

    private static Function<String, String> quoter(Predicate<String> safeCheck, Function<String, String> rawQuoter) {
        return string -> safeCheck.test((String)string) ? string : (String)rawQuoter.apply((String)string);
    }

    private static String quoteShellArg(String arg) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        block7: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\'': {
                    sb.append("'\"'\"'");
                    continue block7;
                }
                case '\n': {
                    sb.append("'$'\\n''");
                    continue block7;
                }
                case '\r': {
                    sb.append("'$'\\r''");
                    continue block7;
                }
                case '\t': {
                    sb.append("'$'\\t''");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append('\'').toString();
    }

    private static String quoteBatchArg(String arg) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block5: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\"\"\"");
                    continue block5;
                }
                case '%': {
                    sb.append("%%");
                    continue block5;
                }
                case '\t': 
                case '\r': 
                case '&': 
                case '<': 
                case '>': 
                case '^': 
                case '|': {
                    sb.append('^').append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append('\"').toString();
    }

    private static boolean isSafe(String arg) {
        for (int i = 0; i < arg.length(); ++i) {
            boolean safe;
            char c = arg.charAt(i);
            boolean bl = safe = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '/' || c == '_' || c == '.' || c == '=';
            if (safe) continue;
            return false;
        }
        return true;
    }
}

